/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.iterable;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.burningwave.core.iterable.IterableObjectHelper;

class IterationConfigImpl<I, D>
implements IterableObjectHelper.IterationConfig<I, D, IterationConfigImpl<I, D>> {
    static final Object NO_ITEMS = new Object();
    Object items;
    Object action;
    Object output;
    Predicate<D> predicateForParallelIteration;
    Integer priority;

    public IterationConfigImpl(Object items) {
        if (items == null) {
            throw new IllegalArgumentException("Input collection or array could not be null");
        }
        this.items = items;
    }

    public <O> IterationConfigImpl<I, D> withAction(BiConsumer<I, Consumer<Consumer<O>>> action) {
        this.action = action;
        return this;
    }

    @Override
    public IterationConfigImpl<I, D> withAction(Consumer<I> action) {
        BiConsumer<Object, Consumer> newAction;
        this.action = newAction = (item, outputItemCollector) -> action.accept(item);
        return this;
    }

    @Override
    public IterationConfigImpl<I, D> withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public IterationConfigImpl<I, D> parallelIf(Predicate<D> predicate) {
        this.predicateForParallelIteration = predicate;
        return this;
    }

    IterationConfigImpl<I, D> setOutput(Object output) {
        if (this.output != null) {
            throw new IllegalArgumentException("Could not set output twice");
        }
        this.output = output;
        return this;
    }

    @Override
    public <O> IterableObjectHelper.IterationConfig.WithOutputOfCollection<I, D, O> withOutput(Collection<O> output) {
        return new IterableObjectHelper.IterationConfig.WithOutputOfCollection(this.setOutput(output));
    }

    @Override
    public <K, O> IterableObjectHelper.IterationConfig.WithOutputOfMap<I, D, K, O> withOutput(Map<K, O> output) {
        return new IterableObjectHelper.IterationConfig.WithOutputOfMap(this.setOutput(output));
    }

    static abstract class WithOutput<I, D, W extends WithOutput<I, D, W>>
    implements IterableObjectHelper.IterationConfig<I, D, W> {
        IterationConfigImpl<I, D> wrappedConfiguration;

        WithOutput(IterationConfigImpl<I, D> configuration) {
            this.wrappedConfiguration = configuration;
        }

        @Override
        public W withAction(Consumer<I> action) {
            this.wrappedConfiguration.withAction((Consumer)action);
            return (W)this;
        }

        @Override
        public <O> IterableObjectHelper.IterationConfig.WithOutputOfCollection<I, D, O> withOutput(Collection<O> output) {
            this.wrappedConfiguration.setOutput(output);
            return new IterableObjectHelper.IterationConfig.WithOutputOfCollection(this.wrappedConfiguration);
        }

        @Override
        public <K, O> IterableObjectHelper.IterationConfig.WithOutputOfMap<I, D, K, O> withOutput(Map<K, O> output) {
            this.wrappedConfiguration.setOutput(output);
            return new IterableObjectHelper.IterationConfig.WithOutputOfMap(this.wrappedConfiguration);
        }

        @Override
        public W parallelIf(Predicate<D> predicate) {
            this.wrappedConfiguration.parallelIf((Predicate)predicate);
            return (W)this;
        }

        @Override
        public W withPriority(Integer priority) {
            this.wrappedConfiguration.withPriority(priority);
            return (W)this;
        }

        IterationConfigImpl<I, D> getWrappedConfiguration() {
            return this.wrappedConfiguration;
        }
    }
}

