/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.concurrent;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.burningwave.core.Closeable;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.concurrent.Thread;
import org.burningwave.core.function.ThrowingRunnable;
import org.burningwave.core.function.ThrowingSupplier;

public class Synchronizer
implements Closeable,
ManagedLogger {
    Map<String, Mutex> mutexes;
    String name;
    ThreadsMonitorer allThreadsMonitorer;

    private Synchronizer(String name) {
        this.name = name;
        this.mutexes = new ConcurrentHashMap<String, Mutex>();
    }

    public static Synchronizer create(String name, boolean undestroyable) {
        if (undestroyable) {
            return new Synchronizer(name){
                StackTraceElement[] stackTraceOnCreation = Thread.currentThread().getStackTrace();

                @Override
                public void close() {
                    if (StaticComponentContainer.Methods.retrieveExternalCallerInfo().getClassName().equals(StaticComponentContainer.Methods.retrieveExternalCallerInfo(this.stackTraceOnCreation).getClassName())) {
                        super.close();
                    }
                }
            };
        }
        return new Synchronizer(name);
    }

    public Mutex getMutex(String id) {
        Mutex oldMutex;
        Mutex newMutex = new Mutex(id);
        do {
            if ((oldMutex = this.mutexes.putIfAbsent(id, newMutex)) != null) continue;
            return newMutex;
        } while (++oldMutex.clientsCount <= 1 || this.mutexes.get(id) != oldMutex);
        return oldMutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String id, Runnable executable) {
        try (Mutex mutex = this.getMutex(id);){
            Mutex mutex2 = mutex;
            synchronized (mutex2) {
                executable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> void executeThrower(String id, ThrowingRunnable<E> executable) throws E {
        try (Mutex mutex = this.getMutex(id);){
            Mutex mutex2 = mutex;
            synchronized (mutex2) {
                executable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String id, Supplier<T> executable) {
        try (Mutex mutex = this.getMutex(id);){
            Mutex mutex2 = mutex;
            synchronized (mutex2) {
                T t = executable.get();
                return t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T executeThrower(String id, ThrowingSupplier<T, E> executable) throws E {
        try (Mutex mutex = this.getMutex(id);){
            Mutex mutex2 = mutex;
            synchronized (mutex2) {
                T t = executable.get();
                return t;
            }
        }
    }

    public void clear() {
        this.mutexes.clear();
    }

    @Override
    public void close() {
        if (this.allThreadsMonitorer != null) {
            this.allThreadsMonitorer.close();
            this.allThreadsMonitorer = null;
        }
        this.clear();
        this.mutexes = null;
    }

    public void logAllThreadsState(boolean logMutexes) {
        StaticComponentContainer.ManagedLoggersRepository.logInfo(() -> this.getClass().getName(), this.getAllThreadsInfoAsString(logMutexes));
    }

    public String getAllThreadsInfoAsString(boolean getMutexesInfo) {
        StringBuffer log = new StringBuffer("\n\n");
        log.append("Current threads state: \n\n");
        Iterator<Map.Entry<java.lang.Thread, StackTraceElement[]>> allStackTracesItr = java.lang.Thread.getAllStackTraces().entrySet().iterator();
        while (allStackTracesItr.hasNext()) {
            Map.Entry<java.lang.Thread, StackTraceElement[]> threadAndStackTrace = allStackTracesItr.next();
            log.append("\t" + threadAndStackTrace.getKey());
            log.append(StaticComponentContainer.Strings.from(threadAndStackTrace.getValue(), 2));
            if (!allStackTracesItr.hasNext()) continue;
            log.append("\n\n");
        }
        log.append("\n\n\n");
        log.append(StaticComponentContainer.Strings.compile("Mutexes count: {}", this.mutexes.size()));
        if (getMutexesInfo) {
            log.append(":\n" + StaticComponentContainer.IterableObjectHelper.toString(this.mutexes, key -> key, value -> "" + value.clientsCount + " clients", 1));
        }
        log.append("\n");
        return log.toString();
    }

    public Set<java.lang.Thread> getAllThreads() {
        return java.lang.Thread.getAllStackTraces().keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAllThreadsMonitoring(Long interval) {
        ThreadsMonitorer allThreadsMonitorer = this.allThreadsMonitorer;
        if (allThreadsMonitorer == null) {
            Synchronizer synchronizer = this;
            synchronized (synchronizer) {
                allThreadsMonitorer = this.allThreadsMonitorer;
                if (allThreadsMonitorer == null) {
                    this.allThreadsMonitorer = new ThreadsMonitorer(this);
                }
            }
        }
        this.allThreadsMonitorer.start(interval);
    }

    public void stopAllThreadsMonitoring() {
        this.stopAllThreadsMonitoring(false);
    }

    public void stopAllThreadsMonitoring(boolean waitThreadToFinish) {
        ThreadsMonitorer allThreadsMonitorer = this.allThreadsMonitorer;
        if (allThreadsMonitorer != null) {
            allThreadsMonitorer.stop(waitThreadToFinish);
        }
    }

    public class Mutex
    implements java.io.Closeable {
        String id;
        int clientsCount = 1;

        Mutex(String id) {
            this.id = id;
        }

        @Override
        public void close() {
            if (--this.clientsCount < 1) {
                Synchronizer.this.mutexes.remove(this.id);
            }
        }
    }

    static class ThreadsMonitorer
    implements Closeable {
        Synchronizer synchronizer;

        ThreadsMonitorer(Synchronizer synchronizer) {
            this.synchronizer = synchronizer;
        }

        public ThreadsMonitorer start(Long interval) {
            StaticComponentContainer.ThreadHolder.startLooping(this.getName(), true, 1, thread -> {
                thread.waitFor(interval);
                if (thread.isLooping()) {
                    this.synchronizer.logAllThreadsState(false);
                }
            });
            return this;
        }

        private String getName() {
            return Optional.ofNullable(this.synchronizer.name).map(nm -> nm + " - ").orElseGet(() -> "") + "All threads state logger";
        }

        public void stop(boolean waitThreadToFinish) {
            StaticComponentContainer.ThreadHolder.stop(this.getName());
        }

        @Override
        public void close() {
            this.close(false);
        }

        public void close(boolean waitForTasksTermination) {
            this.stop(waitForTasksTermination);
            this.synchronizer = null;
        }
    }
}

