/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.ThrowingBiFunction;
import org.burningwave.core.function.ThrowingFunction;

public abstract class PropertyAccessor
implements Component {
    public static final String REG_EXP_FOR_JAVA_PROPERTIES = "([a-zA-Z\\$\\_\\-0-9]*)(\\[*.*)";
    public static final String REG_EXP_FOR_INDEXES_OF_JAVA_INDEXED_PROPERTIES = "\\[([a-zA-Z0-9]*)\\]";
    private List<ThrowingBiFunction<Object, String, Object, Throwable>> propertyRetrievers = this.getPropertyRetrievers();
    private List<ThrowingFunction<Object[], Boolean, Throwable>> propertySetters = this.getPropertySetters();

    PropertyAccessor() {
    }

    abstract List<ThrowingFunction<Object[], Boolean, Throwable>> getPropertySetters();

    abstract List<ThrowingBiFunction<Object, String, Object, Throwable>> getPropertyRetrievers();

    public <T> T get(Object obj, String propertyPath) {
        String[] propertyAddress = propertyPath.split("\\.");
        Object objToReturn = obj;
        for (int j = 0; j < propertyAddress.length; ++j) {
            objToReturn = this.getProperty(j != 0 ? objToReturn : obj, propertyAddress[j]);
        }
        return (T)objToReturn;
    }

    private Object getProperty(Object obj, String property) {
        Object objToReturn = null;
        Matcher matcher = Pattern.compile(REG_EXP_FOR_JAVA_PROPERTIES).matcher(property);
        matcher.find();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (ThrowingBiFunction<Object, String, Object, Throwable> retriever : this.propertyRetrievers) {
            try {
                objToReturn = retriever.apply(obj, matcher.group(1));
                if (objToReturn == null) continue;
                break;
            }
            catch (Throwable exc) {
                exceptions.add(exc);
            }
        }
        this.manageGetPropertyExceptions(exceptions);
        if (!matcher.group(2).isEmpty()) {
            objToReturn = this.retrieveFromIndexedProperty(objToReturn, matcher.group(2));
        }
        return objToReturn;
    }

    private void manageGetPropertyExceptions(List<Throwable> exceptions) {
        if (exceptions.size() > 0) {
            String message = "";
            for (Throwable exception : exceptions) {
                message = message + exception.getMessage() + "\n";
            }
            message = message.substring(0, message.length() - 1);
            if (exceptions.size() == this.propertyRetrievers.size()) {
                StaticComponentContainer.Driver.throwException((Object)message.toString(), new Object[0]);
            }
        }
    }

    public void set(Object obj, String propertyPath, Object value) {
        Object target = propertyPath.contains(".") ? this.get(obj, propertyPath.substring(0, propertyPath.lastIndexOf("."))) : obj;
        String targetPropertyName = propertyPath.contains(".") ? propertyPath.substring(propertyPath.lastIndexOf(".") + 1, propertyPath.length()) : propertyPath;
        this.setProperty(target, targetPropertyName, value);
    }

    private void setProperty(Object target, String property, Object value) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (ThrowingFunction<Object[], Boolean, Throwable> propertySetter : this.propertySetters) {
            try {
                propertySetter.apply(new Object[]{target, property, value});
                break;
            }
            catch (Throwable exc) {
                exceptions.add(exc);
            }
        }
        this.manageGetPropertyExceptions(exceptions);
    }

    private Object retrieveFromIndexedProperty(Object property, String indexes) {
        Matcher matcher = Pattern.compile(REG_EXP_FOR_INDEXES_OF_JAVA_INDEXED_PROPERTIES).matcher(indexes);
        if (matcher.find()) {
            String index = matcher.group(1);
            Supplier<Object> propertyRetriever = null;
            if (property.getClass().isArray()) {
                propertyRetriever = () -> Array.get(property, Integer.valueOf(index));
            } else if (List.class.isAssignableFrom(property.getClass())) {
                propertyRetriever = () -> ((List)property).get(Integer.valueOf(index));
            } else if (Map.class.isAssignableFrom(property.getClass())) {
                propertyRetriever = () -> ((Map)property).get(index);
            } else {
                return StaticComponentContainer.Driver.throwException((Object)"indexed property {} of type {} is not supporterd", new Object[]{property, property.getClass()});
            }
            return this.retrieveFromIndexedProperty(propertyRetriever.get(), indexes.substring(matcher.end(), indexes.length()));
        }
        return property;
    }

    Object retrievePropertyByField(Object target, String propertyName) throws IllegalAccessException {
        return StaticComponentContainer.Fields.getDirect(target, propertyName);
    }

    Object retrievePropertyByGetterMethod(Object obj, String propertyName) {
        Object objToReturn = StaticComponentContainer.Methods.invokeDirect(obj, StaticComponentContainer.Methods.createGetterMethodNameByPropertyName(propertyName), new Object[0]);
        return objToReturn;
    }

    private <T> void setInIndexedProperty(Object property, String indexes, Object value) {
        Matcher matcher = Pattern.compile(REG_EXP_FOR_INDEXES_OF_JAVA_INDEXED_PROPERTIES).matcher(indexes);
        int lastIndexOf = 0;
        String index = null;
        while (matcher.find()) {
            index = matcher.group(1);
            lastIndexOf = matcher.start();
        }
        Object targetObject = this.retrieveFromIndexedProperty(property, indexes.substring(0, lastIndexOf));
        if (targetObject.getClass().isArray()) {
            Array.set(targetObject, Integer.valueOf(index), value);
        } else if (List.class.isAssignableFrom(targetObject.getClass())) {
            ((List)targetObject).set(Integer.valueOf(index), value);
        } else if (Map.class.isAssignableFrom(property.getClass())) {
            ((Map)property).put(index, value);
        } else {
            StaticComponentContainer.Driver.throwException((Object)"indexed property {} of type {} is not supporterd", new Object[]{property, property.getClass()});
        }
    }

    Boolean setPropertyByField(Object target, String propertyPath, Object value) throws IllegalAccessException {
        Matcher matcher = Pattern.compile(REG_EXP_FOR_JAVA_PROPERTIES).matcher(propertyPath);
        matcher.find();
        Field field = StaticComponentContainer.Fields.findOneAndMakeItAccessible(target.getClass(), matcher.group(1));
        if (matcher.group(2).isEmpty()) {
            StaticComponentContainer.Fields.setDirect(target, field, value);
        } else {
            this.setInIndexedProperty(field.get(target), matcher.group(2), value);
        }
        return Boolean.TRUE;
    }

    Boolean setPropertyByMethod(Object target, String propertyPath, Object value) {
        Matcher matcher = Pattern.compile(REG_EXP_FOR_JAVA_PROPERTIES).matcher(propertyPath);
        matcher.find();
        if (matcher.group(2).isEmpty()) {
            StaticComponentContainer.Methods.invokeDirect(target, StaticComponentContainer.Methods.createSetterMethodNameByPropertyName(matcher.group(1)), value);
        } else {
            this.setInIndexedProperty(StaticComponentContainer.Methods.invokeDirect(target, StaticComponentContainer.Methods.createGetterMethodNameByPropertyName(matcher.group(1)), new Object[0]), matcher.group(2), value);
        }
        return Boolean.TRUE;
    }

    public static class ByMethodOrByField
    extends PropertyAccessor {
        private ByMethodOrByField() {
        }

        public static ByMethodOrByField create() {
            return new ByMethodOrByField();
        }

        @Override
        List<ThrowingBiFunction<Object, String, Object, Throwable>> getPropertyRetrievers() {
            ArrayList<ThrowingBiFunction<Object, String, Object, Throwable>> propertyRetrievers = new ArrayList<ThrowingBiFunction<Object, String, Object, Throwable>>();
            propertyRetrievers.add((object, propertyName) -> this.retrievePropertyByGetterMethod(object, (String)propertyName));
            propertyRetrievers.add((object, propertyName) -> this.retrievePropertyByField(object, (String)propertyName));
            return propertyRetrievers;
        }

        @Override
        List<ThrowingFunction<Object[], Boolean, Throwable>> getPropertySetters() {
            ArrayList<ThrowingFunction<Object[], Boolean, Throwable>> propertySetters = new ArrayList<ThrowingFunction<Object[], Boolean, Throwable>>();
            propertySetters.add(objects -> this.setPropertyByMethod(objects[0], (String)objects[1], objects[2]));
            propertySetters.add(objects -> this.setPropertyByField(objects[0], (String)objects[1], objects[2]));
            return propertySetters;
        }
    }

    public static class ByFieldOrByMethod
    extends PropertyAccessor {
        private ByFieldOrByMethod() {
        }

        public static ByFieldOrByMethod create() {
            return new ByFieldOrByMethod();
        }

        @Override
        List<ThrowingBiFunction<Object, String, Object, Throwable>> getPropertyRetrievers() {
            ArrayList<ThrowingBiFunction<Object, String, Object, Throwable>> propertyRetrievers = new ArrayList<ThrowingBiFunction<Object, String, Object, Throwable>>();
            propertyRetrievers.add((object, propertyName) -> this.retrievePropertyByField(object, (String)propertyName));
            propertyRetrievers.add((object, propertyName) -> this.retrievePropertyByGetterMethod(object, (String)propertyName));
            return propertyRetrievers;
        }

        @Override
        List<ThrowingFunction<Object[], Boolean, Throwable>> getPropertySetters() {
            ArrayList<ThrowingFunction<Object[], Boolean, Throwable>> propertySetters = new ArrayList<ThrowingFunction<Object[], Boolean, Throwable>>();
            propertySetters.add(objects -> this.setPropertyByField(objects[0], (String)objects[1], objects[2]));
            propertySetters.add(objects -> this.setPropertyByMethod(objects[0], (String)objects[1], objects[2]));
            return propertySetters;
        }
    }
}

