/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.Classes;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.concurrent.QueuedTasksExecutor;
import org.burningwave.core.io.ByteBufferInputStream;

public class MemoryClassLoader
extends ClassLoader
implements Component,
Classes.Loaders.NotificationListenerOfParentsChange {
    Map<String, ByteBuffer> notLoadedByteCodes;
    Map<String, ByteBuffer> loadedByteCodes;
    Collection<Object> clients;
    protected boolean isClosed;
    String instanceId = StaticComponentContainer.Objects.getCurrentId(this);
    ClassLoader[] allParents;

    protected MemoryClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
        if (parentClassLoader instanceof MemoryClassLoader) {
            ((MemoryClassLoader)parentClassLoader).register(this);
        }
        this.notLoadedByteCodes = new ConcurrentHashMap<String, ByteBuffer>();
        this.loadedByteCodes = new ConcurrentHashMap<String, ByteBuffer>();
        this.clients = new HashSet<Object>();
        StaticComponentContainer.ClassLoaders.registerNotificationListenerOfParentsChange(this);
        this.computeAllParents();
    }

    private void computeAllParents() {
        Collection<ClassLoader> allParents = StaticComponentContainer.ClassLoaders.getAllParents(this);
        this.allParents = allParents.toArray(new ClassLoader[allParents.size()]);
    }

    @Override
    public void receive(Classes.Loaders.ChangeParentsContext context) {
        this.computeAllParents();
    }

    public static MemoryClassLoader create(ClassLoader parentClassLoader) {
        return new MemoryClassLoader(parentClassLoader);
    }

    public void addByteCode(String className, ByteBuffer byteCode) {
        try {
            this.addByteCode0(className, byteCode);
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not execute addByteCode on class named {} because {} has been closed", className, this.toString());
        }
    }

    void addByteCode0(String className, ByteBuffer byteCode) {
        this.notLoadedByteCodes.put(className, byteCode);
    }

    public Map.Entry<String, ByteBuffer> getNotLoadedByteCode(String className) {
        try {
            for (Map.Entry<String, ByteBuffer> entry : this.notLoadedByteCodes.entrySet()) {
                if (!entry.getKey().equals(className)) continue;
                return entry;
            }
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not execute getNotLoadedByteCode on class named {} because {} has been closed", className, this.toString());
        }
        return null;
    }

    public ByteBuffer getByteCodeOf(String className) {
        try {
            return Optional.ofNullable(this.notLoadedByteCodes.get(className)).orElseGet(() -> Optional.ofNullable(this.loadedByteCodes.get(className)).orElseGet(() -> null));
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not execute getByteCodeOf on class named {} because {} has been closed", className, this.toString());
            return null;
        }
    }

    void addByteCodes(Map<String, ByteBuffer> byteCodes) {
        try {
            for (Map.Entry<String, ByteBuffer> clazz : byteCodes.entrySet()) {
                this.addByteCode0(clazz.getKey(), clazz.getValue());
            }
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not execute addByteCodes on {} because {} has been closed", byteCodes.toString(), this.toString());
        }
    }

    public void addByteCodes(Collection<Map.Entry<String, ByteBuffer>> classes) {
        try {
            for (Map.Entry<String, ByteBuffer> clazz : classes) {
                this.addByteCode0(clazz.getKey(), clazz.getValue());
            }
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not execute addByteCodes on {} because {} has been closed", classes.toString(), this.toString());
        }
    }

    public void addByteCodes(Map.Entry<String, ByteBuffer> ... classes) {
        try {
            for (Map.Entry<String, ByteBuffer> clazz : classes) {
                this.addByteCode0(clazz.getKey(), clazz.getValue());
            }
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not execute addByteCodes on {} because {} has been closed", classes.toString(), this.toString());
        }
    }

    public boolean hasPackageBeenDefined(String packageName) {
        return StaticComponentContainer.Strings.isEmpty(packageName) || StaticComponentContainer.ClassLoaders.retrieveLoadedPackage(this, packageName) != null;
    }

    @Override
    protected Package definePackage(String packageName, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        Package pkg = null;
        if (StaticComponentContainer.Strings.isNotEmpty(packageName)) {
            try {
                pkg = super.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
            }
            catch (IllegalArgumentException exc) {
                StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Package " + packageName + " already defined");
                pkg = StaticComponentContainer.ClassLoaders.retrieveLoadedPackage(this, packageName);
            }
        }
        return pkg;
    }

    void definePackageOf(Class<?> cls) {
        String pckgName;
        if (cls.getName().contains(".") && StaticComponentContainer.ClassLoaders.retrieveLoadedPackage(this, pckgName = cls.getName().substring(0, cls.getName().lastIndexOf("."))) == null) {
            StaticComponentContainer.Synchronizer.execute(this.instanceId + "_" + pckgName, () -> {
                if (StaticComponentContainer.ClassLoaders.retrieveLoadedPackage(this, pckgName) == null) {
                    this.definePackage(pckgName, null, null, null, null, null, null, null);
                }
            });
        }
    }

    @Override
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class cls = null;
        try {
            cls = super.loadClass(className, resolve);
        }
        catch (Throwable exc) {
            if (className.startsWith("java.")) {
                cls = StaticComponentContainer.Driver.getClassByName(className, Boolean.valueOf(false), StaticComponentContainer.Classes.getClassLoader(this.getClass()), this.getClass());
            }
            StaticComponentContainer.Driver.throwException((Object)exc, new Object[0]);
        }
        this.removeNotLoadedBytecode(className);
        return cls;
    }

    public Class<?> loadOrDefineClass(Class<?> toLoad) throws ClassNotFoundException {
        return StaticComponentContainer.ClassLoaders.loadOrDefine(toLoad, this);
    }

    public Class<?> loadOrDefineClass(JavaClass toLoad) throws ClassNotFoundException {
        return StaticComponentContainer.ClassLoaders.loadOrDefineByJavaClass(toLoad, this);
    }

    public Class<?> loadOrDefineClass(ByteBuffer byteCode) throws ClassNotFoundException {
        return StaticComponentContainer.ClassLoaders.loadOrDefineByByteCode(byteCode, this);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream inputStream = StaticComponentContainer.Resources.getAsInputStream(name, this.allParents).getValue();
        if (inputStream == null && name.endsWith(".class")) {
            inputStream = this.getByteCodeAsInputStream(name);
        }
        return inputStream;
    }

    protected InputStream getByteCodeAsInputStream(String classRelativePath) {
        ByteBuffer byteCode;
        if (classRelativePath.endsWith(".class") && (byteCode = this.getByteCode(classRelativePath)) != null) {
            return new ByteBufferInputStream(byteCode);
        }
        return null;
    }

    ByteBuffer getByteCode(String classRelativePath) {
        try {
            String className = classRelativePath.substring(0, classRelativePath.lastIndexOf(".class")).replace("/", ".");
            ByteBuffer byteCode = this.loadedByteCodes.get(className);
            if (byteCode == null) {
                byteCode = this.notLoadedByteCodes.get(className);
            }
            return byteCode;
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not execute getByteCode on {} because {} has been closed", classRelativePath, this.toString());
            return null;
        }
    }

    protected void addLoadedByteCode(String className, ByteBuffer byteCode) {
        try {
            this.loadedByteCodes.put(className, byteCode);
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not execute addLoadedByteCode on {} because {} has been closed", className, this.toString());
        }
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> cls;
        block7: {
            cls = null;
            try {
                ByteBuffer byteCode = this.notLoadedByteCodes.get(className);
                if (byteCode != null) {
                    try {
                        cls = this._defineClass(className, byteCode, null);
                        this.definePackageOf(cls);
                        break block7;
                    }
                    catch (NoClassDefFoundError exc) {
                        String notFoundClassName = StaticComponentContainer.Classes.retrieveName(exc);
                        this.removeNotLoadedBytecode(className);
                        this.logWarn(className, StaticComponentContainer.Strings.compile("Could not load class {} because class {} could not be found, so it will be removed: {}", className, notFoundClassName, exc.toString()));
                        throw exc;
                    }
                }
                this.logWarn(className, StaticComponentContainer.Strings.compile("Bytecode of class {} not found", className));
            }
            catch (Throwable exc) {
                if (this.isClosed) {
                    this.logWarn(className, StaticComponentContainer.Strings.compile("Could not load class {} because {} has been closed", className, this.toString()));
                }
                throw exc;
            }
        }
        if (cls != null) {
            return cls;
        }
        throw new ClassNotFoundException(className);
    }

    protected void logWarn(String className, String message) {
        StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> _defineClass(String className, ByteBuffer byteCode, ProtectionDomain protectionDomain) {
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            Class<?> cls = super.defineClass(className, byteCode, protectionDomain);
            this.addLoadedByteCode(className, byteCode);
            this.removeNotLoadedBytecode(className);
            return cls;
        }
    }

    public void removeNotLoadedBytecode(String className) {
        try {
            this.notLoadedByteCodes.remove(className);
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not execute removeNotLoadedBytecode on class named {} because {} has been closed", className, this.toString());
        }
    }

    Map<String, ByteBuffer> getLoadedBytecodes() {
        return this.loadedByteCodes;
    }

    public Collection<Class<?>> forceBytecodesLoading() {
        HashSet loadedClasses = new HashSet();
        for (Map.Entry<String, ByteBuffer> entry : new HashMap<String, ByteBuffer>(this.notLoadedByteCodes).entrySet()) {
            try {
                loadedClasses.add(this.loadClass(entry.getKey()));
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not load class " + entry.getKey(), exc.getMessage());
            }
        }
        return loadedClasses;
    }

    public MemoryClassLoader clear() {
        Map<String, ByteBuffer> notLoadedByteCodes = this.notLoadedByteCodes;
        Map<String, ByteBuffer> loadedByteCodes = this.loadedByteCodes;
        this.notLoadedByteCodes = new HashMap<String, ByteBuffer>();
        this.loadedByteCodes = new HashMap<String, ByteBuffer>();
        StaticComponentContainer.BackgroundExecutor.createTask(task -> {
            StaticComponentContainer.IterableObjectHelper.deepClear(notLoadedByteCodes);
            StaticComponentContainer.IterableObjectHelper.deepClear(loadedByteCodes);
        }, 1).submit();
        return this;
    }

    protected void unregister() {
        StaticComponentContainer.ClassLoaders.unregister(this);
        StaticComponentContainer.ClassLoaders.unregisterNotificationListenerOfParentsChange(this);
        StaticComponentContainer.Cache.classLoaderForConstructors.remove(this, true);
        StaticComponentContainer.Cache.classLoaderForFields.remove(this, true);
        StaticComponentContainer.Cache.classLoaderForMethods.remove(this, true);
        StaticComponentContainer.Cache.uniqueKeyForFields.remove(this, true);
        StaticComponentContainer.Cache.uniqueKeyForConstructors.remove(this, true);
        StaticComponentContainer.Cache.uniqueKeyForMethods.remove(this, true);
        StaticComponentContainer.Cache.bindedFunctionalInterfaces.remove(this, true);
        StaticComponentContainer.Cache.uniqueKeyForExecutableAndMethodHandle.remove(this, true);
    }

    public synchronized boolean register(Object client) {
        Collection<Object> clients = this.clients;
        if (!this.isClosed) {
            clients.add(client);
            return true;
        }
        return false;
    }

    public synchronized boolean unregister(Object client, boolean close) {
        Collection<Object> clients = this.clients;
        if (!this.isClosed) {
            clients.remove(client);
            if (clients.isEmpty() && close) {
                this.close();
                return true;
            }
        }
        return false;
    }

    @Override
    public void close() {
        this.closeResources();
    }

    QueuedTasksExecutor.Task closeResources() {
        return this.closeResources(MemoryClassLoader.class.getName() + "@" + System.identityHashCode(this), () -> this.isClosed, task -> {
            Collection<Object> clients = this.clients;
            if (clients != null && !clients.isEmpty()) {
                StaticComponentContainer.Driver.throwException((Object)"Could not close {} because there are {} registered clients", new Object[]{this, clients.size()});
            }
            this.isClosed = true;
            ClassLoader parentClassLoader = StaticComponentContainer.ClassLoaders.getParent(this);
            if (parentClassLoader != null && parentClassLoader instanceof MemoryClassLoader) {
                ((MemoryClassLoader)parentClassLoader).unregister(this, true);
            }
            this.clear();
            this.notLoadedByteCodes = null;
            this.loadedByteCodes = null;
            StaticComponentContainer.Driver.getLoadedClassesRetriever((ClassLoader)this).clear();
            this.unregister();
            this.clients.clear();
            this.clients = null;
        });
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

