/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ConstructorCriteria;
import org.burningwave.core.classes.Members;
import org.burningwave.core.function.Executor;

public class Constructors
extends Members.Handler.OfExecutable<Constructor<?>, ConstructorCriteria> {
    public static Constructors create() {
        return new Constructors();
    }

    public <T> T newInstanceOf(Class<?> targetClass, Object ... arguments) {
        Constructor<?> ctor = this.findFirstAndMakeItAccessible(targetClass, StaticComponentContainer.Classes.retrieveFrom(arguments));
        if (ctor == null) {
            StaticComponentContainer.Driver.throwException((Object)"Constructor not found in {}", new Object[]{targetClass.getName()});
        }
        return (T)Executor.get(() -> StaticComponentContainer.Classes.newInstance(ctor, this.getArgumentArray(ctor, this::getArgumentListWithArrayForVarArgs, ArrayList::new, arguments)));
    }

    public <T> T newInstanceDirectOf(Class<?> targetClass, Object ... arguments) {
        Class<?>[] argsType = StaticComponentContainer.Classes.retrieveFrom(arguments);
        Members.Handler.OfExecutable.Box<Constructor<?>> methodHandleBox = this.findDirectHandleBox(targetClass, argsType);
        return (T)Executor.get(() -> {
            Constructor ctor = (Constructor)methodHandleBox.getExecutable();
            return methodHandleBox.getHandler().invokeWithArguments(this.getFlatArgumentList(ctor, ArrayList::new, arguments));
        });
    }

    public Constructor<?> findOneAndMakeItAccessible(Class<?> targetClass, Class<?> ... argumentTypes) {
        Collection<Constructor<?>> members = this.findAllAndMakeThemAccessible(targetClass, argumentTypes);
        if (members.size() == 1) {
            return members.stream().findFirst().get();
        }
        if (members.size() > 1) {
            Collection<Constructor<?>> membersThatMatch = this.searchForExactMatch(members, argumentTypes);
            if (membersThatMatch.size() == 1) {
                return membersThatMatch.stream().findFirst().get();
            }
            StaticComponentContainer.Driver.throwException((Object)"Found more than one of constructor with argument types {} in {} class", new Object[]{String.join((CharSequence)", ", Arrays.asList(argumentTypes).stream().map(cls -> cls.getName()).collect(Collectors.toList())), targetClass.getName()});
        }
        return null;
    }

    public Constructor<?> findFirstAndMakeItAccessible(Class<?> targetClass, Class<?> ... inputParameterTypesOrSubTypes) {
        Collection<Constructor<?>> members = this.findAllAndMakeThemAccessible(targetClass, inputParameterTypesOrSubTypes);
        if (members.size() == 1) {
            return members.stream().findFirst().get();
        }
        if (members.size() > 1) {
            Collection<Constructor<?>> membersThatMatch = this.searchForExactMatch(members, inputParameterTypesOrSubTypes);
            if (!membersThatMatch.isEmpty()) {
                return membersThatMatch.stream().findFirst().get();
            }
            return members.stream().findFirst().get();
        }
        return null;
    }

    public Collection<Constructor<?>> findAllAndMakeThemAccessible(Class<?> targetClass, Class<?> ... inputParameterTypesOrSubTypes) {
        String cacheKey = this.getCacheKey(targetClass, "all constructors by input parameters assignable from", inputParameterTypesOrSubTypes);
        ClassLoader targetClassClassLoader = StaticComponentContainer.Classes.getClassLoader(targetClass);
        return StaticComponentContainer.Cache.uniqueKeyForConstructors.getOrUploadIfAbsent(targetClassClassLoader, cacheKey, () -> {
            ConstructorCriteria criteria = (ConstructorCriteria)ConstructorCriteria.withoutConsideringParentClasses().parameterTypesAreAssignableFrom(inputParameterTypesOrSubTypes);
            if (inputParameterTypesOrSubTypes != null && inputParameterTypesOrSubTypes.length == 0) {
                ((ConstructorCriteria)criteria.or()).parameter((parameters, idx) -> ((Parameter[])parameters).length == 1 && parameters[0].isVarArgs());
            }
            return this.findAllAndApply(criteria, targetClass, member -> this.setAccessible(member, true));
        });
    }

    public Collection<Constructor<?>> findAllAndMakeThemAccessible(Class<?> targetClass) {
        String cacheKey = this.getCacheKey(targetClass, "all constructors", new Class[0]);
        ClassLoader targetClassClassLoader = StaticComponentContainer.Classes.getClassLoader(targetClass);
        Collection members = StaticComponentContainer.Cache.uniqueKeyForConstructors.getOrUploadIfAbsent(targetClassClassLoader, cacheKey, () -> this.findAllAndApply(ConstructorCriteria.withoutConsideringParentClasses(), targetClass, member -> this.setAccessible(member, true)));
        return members;
    }

    public MethodHandle findDirectHandle(Class<?> targetClass, Class<?> ... inputParameterTypesOrSubTypes) {
        return this.findDirectHandleBox(targetClass, inputParameterTypesOrSubTypes).getHandler();
    }

    private Members.Handler.OfExecutable.Box<Constructor<?>> findDirectHandleBox(Class<?> targetClass, Class<?> ... inputParameterTypesOrSubTypes) {
        String nameForCaching = this.retrieveNameForCaching(targetClass);
        String cacheKey = this.getCacheKey(targetClass, "equals " + nameForCaching, inputParameterTypesOrSubTypes);
        ClassLoader targetClassClassLoader = StaticComponentContainer.Classes.getClassLoader(targetClass);
        Members.Handler.OfExecutable.Box<Constructor<?>> entry = StaticComponentContainer.Cache.uniqueKeyForExecutableAndMethodHandle.get(targetClassClassLoader, cacheKey);
        if (entry == null) {
            Constructor<?> ctor = this.findFirstAndMakeItAccessible(targetClass, inputParameterTypesOrSubTypes);
            entry = this.findDirectHandleBox(ctor, targetClassClassLoader, cacheKey);
        }
        return entry;
    }

    @Override
    MethodHandle retrieveMethodHandle(MethodHandles.Lookup consulter, Constructor<?> constructor) throws NoSuchMethodException, IllegalAccessException {
        return consulter.findConstructor(constructor.getDeclaringClass(), MethodType.methodType(Void.TYPE, constructor.getParameterTypes()));
    }

    @Override
    String retrieveNameForCaching(Constructor<?> constructor) {
        return this.retrieveNameForCaching(constructor.getDeclaringClass());
    }

    @Override
    String retrieveNameForCaching(Class<?> cls) {
        return StaticComponentContainer.Classes.retrieveSimpleName(cls.getName());
    }
}

