/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Arrays;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import org.burningwave.core.Component;
import org.burningwave.core.Executable;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.BodySourceGenerator;
import org.burningwave.core.classes.ClassFactory;
import org.burningwave.core.classes.ClassFactoryImpl;
import org.burningwave.core.classes.CodeExecutor;
import org.burningwave.core.classes.ExecuteConfig;
import org.burningwave.core.classes.LoadOrBuildAndDefineConfig;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.IterableObjectHelper;

public class CodeExecutorImpl
implements CodeExecutor,
Component {
    private ClassFactory classFactory;
    private PathHelper pathHelper;
    private Supplier<ClassFactory> classFactorySupplier;
    private org.burningwave.core.iterable.Properties config;

    CodeExecutorImpl(Supplier<ClassFactory> classFactorySupplier, PathHelper pathHelper, org.burningwave.core.iterable.Properties config) {
        this.classFactorySupplier = classFactorySupplier;
        this.pathHelper = pathHelper;
        this.config = config;
        this.listenTo(config);
    }

    private ClassFactory getClassFactory() {
        return this.classFactory != null ? this.classFactory : (this.classFactory = this.classFactorySupplier.get());
    }

    @Override
    public <T> T executeProperty(String propertyName, Object ... params) {
        return this.execute((ExecuteConfig)((ExecuteConfig.ForProperties)ExecuteConfig.forProperty(propertyName).withParameter(params)));
    }

    @Override
    public <E extends ExecuteConfig<E>, T> T execute(ExecuteConfig.ForProperties config) {
        String importFromConfig;
        Properties properties = config.getProperties();
        if (properties == null) {
            if (config.getFilePath() == null) {
                properties = this.config;
            } else {
                org.burningwave.core.iterable.Properties tempProperties = new org.burningwave.core.iterable.Properties();
                if (config.isAbsoluteFilePath()) {
                    Executor.run(() -> tempProperties.load(FileSystemItem.ofPath(config.getFilePath()).toInputStream()));
                } else {
                    Executor.run(() -> tempProperties.load(this.pathHelper.getResourceAsStream(config.getFilePath())));
                }
                properties = tempProperties;
            }
        }
        BodySourceGenerator body = config.getBody();
        if (config.getParams() != null && config.getParams().length > 0) {
            for (Object param : config.getParams()) {
                if (param == null) continue;
                body.useType(param.getClass());
            }
        }
        if (StaticComponentContainer.Strings.isNotEmpty(importFromConfig = this.retrieveValue(config, properties, ".imports", ".supplier.imports", ".executor.imports"))) {
            Arrays.stream(importFromConfig.replaceAll(";{2,}", ";").split(";")).forEach(imp -> {
                if (StaticComponentContainer.Strings.isNotEmpty((String)imp)) {
                    body.useType((String)imp);
                }
            });
        }
        String executorName = this.retrieveValue(config, properties, ".name", ".supplier.name", ".executor.name");
        String executorSimpleName = this.retrieveValue(config, properties, ".simple-name", ".supplier.simple-name", ".executor.simple-name");
        if (StaticComponentContainer.Strings.isNotEmpty(executorName)) {
            config.setName(executorName);
        } else if (StaticComponentContainer.Strings.isNotEmpty(executorSimpleName)) {
            config.setSimpleName(executorSimpleName);
        }
        String code = StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(config.getPropertyName()).on(properties)).deleteUnresolvedPlaceHolder(true)).withDefaultValues(config.getDefaultValues()));
        if (code.contains(";")) {
            if (config.isIndentCodeActive()) {
                code = code.replaceAll(";{2,}", ";");
                for (String codeLine : code.split(";")) {
                    if (!StaticComponentContainer.Strings.isNotEmpty(codeLine)) continue;
                    body.addCodeLine(codeLine + ";");
                }
            } else {
                body.addCodeLine(code);
            }
            if (!code.contains("return")) {
                body.addCodeLine("return null;");
            }
        } else {
            body.addCodeLine(code.contains("return") ? code : "return " + code + ";");
        }
        return this.execute((E)config);
    }

    private String retrieveValue(ExecuteConfig.ForProperties config, Properties properties, String ... suffixes) {
        for (String suffix : suffixes) {
            String value = StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(config.getPropertyName() + suffix).on(properties)).deleteUnresolvedPlaceHolder(true)).withDefaultValues(config.getDefaultValues()));
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public <E extends ExecuteConfig<E>, T> T execute(BodySourceGenerator body) {
        return this.execute(ExecuteConfig.forBodySourceGenerator(body));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends ExecuteConfig<E>, T> T execute(E config) {
        Object executeClient = new Object(){};
        ClassLoader defaultClassLoader = null;
        ClassLoader parentClassLoader = config.getParentClassLoader();
        if (parentClassLoader == null && config.isUseDefaultClassLoaderAsParentIfParentClassLoaderIsNull()) {
            parentClassLoader = defaultClassLoader = ((ClassFactoryImpl)this.getClassFactory()).getDefaultClassLoader(executeClient);
        }
        if (config.getClassLoader() == null) {
            MemoryClassLoader memoryClassLoader = MemoryClassLoader.create(parentClassLoader);
            try {
                Object retrievedElement;
                memoryClassLoader.register(executeClient);
                Class<T> executableClass = this.loadOrBuildAndDefineExecutorSubType(config.useClassLoader(memoryClassLoader));
                Executable executor = (Executable)StaticComponentContainer.Constructors.newInstanceDirectOf(executableClass, new Object[0]);
                Object t = retrievedElement = executor.executeAndCast(config.getParams());
                return t;
            }
            catch (Throwable exc) {
                Object executor = StaticComponentContainer.Driver.throwException((Object)exc, new Object[0]);
                return (T)executor;
            }
            finally {
                if (defaultClassLoader instanceof MemoryClassLoader) {
                    ((MemoryClassLoader)defaultClassLoader).unregister(executeClient, true);
                }
                memoryClassLoader.unregister(executeClient, true);
            }
        }
        Function<Boolean, ClassLoader> parentClassLoaderRestorer = null;
        try {
            if (parentClassLoader != null) {
                parentClassLoaderRestorer = StaticComponentContainer.ClassLoaders.setAsParent(config.getClassLoader(), parentClassLoader);
            }
            Class<T> executableClass = this.loadOrBuildAndDefineExecutorSubType(config);
            Executable executor = (Executable)StaticComponentContainer.Constructors.newInstanceDirectOf(executableClass, new Object[0]);
            Object retrievedElement = executor.executeAndCast(config.getParams());
            if (parentClassLoaderRestorer != null) {
                parentClassLoaderRestorer.apply(true);
            }
            Object t = retrievedElement;
            return t;
        }
        catch (Throwable exc) {
            Object object = StaticComponentContainer.Driver.throwException((Object)exc, new Object[0]);
            return (T)object;
        }
        finally {
            if (defaultClassLoader instanceof MemoryClassLoader) {
                ((MemoryClassLoader)defaultClassLoader).unregister(executeClient, true);
            }
        }
    }

    @Override
    public <E extends LoadOrBuildAndDefineConfig.ForCodeExecutorAbst<E>, T extends Executable> Class<T> loadOrBuildAndDefineExecutorSubType(E config) {
        ClassFactory.ClassRetriever classRetriever = this.getClassFactory().loadOrBuildAndDefine(config);
        Class<?> executableClass = classRetriever.get(config.getExecutorName());
        classRetriever.close();
        return executableClass;
    }

    @Override
    public void close() {
        this.unregister(this.config);
        this.classFactory = null;
        this.pathHelper = null;
        this.classFactorySupplier = null;
        this.config = null;
    }
}

