/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassLoaderManager;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.classes.SearchConfig;
import org.burningwave.core.classes.SearchContext;
import org.burningwave.core.classes.SearchResult;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.IterableObjectHelper;
import org.burningwave.core.iterable.Properties;

public interface ClassPathScanner<I, R extends SearchResult<I>> {
    public R find();

    public R findBy(SearchConfig var1);

    public static abstract class Abst<I, C extends SearchContext<I>, R extends SearchResult<I>>
    implements Component {
        PathHelper pathHelper;
        Function<SearchContext.InitContext, C> contextSupplier;
        Function<C, R> resultSupplier;
        Properties config;
        Collection<SearchResult<I>> searchResults;
        String instanceId;
        ClassLoaderManager<PathScannerClassLoader> defaultPathScannerClassLoaderManager;

        Abst(PathHelper pathHelper, Function<SearchContext.InitContext, C> contextSupplier, Function<C, R> resultSupplier, Object defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, Properties config) {
            this.pathHelper = pathHelper;
            this.contextSupplier = contextSupplier;
            this.resultSupplier = resultSupplier;
            this.config = config;
            this.searchResults = ConcurrentHashMap.newKeySet();
            this.instanceId = StaticComponentContainer.Objects.getCurrentId(this);
            this.defaultPathScannerClassLoaderManager = new ClassLoaderManager(defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier);
            this.listenTo(config);
        }

        @Override
        public <K, V> void processChangeNotification(Properties properties, Properties.Event event, K key, V newValue, V previousValue) {
            String keyAsString;
            if (event.name().equals(Properties.Event.PUT.name()) && key instanceof String && (keyAsString = (String)key).startsWith(this.getNameInConfigProperties() + ".default-path-scanner-class-loader")) {
                this.defaultPathScannerClassLoaderManager.reset();
            }
        }

        abstract String getNameInConfigProperties();

        abstract String getDefaultPathScannerClassLoaderNameInConfigProperties();

        abstract String getDefaultPathScannerClassLoaderCheckFileOptionsNameInConfigProperties();

        PathScannerClassLoader getDefaultPathScannerClassLoader(Object client) {
            return this.defaultPathScannerClassLoaderManager.get(client);
        }

        public R find() {
            return this.findBy(SearchConfig.create());
        }

        public R findBy(SearchConfig input) {
            SearchConfig searchConfig = input.isInitialized() ? input : input.createCopy();
            Object context = searchConfig.isInitialized() ? searchConfig.getSearchContext() : searchConfig.init(this);
            ((SearchContext)context).executeSearch(() -> {
                Collection<FileSystemItem> pathsToBeScanned = searchConfig.getPathsToBeScanned();
                StaticComponentContainer.IterableObjectHelper.iterate(IterableObjectHelper.IterationConfig.of(StaticComponentContainer.IterableObjectHelper.iterateAndGet((IterableObjectHelper.IterationConfig.WithOutputOfMap)((IterableObjectHelper.IterationConfig.WithOutputOfMap)IterableObjectHelper.IterationConfig.of(pathsToBeScanned).withOutput(new ConcurrentHashMap()).withAction((currentScannedPath, outputHandler) -> {
                    if (!currentScannedPath.isContainer()) {
                        throw new IllegalArgumentException(StaticComponentContainer.Strings.compile("{} is not a folder or archive", currentScannedPath.getAbsolutePath()));
                    }
                    outputHandler.accept(output -> output.put(currentScannedPath, this.scanAndAddToPathScannerClassLoader(context, (FileSystemItem)currentScannedPath)));
                }).parallelIf(searchConfig.getMinimumCollectionSizeForParallelIterationPredicate() != null ? searchConfig.getMinimumCollectionSizeForParallelIterationPredicate()::test : null)).withPriority(searchConfig.priority))).withAction(currentScannedPath -> this.testClassCriteriaAndAddItemsToContext(context, (Map.Entry<FileSystemItem, Collection<FileSystemItem>>)currentScannedPath)).parallelIf(searchConfig.getMinimumCollectionSizeForParallelIterationPredicate() != null ? searchConfig.getMinimumCollectionSizeForParallelIterationPredicate()::test : null).withPriority(searchConfig.priority));
                Collection<String> skippedClassesNames = context.getSkippedClassNames();
                if (!skippedClassesNames.isEmpty()) {
                    StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Skipped classes count: {}", skippedClassesNames.size());
                }
            });
            SearchResult searchResult = (SearchResult)this.resultSupplier.apply(context);
            searchResult.setClassPathScanner(this);
            return (R)searchResult;
        }

        Collection<FileSystemItem> scanAndAddToPathScannerClassLoader(C context, FileSystemItem currentScannedPath) {
            SearchConfig searchConfig = ((SearchContext)context).searchConfig;
            FileSystemItem.Criteria allFileFilters = searchConfig.getAllFileFilters(currentScannedPath);
            PathScannerClassLoader pathScannerClassLoader = ((SearchContext)context).pathScannerClassLoader;
            if (searchConfig.useDefaultPathScannerClassLoaderAsParent || !searchConfig.useDefaultPathScannerClassLoaderAsParent && !searchConfig.useDefaultPathScannerClassLoader && searchConfig.pathScannerClassLoader == null) {
                pathScannerClassLoader.setFileFilter(allFileFilters);
            }
            if (!searchConfig.getRefreshPathIf().test(currentScannedPath) && pathScannerClassLoader.hasBeenCompletelyLoaded(currentScannedPath.getAbsolutePath())) {
                return searchConfig.getFindFunction(currentScannedPath).apply(searchConfig.getRefreshPathIf().test(currentScannedPath) ? currentScannedPath.refresh() : currentScannedPath, searchConfig.getAllFileFilters(currentScannedPath));
            }
            return StaticComponentContainer.Synchronizer.execute(pathScannerClassLoader.instanceId + "_" + currentScannedPath.getAbsolutePath(), () -> {
                Boolean loadPathCompletely = null;
                FileSystemItem.Criteria allFileFiltersInternal = allFileFilters;
                if (searchConfig.getRefreshPathIf().test(currentScannedPath) || !pathScannerClassLoader.hasBeenCompletelyLoaded(currentScannedPath.getAbsolutePath())) {
                    loadPathCompletely = !searchConfig.isFileFilterExternallySet() && searchConfig.getFindFunction(currentScannedPath) != FileSystemItem.Find.IN_CHILDREN ? Boolean.TRUE : Boolean.FALSE;
                    allFileFiltersInternal = allFileFiltersInternal.and(this.getPathScannerClassLoaderFiller(context, currentScannedPath));
                }
                Collection<FileSystemItem> itemsFound = searchConfig.getFindFunction(currentScannedPath).apply(searchConfig.getRefreshPathIf().test(currentScannedPath) ? currentScannedPath.refresh() : currentScannedPath, allFileFiltersInternal);
                if (loadPathCompletely != null) {
                    pathScannerClassLoader.loadedPaths.put(currentScannedPath.getAbsolutePath(), loadPathCompletely);
                }
                return itemsFound;
            });
        }

        FileSystemItem.Criteria getPathScannerClassLoaderFiller(C context, FileSystemItem currentScannedPath) {
            PathScannerClassLoader pathScannerClassLoader = ((SearchContext)context).pathScannerClassLoader;
            return FileSystemItem.Criteria.forAllFileThat(fileSystemItem -> {
                block3: {
                    JavaClass javaClass = fileSystemItem.toJavaClass();
                    try {
                        String className = javaClass.getName();
                        if (pathScannerClassLoader.loadedByteCodes.get(className) == null && pathScannerClassLoader.notLoadedByteCodes.get(className) == null) {
                            pathScannerClassLoader.addByteCode0(className, javaClass.getByteCode());
                        }
                    }
                    catch (NullPointerException exc) {
                        if (javaClass == null) break block3;
                        throw exc;
                    }
                }
                return true;
            });
        }

        void testClassCriteriaAndAddItemsToContext(C context, Map.Entry<FileSystemItem, Collection<FileSystemItem>> currentScannedPathAndChildren) {
            FileSystemItem currentScannedPath = currentScannedPathAndChildren.getKey();
            String currentScannedAbsolutePath = currentScannedPath.getAbsolutePath();
            FileSystemItem.Criteria allFileFilters = ((SearchContext)context).searchConfig.getAllFileFilters(currentScannedPath);
            StaticComponentContainer.IterableObjectHelper.iterate(IterableObjectHelper.IterationConfig.of(currentScannedPathAndChildren.getValue()).withAction(child -> {
                block3: {
                    JavaClass javaClass = child.toJavaClass();
                    try {
                        ClassCriteria.TestContext criteriaTestContext = this.testClassCriteria(context, javaClass);
                        if (criteriaTestContext.getResult().booleanValue()) {
                            this.addToContext(context, criteriaTestContext, currentScannedAbsolutePath, (FileSystemItem)child, javaClass);
                        }
                    }
                    catch (NullPointerException exc) {
                        if (javaClass == null) break block3;
                        throw exc;
                    }
                }
            }).parallelIf(allFileFilters.getMinimumCollectionSizeForParallelIterationPredicate() != null ? allFileFilters.getMinimumCollectionSizeForParallelIterationPredicate()::test : null).withPriority(allFileFilters.getPriority()));
        }

        ClassCriteria.TestContext testClassCriteria(C context, JavaClass javaClass) {
            return ((SearchContext)context).test(((SearchContext)context).loadClass(javaClass.getName()));
        }

        abstract void addToContext(C var1, ClassCriteria.TestContext var2, String var3, FileSystemItem var4, JavaClass var5);

        boolean register(SearchResult<I> searchResult) {
            this.searchResults.add(searchResult);
            return true;
        }

        boolean unregister(SearchResult<I> searchResult) {
            this.searchResults.remove(searchResult);
            return true;
        }

        public synchronized void closeSearchResults() {
            Collection<SearchResult<I>> searchResults = this.searchResults;
            if (searchResults != null) {
                for (SearchResult<I> searchResult : searchResults) {
                    searchResult.close();
                }
            }
        }

        @Override
        public void close() {
            this.unregister(this.config);
            this.pathHelper = null;
            this.contextSupplier = null;
            this.config = null;
            this.closeSearchResults();
            this.defaultPathScannerClassLoaderManager.close();
            this.defaultPathScannerClassLoaderManager = null;
            this.searchResults = null;
        }
    }

    public static class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, String> defaultValues = new HashMap<String, String>();
            defaultValues.put(Key.DEFAULT_SEARCH_CONFIG_PATHS, PathHelper.Configuration.Key.MAIN_CLASS_PATHS_PLACE_HOLDER + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + "${" + PathHelper.Configuration.Key.MAIN_CLASS_PATHS_EXTENSION + "}" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + "${" + PathHelper.Configuration.Key.MAIN_CLASS_REPOSITORIES + "}" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator());
            defaultValues.put("hunters.default-search-config.check-file-option", "${path-scanner-class-loader.search-config.check-file-option}");
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static class Key {
            public static final String DEFAULT_CHECK_FILE_OPTIONS = "hunters.default-search-config.check-file-option";
            public static final String DEFAULT_SEARCH_CONFIG_PATHS = PathHelper.Configuration.Key.PATHS_PREFIX + "hunters.default-search-config.paths";
        }
    }
}

