/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.burningwave.core.Cleanable;
import org.burningwave.core.Component;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.Members;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.IterableZipContainer;

public class Cache
implements ManagedLogger {
    public final PathForResources<ByteBuffer> pathForContents;
    public final PathForResources<FileSystemItem> pathForFileSystemItems;
    public final PathForResources<IterableZipContainer> pathForIterableZipContainers;
    public final ObjectAndPathForResources<ClassLoader, Field[]> classLoaderForFields;
    public final ObjectAndPathForResources<ClassLoader, Method[]> classLoaderForMethods;
    public final ObjectAndPathForResources<ClassLoader, Constructor<?>[]> classLoaderForConstructors;
    public final ObjectAndPathForResources<ClassLoader, Collection<Field>> uniqueKeyForFields;
    public final ObjectAndPathForResources<ClassLoader, Collection<Constructor<?>>> uniqueKeyForConstructors;
    public final ObjectAndPathForResources<ClassLoader, Collection<Method>> uniqueKeyForMethods;
    public final ObjectAndPathForResources<ClassLoader, Object> bindedFunctionalInterfaces;
    public final ObjectAndPathForResources<ClassLoader, Members.Handler.OfExecutable.Box<?>> uniqueKeyForExecutableAndMethodHandle;

    private Cache() {
        StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Building cache");
        this.pathForContents = new PathForResources(StaticComponentContainer.BufferHandler::shareContent);
        this.pathForFileSystemItems = new PathForResources((path, fileSystemItem) -> fileSystemItem.destroy());
        this.pathForIterableZipContainers = new PathForResources((path, zipFileContainer) -> zipFileContainer.destroy());
        this.classLoaderForFields = new ObjectAndPathForResources();
        this.classLoaderForMethods = new ObjectAndPathForResources();
        this.uniqueKeyForFields = new ObjectAndPathForResources();
        this.uniqueKeyForMethods = new ObjectAndPathForResources();
        this.uniqueKeyForConstructors = new ObjectAndPathForResources();
        this.classLoaderForConstructors = new ObjectAndPathForResources();
        this.bindedFunctionalInterfaces = new ObjectAndPathForResources();
        this.uniqueKeyForExecutableAndMethodHandle = new ObjectAndPathForResources();
    }

    public static Cache create() {
        return new Cache();
    }

    public void clear(Cleanable ... excluded) {
        this.clear(false, excluded);
    }

    public void clear(boolean destroyItems, Cleanable ... excluded) {
        HashSet<Cleanable> toBeExcluded = excluded != null && excluded.length > 0 ? new HashSet<Cleanable>(Arrays.asList(excluded)) : null;
        this.clear(this.pathForContents, toBeExcluded, destroyItems);
        this.clear(this.pathForFileSystemItems, toBeExcluded, destroyItems);
        this.clear(this.pathForIterableZipContainers, toBeExcluded, destroyItems);
        this.clear(this.classLoaderForFields, toBeExcluded, destroyItems);
        this.clear(this.classLoaderForMethods, toBeExcluded, destroyItems);
        this.clear(this.classLoaderForConstructors, toBeExcluded, destroyItems);
        this.clear(this.bindedFunctionalInterfaces, toBeExcluded, destroyItems);
        this.clear(this.uniqueKeyForFields, toBeExcluded, destroyItems);
        this.clear(this.uniqueKeyForConstructors, toBeExcluded, destroyItems);
        this.clear(this.uniqueKeyForMethods, toBeExcluded, destroyItems);
        this.clear(this.uniqueKeyForExecutableAndMethodHandle, toBeExcluded, destroyItems);
    }

    private void clear(Cleanable cache, Set<Cleanable> excluded, boolean destroyItems) {
        if (excluded == null || !excluded.contains(cache)) {
            if (!destroyItems) {
                cache.clear();
            } else if (cache instanceof ObjectAndPathForResources) {
                ((ObjectAndPathForResources)cache).clear(destroyItems);
            } else if (cache instanceof PathForResources) {
                ((PathForResources)cache).clear(destroyItems);
            }
        }
    }

    public static class PathForResources<R>
    implements Component {
        Map<Long, Map<String, Map<String, R>>> resources;
        Long partitionStartLevel;
        Function<R, R> sharer;
        BiConsumer<String, R> itemDestroyer;
        String instanceId;

        private PathForResources() {
            this(1L, item -> item, null);
        }

        private PathForResources(Long partitionStartLevel) {
            this(partitionStartLevel, item -> item, null);
        }

        private PathForResources(Function<R, R> sharer) {
            this(1L, sharer, null);
        }

        private PathForResources(BiConsumer<String, R> itemDestroyer) {
            this(1L, item -> item, itemDestroyer);
        }

        private PathForResources(Long partitionStartLevel, Function<R, R> sharer) {
            this(partitionStartLevel, sharer, null);
        }

        private PathForResources(Function<R, R> sharer, BiConsumer<String, R> itemDestroyer) {
            this(1L, item -> item, itemDestroyer);
        }

        private PathForResources(Long partitionStartLevel, BiConsumer<String, R> itemDestroyer) {
            this(partitionStartLevel, item -> item, itemDestroyer);
        }

        private PathForResources(Long partitionStartLevel, Function<R, R> sharer, BiConsumer<String, R> itemDestroyer) {
            this.partitionStartLevel = partitionStartLevel;
            this.sharer = sharer;
            this.resources = new HashMap<Long, Map<String, Map<String, R>>>();
            this.itemDestroyer = itemDestroyer;
            this.instanceId = this.toString();
        }

        Map<String, R> retrievePartition(Map<String, Map<String, R>> partion, Long partitionIndex, String path) {
            Map innerPartion;
            String partitionKey = "/";
            if (partitionIndex > 1L) {
                partitionKey = path.substring(0, path.lastIndexOf("/"));
                partitionKey = partitionKey.substring(partitionKey.lastIndexOf("/") + 1);
            }
            if ((innerPartion = partion.get(partitionKey)) == null) {
                String finalPartitionKey = partitionKey;
                innerPartion = StaticComponentContainer.Synchronizer.execute(this.instanceId + "_mutexManagerForPartitions_" + finalPartitionKey, () -> {
                    HashMap innerPartionTemp = (HashMap)partion.get(finalPartitionKey);
                    if (innerPartionTemp == null) {
                        innerPartionTemp = new HashMap();
                        partion.put(finalPartitionKey, innerPartionTemp);
                    }
                    return innerPartionTemp;
                });
            }
            return innerPartion;
        }

        R getOrUploadIfAbsent(Map<String, R> loadedResources, String path, Supplier<R> resourceSupplier) {
            Object resource = loadedResources.get(path);
            if (resource == null) {
                resource = StaticComponentContainer.Synchronizer.execute(this.instanceId + "_mutexManagerForLoadedResources_" + path, () -> {
                    Object resourceTemp = loadedResources.get(path);
                    if (resourceTemp == null && resourceSupplier != null && (resourceTemp = resourceSupplier.get()) != null) {
                        resourceTemp = this.sharer.apply(resourceTemp);
                        loadedResources.put(path, resourceTemp);
                    }
                    return resourceTemp;
                });
            }
            return resource != null ? this.sharer.apply(resource) : resource;
        }

        public R upload(Map<String, R> loadedResources, String path, Supplier<R> resourceSupplier, boolean destroy) {
            R oldResource = this.remove(path, destroy);
            StaticComponentContainer.Synchronizer.execute(this.instanceId + "_mutexManagerForLoadedResources_" + path, () -> {
                Object resourceTemp = resourceSupplier.get();
                if (resourceTemp != null) {
                    resourceTemp = this.sharer.apply(resourceTemp);
                    loadedResources.put(path, resourceTemp);
                }
            });
            return oldResource;
        }

        Map<String, Map<String, R>> retrievePartition(Map<Long, Map<String, Map<String, R>>> partitionedResources, Long partitionIndex) {
            Map resources = partitionedResources.get(partitionIndex);
            if (resources == null) {
                resources = StaticComponentContainer.Synchronizer.execute(this.instanceId + "_mutexManagerForPartitionedResources_" + partitionIndex.toString(), () -> {
                    HashMap resourcesTemp = (HashMap)partitionedResources.get(partitionIndex);
                    if (resourcesTemp == null) {
                        resourcesTemp = new HashMap();
                        partitionedResources.put(partitionIndex, resourcesTemp);
                    }
                    return resourcesTemp;
                });
            }
            return resources;
        }

        public R upload(String path, Supplier<R> resourceSupplier, boolean destroy) {
            Long occurences = path.chars().filter(ch -> ch == 47).count();
            Long partitionIndex = occurences > this.partitionStartLevel ? occurences : this.partitionStartLevel;
            Map<String, Map<String, R>> partion = this.retrievePartition(this.resources, partitionIndex);
            Map<String, R> nestedPartition = this.retrievePartition(partion, partitionIndex, path);
            return this.upload(nestedPartition, path, resourceSupplier, destroy);
        }

        public R getOrUploadIfAbsent(String path, Supplier<R> resourceSupplier) {
            Long occurences = path.chars().filter(ch -> ch == 47).count();
            Long partitionIndex = occurences > this.partitionStartLevel ? occurences : this.partitionStartLevel;
            Map<String, Map<String, R>> partion = this.retrievePartition(this.resources, partitionIndex);
            Map<String, R> nestedPartition = this.retrievePartition(partion, partitionIndex, path);
            return this.getOrUploadIfAbsent(nestedPartition, path, resourceSupplier);
        }

        public R get(String path) {
            return this.getOrUploadIfAbsent(path, null);
        }

        public R remove(String path, boolean destroy) {
            Long occurences = path.chars().filter(ch -> ch == 47).count();
            Long partitionIndex = occurences > this.partitionStartLevel ? occurences : this.partitionStartLevel;
            Map<String, Map<String, R>> partion = this.retrievePartition(this.resources, partitionIndex);
            Map nestedPartition = this.retrievePartition(partion, partitionIndex, path);
            Object item = StaticComponentContainer.Synchronizer.execute(this.instanceId + "_mutexManagerForLoadedResources_" + path, () -> nestedPartition.remove(path));
            if (this.itemDestroyer != null && destroy && item != null) {
                String finalPath = path;
                StaticComponentContainer.BackgroundExecutor.createTask(task -> this.itemDestroyer.accept(finalPath, item), 1).submit();
            }
            return (R)item;
        }

        public int getLoadedResourcesCount() {
            return this.getLoadedResourcesCount(this.resources);
        }

        private int getLoadedResourcesCount(Map<Long, Map<String, Map<String, R>>> resources) {
            int count = 0;
            for (Map.Entry<Long, Map<String, Map<String, R>>> partition : resources.entrySet()) {
                for (Map.Entry<String, Map<String, R>> innerPartition : partition.getValue().entrySet()) {
                    count += innerPartition.getValue().size();
                }
            }
            return count;
        }

        public PathForResources<R> clear() {
            return this.clear(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PathForResources<R> clear(boolean destroyItems) {
            Map<Long, Map<String, Map<String, R>>> partitions;
            Map<Long, Map<String, Map<String, R>>> map = this.resources;
            synchronized (map) {
                partitions = this.resources;
                this.resources = new HashMap<Long, Map<String, Map<String, R>>>();
            }
            StaticComponentContainer.BackgroundExecutor.createTask(task -> this.clearResources(partitions, destroyItems), 1).submit();
            return this;
        }

        void clearResources(Map<Long, Map<String, Map<String, R>>> partitions, boolean destroyItems) {
            for (Map.Entry<Long, Map<String, Map<String, R>>> partition : partitions.entrySet()) {
                for (Map.Entry<String, Map<String, R>> nestedPartition : partition.getValue().entrySet()) {
                    if (this.itemDestroyer != null && destroyItems) {
                        StaticComponentContainer.IterableObjectHelper.deepClear(nestedPartition.getValue(), (path, resource) -> this.itemDestroyer.accept((String)path, (R)resource));
                        continue;
                    }
                    nestedPartition.getValue().clear();
                }
                partition.getValue().clear();
            }
            partitions.clear();
        }
    }

    public static class ObjectAndPathForResources<T, R>
    implements Component {
        Map<T, PathForResources<R>> resources = new HashMap<T, PathForResources<R>>();
        Supplier<PathForResources<R>> pathForResourcesSupplier = () -> new PathForResources(partitionStartLevel, sharer, itemDestroyer);
        String instanceId = StaticComponentContainer.Objects.getId(this);

        public ObjectAndPathForResources() {
            this(1L, item -> item, null);
        }

        public ObjectAndPathForResources(Long partitionStartLevel) {
            this(partitionStartLevel, item -> item, null);
        }

        public ObjectAndPathForResources(Long partitionStartLevel, Function<R, R> sharer) {
            this(partitionStartLevel, sharer, null);
        }

        public ObjectAndPathForResources(Long partitionStartLevel, Function<R, R> sharer, BiConsumer<String, R> itemDestroyer) {
        }

        public R getOrUploadIfAbsent(T object, String path, Supplier<R> resourceSupplier) {
            PathForResources pathForResources = this.resources.get(object);
            if (pathForResources == null) {
                pathForResources = StaticComponentContainer.Synchronizer.execute(this.instanceId + "_" + StaticComponentContainer.Objects.getId(object), () -> {
                    PathForResources<R> pathForResourcesTemp = this.resources.get(object);
                    if (pathForResourcesTemp == null) {
                        pathForResourcesTemp = this.pathForResourcesSupplier.get();
                        this.resources.put(object, pathForResourcesTemp);
                    }
                    return pathForResourcesTemp;
                });
            }
            return pathForResources.getOrUploadIfAbsent(path, resourceSupplier);
        }

        public R get(T object, String path) {
            PathForResources pathForResources = this.resources.get(object);
            if (pathForResources == null) {
                pathForResources = StaticComponentContainer.Synchronizer.execute(this.instanceId + "_mutexManagerForResources_" + StaticComponentContainer.Objects.getId(object), () -> {
                    PathForResources<R> pathForResourcesTemp = this.resources.get(object);
                    if (pathForResourcesTemp == null) {
                        pathForResourcesTemp = this.pathForResourcesSupplier.get();
                        this.resources.put(object, pathForResourcesTemp);
                    }
                    return pathForResourcesTemp;
                });
            }
            return pathForResources.get(path);
        }

        public PathForResources<R> remove(T object, boolean destroyItems) {
            PathForResources<R> pathForResources = this.resources.remove(object);
            if (pathForResources != null && destroyItems) {
                pathForResources.clear(destroyItems);
            }
            return pathForResources;
        }

        public R removePath(T object, String path) {
            return this.removePath(object, path, false);
        }

        public R removePath(T object, String path, boolean destroyItem) {
            PathForResources<R> pathForResources = this.resources.get(object);
            if (pathForResources != null) {
                return pathForResources.remove(path, destroyItem);
            }
            return null;
        }

        public ObjectAndPathForResources<T, R> clear() {
            return this.clear(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectAndPathForResources<T, R> clear(boolean destroyItems) {
            Map resources;
            Map<T, PathForResources<R>> map = this.resources;
            synchronized (map) {
                resources = this.resources;
                this.resources = new HashMap<T, PathForResources<R>>();
            }
            StaticComponentContainer.BackgroundExecutor.createTask(task -> {
                for (Map.Entry item : resources.entrySet()) {
                    ((PathForResources)item.getValue()).clear(destroyItems);
                }
                resources.clear();
            }, 1).submit();
            return this;
        }
    }
}

