/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.bsc.confluence.ConfluenceProxy;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ConfluenceServiceFactory;
import org.bsc.confluence.model.Site;
import org.bsc.confluence.rest.scrollversions.ScrollVersionsConfiguration;
import org.bsc.ssl.SSLCertificateInfo;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class AbstractBaseConfluenceMojo
extends AbstractMojo {
    @Parameter
    private Map<String, String> properties;
    @Parameter(property="confluence.endPoint", defaultValue="http://localhost:8080/rpc/xmlrpc")
    private String endPoint;
    @Parameter(property="confluence.spaceKey", required=false)
    private String spaceKey;
    @Parameter(property="confluence.parentPage", defaultValue="Home")
    private String parentPageTitle;
    @Parameter(property="confluence.parentPageId")
    private String parentPageId;
    @Parameter(property="confluence.userName", required=false)
    private String username;
    @Parameter(property="confluence.password", required=false)
    private String password;
    @Parameter(readonly=true, property="settings")
    protected Settings mavenSettings;
    @Parameter(property="confluence.serverId")
    private String serverId;
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Parameter
    protected SSLCertificateInfo sslCertificate = new SSLCertificateInfo();
    @Parameter(property="confluence.failOnError", defaultValue="true")
    private boolean failOnError = true;
    @Parameter(name="scrollVersions")
    private ScrollVersionsConfiguration scrollVersions;

    public Optional<ScrollVersionsConfiguration> getScrollVersions() {
        return Optional.ofNullable(this.scrollVersions);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public final String getEndPoint() {
        return this.endPoint;
    }

    public final String _getSpaceKey() {
        return this.spaceKey;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getPassword() {
        return this.password;
    }

    public final Map<String, String> getProperties() {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>(5);
        }
        return this.properties;
    }

    protected <T extends Consumer<ConfluenceService>> void confluenceExecute(T task) {
        ConfluenceProxy proxyInfo = null;
        Proxy activeProxy = this.mavenSettings.getActiveProxy();
        if (activeProxy != null) {
            proxyInfo = new ConfluenceProxy(activeProxy.getHost(), activeProxy.getPort(), activeProxy.getUsername(), activeProxy.getPassword(), activeProxy.getNonProxyHosts());
        }
        ConfluenceService.Credentials credentials = new ConfluenceService.Credentials(this.getUsername(), this.getPassword());
        try (ConfluenceService confluence = ConfluenceServiceFactory.createInstance(this.getEndPoint(), credentials, proxyInfo, this.sslCertificate, this.getScrollVersions());){
            task.accept((ConfluenceService)confluence);
        }
        catch (Throwable re) {
            throw new RuntimeException(re);
        }
    }

    protected ConfluenceService.Model.Page loadParentPage(ConfluenceService confluence, Optional<Site> site) {
        String _spaceKey = site.flatMap(s -> s.optSpaceKey()).orElse(this.spaceKey);
        String _parentPageId = site.flatMap(s -> s.getHome().optParentPageId()).orElse(this.parentPageId);
        String _parentPageTitle = site.flatMap(s -> s.getHome().optParentPageTitle()).orElse(this.parentPageTitle);
        Optional result = Optional.empty();
        if (_parentPageId != null && !(result = (Optional)confluence.getPage(_parentPageId).join()).isPresent()) {
            this.getLog().warn((CharSequence)String.format("parentPageId [%s] not found! Try with parentPageTitle [%s] in space [%s]", _parentPageId, _parentPageTitle, this.spaceKey));
        }
        if (!result.isPresent()) {
            if (_spaceKey == null) {
                throw new IllegalStateException("spaceKey is not set!");
            }
            result = (Optional)confluence.getPage(_spaceKey, _parentPageTitle).join();
        }
        if (!result.isPresent()) {
            this.throwRTE("cannot get page with parentPageTitle [%s] in space [%s]!", this.parentPageTitle, this.spaceKey);
        }
        this.getProperties().put("parentPageTitle", ((ConfluenceService.Model.Page)result.get()).getTitle());
        return (ConfluenceService.Model.Page)result.get();
    }

    protected void loadUserInfoFromSettings() throws MojoExecutionException {
        if ((this.getUsername() == null || this.getPassword() == null) && this.mavenSettings != null) {
            if (this.serverId == null) {
                throw new MojoExecutionException("'serverId' must be set! (username and/or password are not provided)");
            }
            Server server = this.mavenSettings.getServer(this.serverId);
            if (server == null) {
                throw new MojoExecutionException(String.format("server with id [%s] not found in settings!", this.serverId));
            }
            if (this.getUsername() == null && server.getUsername() != null) {
                this.username = server.getUsername();
            }
            if (this.getPassword() == null && server.getPassword() != null) {
                try {
                    if (this.securityDispatcher instanceof DefaultSecDispatcher) {
                        ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile("~/.m2/settings-security.xml");
                    }
                    this.password = this.securityDispatcher.decrypt(server.getPassword());
                }
                catch (SecDispatcherException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
    }

    protected RuntimeException RTE(String message, Object ... args) {
        Object[] arguments = args;
        String m = String.format(message, arguments);
        if (arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable) {
            return new RuntimeException(m, (Throwable)arguments[arguments.length - 1]);
        }
        return new RuntimeException(m);
    }

    protected <T> T throwRTE(String message, Object ... args) {
        throw this.RTE(message, args);
    }
}

