/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.json.JsonObjectBuilder;
import org.bsc.confluence.ConfluenceProxy;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ExportFormat;
import org.bsc.confluence.rest.RESTConfluenceService;
import org.bsc.confluence.rest.model.Page;
import org.bsc.confluence.rest.scrollversions.ScrollVersionsConfluenceService;
import org.bsc.confluence.xmlrpc.XMLRPCConfluenceService;
import org.bsc.mojo.configuration.ScrollVersionsInfo;
import org.bsc.ssl.SSLCertificateInfo;

public class ConfluenceServiceFactory {
    public static ConfluenceService createInstance(String endpoint, ConfluenceService.Credentials credentials, ConfluenceProxy proxyInfo, SSLCertificateInfo sslInfo, ScrollVersionsInfo svi) throws Exception {
        if (ConfluenceService.Protocol.XMLRPC.match(endpoint)) {
            return new MixedConfluenceService(endpoint, credentials, proxyInfo, sslInfo);
        }
        if (ConfluenceService.Protocol.REST.match(endpoint)) {
            return svi.optVersion().map(version -> new ScrollVersionsConfluenceService(endpoint, version, credentials, sslInfo)).orElseGet(() -> new RESTConfluenceService(endpoint, credentials, sslInfo));
        }
        throw new IllegalArgumentException(String.format("endpoint doesn't contain a valid API protocol\nIt must be '%s' or '%s'", ConfluenceService.Protocol.XMLRPC.path(), ConfluenceService.Protocol.REST.path()));
    }

    private static class MixedConfluenceService
    implements ConfluenceService {
        final XMLRPCConfluenceService xmlrpcService;
        final RESTConfluenceService restService;

        public MixedConfluenceService(String endpoint, ConfluenceService.Credentials credentials, ConfluenceProxy proxyInfo, SSLCertificateInfo sslInfo) throws Exception {
            this.xmlrpcService = XMLRPCConfluenceService.createInstanceDetectingVersion((String)endpoint, (ConfluenceService.Credentials)credentials, (ConfluenceProxy)proxyInfo, (SSLCertificateInfo)sslInfo);
            String restEndpoint = ConfluenceService.Protocol.XMLRPC.removeFrom(endpoint) + ConfluenceService.Protocol.REST.path();
            this.restService = new RESTConfluenceService(restEndpoint, credentials, sslInfo);
        }

        public ConfluenceService.Credentials getCredentials() {
            return this.xmlrpcService.getCredentials();
        }

        public CompletableFuture<Optional<? extends ConfluenceService.Model.PageSummary>> getPageByTitle(ConfluenceService.Model.ID parentPageId, String title) {
            return this.xmlrpcService.getPageByTitle(parentPageId, title);
        }

        public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String spaceKey, String pageTitle) {
            return this.xmlrpcService.getPage(spaceKey, pageTitle);
        }

        public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(ConfluenceService.Model.ID pageId) {
            return this.xmlrpcService.getPage(pageId);
        }

        public CompletableFuture<List<ConfluenceService.Model.PageSummary>> getDescendents(ConfluenceService.Model.ID pageId) {
            return this.xmlrpcService.getDescendents(pageId);
        }

        public CompletableFuture<Boolean> removePage(ConfluenceService.Model.ID pageId) {
            return this.xmlrpcService.removePage(pageId);
        }

        public CompletableFuture<Boolean> removePage(ConfluenceService.Model.Page parentPage, String title) {
            return this.xmlrpcService.removePage(parentPage, title);
        }

        public CompletableFuture<ConfluenceService.Model.Page> createPage(ConfluenceService.Model.Page parentPage, String title, ConfluenceService.Storage content) {
            return this.xmlrpcService.createPage(parentPage, title, content);
        }

        public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page) {
            return this.xmlrpcService.storePage(page);
        }

        public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) {
            if (ConfluenceService.Storage.Representation.STORAGE == content.rapresentation) {
                if (page.getId() == null) {
                    JsonObjectBuilder inputData = this.restService.jsonForCreatingContent(RESTConfluenceService.ContentType.page, page.getSpace(), page.getParentId().getValue(), page.getTitle(), content);
                    return this.restService.createPage(inputData.build()).thenApply(p -> p.map(Page::new).get());
                }
                return this.restService.storePage(page, content);
            }
            return this.xmlrpcService.storePage(page, content);
        }

        public CompletableFuture<Void> addLabelsByName(ConfluenceService.Model.ID id, String[] labels) {
            return this.xmlrpcService.addLabelsByName(id, labels);
        }

        public ConfluenceService.Model.Attachment createAttachment() {
            return this.xmlrpcService.createAttachment();
        }

        public CompletableFuture<Optional<ConfluenceService.Model.Attachment>> getAttachment(ConfluenceService.Model.ID pageId, String name, String version) {
            return this.xmlrpcService.getAttachment(pageId, name, version);
        }

        public CompletableFuture<ConfluenceService.Model.Attachment> addAttachment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) {
            return this.xmlrpcService.addAttachment(page, attachment, source);
        }

        public void exportPage(String url, String spaceKey, String pageTitle, ExportFormat exfmt, File outputFile) throws Exception {
            this.xmlrpcService.exportPage(url, spaceKey, pageTitle, exfmt, outputFile);
        }

        public ConfluenceService.Model.Blogpost createBlogpost(String space, String title, ConfluenceService.Storage content, int version) {
            return this.xmlrpcService.createBlogpost(space, title, content, version);
        }

        public CompletableFuture<ConfluenceService.Model.Blogpost> addBlogpost(ConfluenceService.Model.Blogpost blogpost) {
            return this.xmlrpcService.addBlogpost(blogpost);
        }

        public String toString() {
            return this.xmlrpcService.toString();
        }

        public void close() throws IOException {
            this.xmlrpcService.logout();
        }
    }
}

