/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.markdown.commonmark.extension;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bsc.markdown.commonmark.extension.NoticeBlock;
import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class NoticeBlockParser
extends AbstractBlockParser {
    private final NoticeBlock block;
    static final Pattern pattern = Pattern.compile("^>\\s+[*][*]([Ww]arning|[Nn]ote|[Ii]nfo|[Tt]ip)[:][*][*]\\s*(.*)$");

    public NoticeBlockParser(NoticeBlock block) {
        this.block = block;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(Block block) {
        return true;
    }

    public NoticeBlock getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        int nextNonSpace = state.getNextNonSpaceIndex();
        if (NoticeBlockParser.isMarker(state, nextNonSpace)) {
            int newColumn = state.getColumn() + state.getIndent() + 1;
            if (Parsing.isSpaceOrTab((CharSequence)state.getLine().getContent(), (int)(nextNonSpace + 1))) {
                ++newColumn;
            }
            return BlockContinue.atColumn((int)newColumn);
        }
        return BlockContinue.none();
    }

    private static Optional<Matcher> isStartedMarker(ParserState state, int index) {
        CharSequence line = state.getLine().getContent();
        return state.getIndent() < Parsing.CODE_BLOCK_INDENT && index < line.length() ? Optional.ofNullable(pattern.matcher(line)).filter(m -> m.matches()) : Optional.empty();
    }

    private static boolean isMarker(ParserState state, int index) {
        CharSequence line = state.getLine().getContent();
        return state.getIndent() < Parsing.CODE_BLOCK_INDENT && index < line.length() && line.charAt(index) == '>';
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory
    extends AbstractBlockParserFactory {
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int nextNonSpace = state.getNextNonSpaceIndex();
            return NoticeBlockParser.isStartedMarker(state, nextNonSpace).map(m -> {
                int newColumn = state.getColumn() + state.getIndent() + 1;
                if (Parsing.isSpaceOrTab((CharSequence)state.getLine().getContent(), (int)(nextNonSpace + 1))) {
                    ++newColumn;
                }
                NoticeBlock block = new NoticeBlock(NoticeBlock.Type.fromString(m.group(1)), m.group(2));
                NoticeBlockParser parser = new NoticeBlockParser(block);
                return BlockStart.of((BlockParser[])new BlockParser[]{parser}).atColumn(newColumn + m.end());
            }).orElseGet(() -> BlockStart.none());
        }
    }
}

