/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.io.Serializable;
import java.util.Set;
import javax.annotation.Resource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.config.service.SystemPropertiesService;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.web.service.TemplateCacheKeyResolverService;
import org.springframework.web.context.request.WebRequest;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressions;

public class BroadleafCacheProcessor
extends AbstractAttrProcessor {
    private static final Log LOG = LogFactory.getLog(BroadleafCacheProcessor.class);
    public static final String ATTR_NAME = "cache";
    protected Cache cache;
    @Resource(name="blSystemPropertiesService")
    protected SystemPropertiesService systemPropertiesService;
    @Resource(name="blTemplateCacheKeyResolver")
    protected TemplateCacheKeyResolverService cacheKeyResolver;

    public BroadleafCacheProcessor() {
        super(ATTR_NAME);
    }

    public void fixElement(org.thymeleaf.dom.Element element, Arguments arguments) {
        boolean elementAdded = false;
        boolean removeElement = false;
        Set attributeNames = element.getAttributeMap().keySet();
        for (String a : attributeNames) {
            Attribute attr;
            String attrName = a.toLowerCase();
            if (!attrName.startsWith("th")) continue;
            if (attrName.equals("th:substituteby") || attrName.equals("th:replace") || attrName.equals("th:include")) {
                if (elementAdded) continue;
                org.thymeleaf.dom.Element extraDiv = new org.thymeleaf.dom.Element("div");
                String attrValue = element.getAttributeValue(attrName);
                element.removeAttribute(attrName);
                extraDiv.setAttribute(attrName, attrValue);
                element.addChild((Node)extraDiv);
                elementAdded = true;
                element.setNodeProperty("templateName", (Object)attrValue);
                element.setRecomputeProcessorsImmediately(true);
                continue;
            }
            if (!attrName.equals("th:remove") || !"tag".equals((attr = (Attribute)element.getAttributeMap().get(attrName)).getValue())) continue;
            removeElement = true;
            element.setAttribute(attrName, "none");
        }
        if (!elementAdded || removeElement) {
            element.setNodeProperty("blcOutputParentNode", (Object)Boolean.TRUE);
        }
    }

    protected boolean shouldCache(Arguments args, org.thymeleaf.dom.Element element, String attributeName) {
        String cacheAttrValue = element.getAttributeValue(attributeName);
        element.removeAttribute(attributeName);
        if (StringUtils.isEmpty((String)cacheAttrValue)) {
            return false;
        }
        cacheAttrValue = cacheAttrValue.toLowerCase();
        if (!this.isCachingEnabled() || "false".equals(cacheAttrValue)) {
            return false;
        }
        if ("true".equals(cacheAttrValue)) {
            return true;
        }
        Expression expression = (Expression)StandardExpressions.getExpressionParser((Configuration)args.getConfiguration()).parseExpression(args.getConfiguration(), (IProcessingContext)args, cacheAttrValue);
        Object o = expression.execute(args.getConfiguration(), (IProcessingContext)args);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            cacheAttrValue = (String)o;
            cacheAttrValue = cacheAttrValue.toLowerCase();
            return "true".equals(cacheAttrValue);
        }
        return false;
    }

    public ProcessorResult processAttribute(Arguments arguments, org.thymeleaf.dom.Element element, String attributeName) {
        if (this.shouldCache(arguments, element, attributeName)) {
            this.fixElement(element, arguments);
            if (this.checkCacheForElement(arguments, element)) {
                element.clearChildren();
                element.clearAttributes();
                element.setRecomputeProcessorsImmediately(true);
            }
        }
        return ProcessorResult.OK;
    }

    protected boolean checkCacheForElement(Arguments arguments, org.thymeleaf.dom.Element element) {
        if (this.isCachingEnabled()) {
            String cacheKey = this.cacheKeyResolver.resolveCacheKey(arguments, element);
            if (!StringUtils.isEmpty((String)cacheKey)) {
                element.setNodeProperty("cacheKey", (Object)cacheKey);
                Element cacheElement = this.getCache().get((Serializable)((Object)cacheKey));
                if (cacheElement != null && !this.checkExpired(element, cacheElement)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Template Cache Hit with cacheKey " + cacheKey + " found in cache."));
                    }
                    element.setNodeProperty("blCacheResponse", cacheElement.getObjectValue());
                    return true;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Template Cache Miss with cacheKey " + cacheKey + " not found in cache."));
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Template not cached due to empty cacheKey");
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Template caching disabled - not retrieving template from cache");
        }
        return false;
    }

    protected boolean checkExpired(org.thymeleaf.dom.Element element, Element cacheElement) {
        if (cacheElement.isExpired()) {
            return true;
        }
        String cacheTimeout = element.getAttributeValue("cacheTimeout");
        if (!StringUtils.isEmpty((String)cacheTimeout) && StringUtils.isNumeric((String)cacheTimeout)) {
            Long timeout = Long.valueOf(cacheTimeout) * 1000L;
            Long expiryTime = cacheElement.getCreationTime() + timeout;
            if (expiryTime < System.currentTimeMillis()) {
                return true;
            }
        }
        return false;
    }

    protected String getFragmentSignatureUnprefixedAttributeName(Arguments arguments, org.thymeleaf.dom.Element element, String attributeName, String attributeValue) {
        return "fragment";
    }

    public int getPrecedence() {
        return Integer.MIN_VALUE;
    }

    public Cache getCache() {
        if (this.cache == null) {
            this.cache = CacheManager.getInstance().getCache("blTemplateElements");
        }
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public boolean isCachingEnabled() {
        WebRequest request;
        String disableCachingParam;
        BroadleafRequestContext brc;
        boolean enabled;
        boolean bl = enabled = !this.systemPropertiesService.resolveBooleanSystemProperty("disableThymeleafTemplateCaching");
        if (enabled && (brc = BroadleafRequestContext.getBroadleafRequestContext()) != null && brc.getWebRequest() != null && "true".equals(disableCachingParam = (request = brc.getWebRequest()).getParameter("disableThymeleafTemplateCaching"))) {
            return false;
        }
        return enabled;
    }
}

