/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.catalog.taglib;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.broadleafcommerce.core.catalog.domain.Product;

public class DisplayFeaturedProductsTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private List<Product> products;
    private String maxFeatures;
    private String var;

    public int doStartTag() throws JspException {
        List<Product> featuredProducts = this.getFeaturedProducts(this.products);
        if (this.maxFeatures != null && !"".equals(this.maxFeatures)) {
            featuredProducts = featuredProducts.subList(0, this.getMaxFeatureCount(this.maxFeatures, featuredProducts.size()));
        }
        this.pageContext.setAttribute(this.var, featuredProducts);
        return 1;
    }

    private List<Product> getFeaturedProducts(List<Product> products) {
        ArrayList<Product> featuredProducts = new ArrayList<Product>();
        if (products != null) {
            for (Product p : products) {
                if (!p.isFeaturedProduct()) continue;
                featuredProducts.add(p);
            }
        }
        return featuredProducts;
    }

    private int getMaxFeatureCount(String count, int max) {
        if (count != null || !"".equals(count)) {
            try {
                if (Integer.parseInt(count) < max) {
                    return Integer.parseInt(count);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return max;
    }

    public String getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(String maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public void setProducts(List<Product> products) {
        this.products = products;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

