/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMExtractor;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyPairGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsKemConfig;
import org.bouncycastle.tls.crypto.TlsKemDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsMLKem;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;

public class BcTlsMLKemDomain
implements TlsKemDomain {
    protected final BcTlsCrypto crypto;
    protected final TlsKemConfig config;
    protected final MLKEMParameters domainParameters;
    protected final boolean isServer;

    public static MLKEMParameters getDomainParameters(TlsKemConfig kemConfig) {
        switch (kemConfig.getNamedGroup()) {
            case 512: 
            case 583: {
                return MLKEMParameters.ml_kem_512;
            }
            case 513: 
            case 584: {
                return MLKEMParameters.ml_kem_768;
            }
            case 514: 
            case 585: {
                return MLKEMParameters.ml_kem_1024;
            }
        }
        throw new IllegalArgumentException("No ML-KEM configuration provided");
    }

    public BcTlsMLKemDomain(BcTlsCrypto crypto, TlsKemConfig kemConfig) {
        this.crypto = crypto;
        this.config = kemConfig;
        this.domainParameters = BcTlsMLKemDomain.getDomainParameters(kemConfig);
        this.isServer = kemConfig.isServer();
    }

    public BcTlsSecret adoptLocalSecret(byte[] secret) {
        return this.crypto.adoptLocalSecret(secret);
    }

    @Override
    public TlsAgreement createKem() {
        return new BcTlsMLKem(this);
    }

    public BcTlsSecret decapsulate(MLKEMPrivateKeyParameters privateKey, byte[] ciphertext) {
        MLKEMExtractor kemExtract = new MLKEMExtractor(privateKey);
        byte[] secret = kemExtract.extractSecret(ciphertext);
        return this.adoptLocalSecret(secret);
    }

    public MLKEMPublicKeyParameters decodePublicKey(byte[] encoding) {
        return new MLKEMPublicKeyParameters(this.domainParameters, encoding);
    }

    public SecretWithEncapsulation encapsulate(MLKEMPublicKeyParameters publicKey) {
        MLKEMGenerator kemGen = new MLKEMGenerator(this.crypto.getSecureRandom());
        return kemGen.generateEncapsulated((AsymmetricKeyParameter)publicKey);
    }

    public byte[] encodePublicKey(MLKEMPublicKeyParameters publicKey) {
        return publicKey.getEncoded();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        MLKEMKeyPairGenerator keyPairGenerator = new MLKEMKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new MLKEMKeyGenerationParameters(this.crypto.getSecureRandom(), this.domainParameters));
        return keyPairGenerator.generateKeyPair();
    }

    public boolean isServer() {
        return this.isServer;
    }
}

