/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;

class JcaTlsStreamVerifier
implements TlsStreamVerifier {
    private final Signature verifier;
    private final OutputStream output;
    private final byte[] signature;

    JcaTlsStreamVerifier(Signature signature, byte[] byArray) {
        this.verifier = signature;
        this.output = OutputStreamFactory.createStream((Signature)signature);
        this.signature = byArray;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.output;
    }

    public boolean isVerified() throws IOException {
        try {
            return this.verifier.verify(this.signature);
        }
        catch (SignatureException signatureException) {
            throw new TlsFatalAlert(80, (Throwable)signatureException);
        }
    }
}

