/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.RSAUtil;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDSAVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSAVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsEd25519Verifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsEd448Verifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAPSSVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAVerifier;
import org.bouncycastle.util.Arrays;

public class BcTlsCertificate
implements TlsCertificate {
    private static final BigInteger X509V3_VERSION = BigInteger.valueOf(2L);
    protected final BcTlsCrypto crypto;
    protected final Certificate certificate;
    protected DHPublicKeyParameters pubKeyDH = null;
    protected ECPublicKeyParameters pubKeyEC = null;
    protected Ed25519PublicKeyParameters pubKeyEd25519 = null;
    protected Ed448PublicKeyParameters pubKeyEd448 = null;
    protected RSAKeyParameters pubKeyRSA = null;

    public static BcTlsCertificate convert(BcTlsCrypto bcTlsCrypto, TlsCertificate tlsCertificate) throws IOException {
        if (tlsCertificate instanceof BcTlsCertificate) {
            return (BcTlsCertificate)tlsCertificate;
        }
        return new BcTlsCertificate(bcTlsCrypto, tlsCertificate.getEncoded());
    }

    public static Certificate parseCertificate(byte[] byArray) throws IOException {
        Certificate certificate;
        try {
            certificate = Certificate.getInstance((Object)byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TlsFatalAlert(42, (Throwable)illegalArgumentException);
        }
        if (!X509V3_VERSION.equals(certificate.getTBSCertificate().getVersion().getValue())) {
            throw new TlsFatalAlert(42);
        }
        return certificate;
    }

    public BcTlsCertificate(BcTlsCrypto bcTlsCrypto, byte[] byArray) throws IOException {
        this(bcTlsCrypto, BcTlsCertificate.parseCertificate(byArray));
    }

    public BcTlsCertificate(BcTlsCrypto bcTlsCrypto, Certificate certificate) {
        this.crypto = bcTlsCrypto;
        this.certificate = certificate;
    }

    public TlsVerifier createVerifier(short s) throws IOException {
        this.validateKeyUsage(128);
        switch (s) {
            case 1: {
                this.validateRSA_PKCS1();
                return new BcTlsRSAVerifier(this.crypto, this.getPubKeyRSA());
            }
            case 2: {
                return new BcTlsDSAVerifier(this.crypto, this.getPubKeyDSS());
            }
            case 3: {
                return new BcTlsECDSAVerifier(this.crypto, this.getPubKeyEC());
            }
            case 7: {
                return new BcTlsEd25519Verifier(this.crypto, this.getPubKeyEd25519());
            }
            case 8: {
                return new BcTlsEd448Verifier(this.crypto, this.getPubKeyEd448());
            }
            case 4: 
            case 5: 
            case 6: {
                this.validateRSA_PSS_RSAE();
                return new BcTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), s);
            }
            case 9: 
            case 10: 
            case 11: {
                this.validateRSA_PSS_PSS(s);
                return new BcTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), s);
            }
        }
        throw new TlsFatalAlert(46);
    }

    public byte[] getEncoded() throws IOException {
        return this.certificate.getEncoded("DER");
    }

    public byte[] getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        Extension extension;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (extension = extensions.getExtension(aSN1ObjectIdentifier)) != null) {
            return Arrays.clone((byte[])extension.getExtnValue().getOctets());
        }
        return null;
    }

    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber().getValue();
    }

    public String getSigAlgOID() {
        return this.certificate.getSignatureAlgorithm().getAlgorithm().getId();
    }

    public ASN1Encodable getSigAlgParams() {
        return this.certificate.getSignatureAlgorithm().getParameters();
    }

    public short getLegacySignatureAlgorithm() throws IOException {
        AsymmetricKeyParameter asymmetricKeyParameter = this.getPublicKey();
        if (asymmetricKeyParameter.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        if (!this.supportsKeyUsage(128)) {
            return -1;
        }
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            return 1;
        }
        if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            return 2;
        }
        if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
            return 3;
        }
        return -1;
    }

    protected DHPublicKeyParameters getPubKeyDH() throws IOException {
        try {
            return (DHPublicKeyParameters)this.getPublicKey();
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(46, (Throwable)runtimeException);
        }
    }

    public DSAPublicKeyParameters getPubKeyDSS() throws IOException {
        try {
            return (DSAPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
    }

    public ECPublicKeyParameters getPubKeyEC() throws IOException {
        try {
            return (ECPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
    }

    public Ed25519PublicKeyParameters getPubKeyEd25519() throws IOException {
        try {
            return (Ed25519PublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
    }

    public Ed448PublicKeyParameters getPubKeyEd448() throws IOException {
        try {
            return (Ed448PublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
    }

    public RSAKeyParameters getPubKeyRSA() throws IOException {
        try {
            return (RSAKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
    }

    public boolean supportsSignatureAlgorithm(short s) throws IOException {
        return this.supportsSignatureAlgorithm(s, 128);
    }

    public boolean supportsSignatureAlgorithmCA(short s) throws IOException {
        return this.supportsSignatureAlgorithm(s, 4);
    }

    public TlsCertificate useInRole(int n, int n2) throws IOException {
        switch (n2) {
            case 7: 
            case 9: {
                this.validateKeyUsage(8);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 16: 
            case 18: {
                this.validateKeyUsage(8);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        if (n == 0) {
            switch (n2) {
                case 1: 
                case 15: {
                    this.validateKeyUsage(32);
                    this.pubKeyRSA = this.getPubKeyRSA();
                    return this;
                }
            }
        }
        throw new TlsFatalAlert(46);
    }

    protected AsymmetricKeyParameter getPublicKey() throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.certificate.getSubjectPublicKeyInfo();
        try {
            return PublicKeyFactory.createKey((SubjectPublicKeyInfo)subjectPublicKeyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43, (Throwable)runtimeException);
        }
    }

    protected boolean supportsKeyUsage(int n) {
        int n2;
        KeyUsage keyUsage;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        return extensions == null || (keyUsage = KeyUsage.fromExtensions((Extensions)extensions)) == null || ((n2 = keyUsage.getBytes()[0] & 0xFF) & n) == n;
    }

    protected boolean supportsRSA_PKCS1() {
        AlgorithmIdentifier algorithmIdentifier = this.certificate.getSubjectPublicKeyInfo().getAlgorithm();
        return RSAUtil.supportsPKCS1(algorithmIdentifier);
    }

    protected boolean supportsRSA_PSS_PSS(short s) {
        AlgorithmIdentifier algorithmIdentifier = this.certificate.getSubjectPublicKeyInfo().getAlgorithm();
        return RSAUtil.supportsPSS_PSS(s, algorithmIdentifier);
    }

    protected boolean supportsRSA_PSS_RSAE() {
        AlgorithmIdentifier algorithmIdentifier = this.certificate.getSubjectPublicKeyInfo().getAlgorithm();
        return RSAUtil.supportsPSS_RSAE(algorithmIdentifier);
    }

    protected boolean supportsSignatureAlgorithm(short s, int n) throws IOException {
        if (!this.supportsKeyUsage(n)) {
            return false;
        }
        AsymmetricKeyParameter asymmetricKeyParameter = this.getPublicKey();
        switch (s) {
            case 1: {
                return this.supportsRSA_PKCS1() && asymmetricKeyParameter instanceof RSAKeyParameters;
            }
            case 2: {
                return asymmetricKeyParameter instanceof DSAPublicKeyParameters;
            }
            case 3: {
                return asymmetricKeyParameter instanceof ECPublicKeyParameters;
            }
            case 7: {
                return asymmetricKeyParameter instanceof Ed25519PublicKeyParameters;
            }
            case 8: {
                return asymmetricKeyParameter instanceof Ed448PublicKeyParameters;
            }
            case 4: 
            case 5: 
            case 6: {
                return this.supportsRSA_PSS_RSAE() && asymmetricKeyParameter instanceof RSAKeyParameters;
            }
            case 9: 
            case 10: 
            case 11: {
                return this.supportsRSA_PSS_PSS(s) && asymmetricKeyParameter instanceof RSAKeyParameters;
            }
        }
        return false;
    }

    protected void validateKeyUsage(int n) throws IOException {
        if (!this.supportsKeyUsage(n)) {
            throw new TlsFatalAlert(46);
        }
    }

    protected void validateRSA_PKCS1() throws IOException {
        if (!this.supportsRSA_PKCS1()) {
            throw new TlsFatalAlert(46);
        }
    }

    protected void validateRSA_PSS_PSS(short s) throws IOException {
        if (!this.supportsRSA_PSS_PSS(s)) {
            throw new TlsFatalAlert(46);
        }
    }

    protected void validateRSA_PSS_RSAE() throws IOException {
        if (!this.supportsRSA_PSS_RSAE()) {
            throw new TlsFatalAlert(46);
        }
    }
}

