/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSocketDirect;
import org.bouncycastle.jsse.provider.ProvSSLSocketDirect_9;
import org.bouncycastle.jsse.provider.ProvSSLSocketWrap;
import org.bouncycastle.jsse.provider.ProvSSLSocketWrap_9;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.SSLSessionUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SSLSocketUtil {
    SSLSocketUtil() {
    }

    static ProvSSLSocketDirect create(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, boolean bl, boolean bl2, ProvSSLParameters provSSLParameters) {
        return new ProvSSLSocketDirect_9(provSSLContextSpi, contextData, bl, bl2, provSSLParameters);
    }

    static ProvSSLSocketDirect create(ProvSSLContextSpi provSSLContextSpi, ContextData contextData) {
        return new ProvSSLSocketDirect_9(provSSLContextSpi, contextData);
    }

    static ProvSSLSocketDirect create(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return new ProvSSLSocketDirect_9(provSSLContextSpi, contextData, inetAddress, n, inetAddress2, n2);
    }

    static ProvSSLSocketDirect create(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, InetAddress inetAddress, int n) throws IOException {
        return new ProvSSLSocketDirect_9(provSSLContextSpi, contextData, inetAddress, n);
    }

    static ProvSSLSocketDirect create(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return new ProvSSLSocketDirect_9(provSSLContextSpi, contextData, string, n, inetAddress, n2);
    }

    static ProvSSLSocketDirect create(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, String string, int n) throws IOException, UnknownHostException {
        return new ProvSSLSocketDirect_9(provSSLContextSpi, contextData, string, n);
    }

    static ProvSSLSocketWrap create(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, Socket socket, InputStream inputStream, boolean bl) throws IOException {
        return new ProvSSLSocketWrap_9(provSSLContextSpi, contextData, socket, inputStream, bl);
    }

    static ProvSSLSocketWrap create(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, Socket socket, String string, int n, boolean bl) throws IOException {
        return new ProvSSLSocketWrap_9(provSSLContextSpi, contextData, socket, string, n, bl);
    }

    static BCExtendedSSLSession importHandshakeSession(SSLSocket sSLSocket) {
        SSLSession sSLSession;
        if (sSLSocket instanceof BCSSLSocket) {
            return ((BCSSLSocket)((Object)sSLSocket)).getBCHandshakeSession();
        }
        if (null != sSLSocket && null != (sSLSession = sSLSocket.getHandshakeSession())) {
            return SSLSessionUtil.importSSLSession(sSLSession);
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLSocket sSLSocket) {
        SSLParameters sSLParameters;
        if (sSLSocket instanceof BCSSLSocket) {
            return ((BCSSLSocket)((Object)sSLSocket)).getParameters();
        }
        if (null != sSLSocket && null != (sSLParameters = sSLSocket.getSSLParameters())) {
            return SSLParametersUtil.importSSLParameters(sSLParameters);
        }
        return null;
    }
}

