/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;

class RSAUtil {
    RSAUtil() {
    }

    static String getDigestSigAlgName(String string) {
        int n = string.indexOf(45);
        if (n > 0 && !string.startsWith("SHA3")) {
            return string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    static AlgorithmParameterSpec getPSSParameterSpec(int n, String string, JcaJceHelper jcaJceHelper) {
        int n2 = TlsCryptoUtils.getHashOutputSize(n);
        AlgorithmIdentifier algorithmIdentifier = RSAUtil.getHashAlgorithmID(n);
        RSASSAPSSparams rSASSAPSSparams = new RSASSAPSSparams(algorithmIdentifier, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)algorithmIdentifier), new ASN1Integer((long)n2), RSASSAPSSparams.DEFAULT_TRAILER_FIELD);
        try {
            AlgorithmParameters algorithmParameters = jcaJceHelper.createAlgorithmParameters("PSS");
            algorithmParameters.init(rSASSAPSSparams.getEncoded(), "ASN.1");
            return algorithmParameters.getParameterSpec(AlgorithmParameterSpec.class);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot encode RSASSAPSSparams: " + iOException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("cannot recover PSS paramSpec: " + generalSecurityException.getMessage());
        }
    }

    private static AlgorithmIdentifier getHashAlgorithmID(int n) {
        switch (n) {
            case 4: {
                return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE);
            }
            case 5: {
                return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, (ASN1Encodable)DERNull.INSTANCE);
            }
            case 6: {
                return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, (ASN1Encodable)DERNull.INSTANCE);
            }
        }
        return null;
    }
}

