/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;

public class JceAEADCipherImpl
implements TlsAEADCipherImpl {
    private final JcaTlsCrypto crypto;
    private final JcaJceHelper helper;
    private final int cipherMode;
    private final Cipher cipher;
    private final String algorithm;
    private final int keySize;
    private final String algorithmParamsName;
    private SecretKey key;
    private byte[] nonce;
    private int macSize;

    private static String getAlgParamsName(JcaJceHelper jcaJceHelper, String string) {
        try {
            String string2 = string.indexOf("CCM") > -1 ? "CCM" : "GCM";
            jcaJceHelper.createAlgorithmParameters(string2);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JceAEADCipherImpl(JcaTlsCrypto jcaTlsCrypto, JcaJceHelper jcaJceHelper, String string, String string2, int n, boolean bl) throws GeneralSecurityException {
        this.crypto = jcaTlsCrypto;
        this.helper = jcaJceHelper;
        this.cipher = jcaJceHelper.createCipher(string);
        this.algorithm = string2;
        this.keySize = n;
        this.cipherMode = bl ? 1 : 2;
        this.algorithmParamsName = JceAEADCipherImpl.getAlgParamsName(jcaJceHelper, string);
    }

    public void setKey(byte[] byArray, int n, int n2) {
        if (this.keySize != n2) {
            throw new IllegalStateException();
        }
        this.key = new SecretKeySpec(byArray, n, n2, this.algorithm);
    }

    public void init(byte[] byArray, int n) {
        SecureRandom secureRandom = this.crypto.getSecureRandom();
        try {
            this.nonce = Arrays.clone((byte[])byArray);
            this.macSize = n;
        }
        catch (Exception exception) {
            throw Exceptions.illegalStateException(exception.getMessage(), exception);
        }
    }

    public int getOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    public int doFinal(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) throws IOException {
        try {
            if (!Arrays.isNullOrEmpty((byte[])byArray)) {
                this.cipher.init(this.cipherMode, (Key)this.key, (AlgorithmParameterSpec)new AEADParameterSpec(this.nonce, this.macSize * 8, byArray));
            } else {
                this.cipher.init(this.cipherMode, (Key)this.key, (AlgorithmParameterSpec)new AEADParameterSpec(this.nonce, this.macSize * 8, null));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        try {
            return this.cipher.doFinal(byArray2, n, n2, byArray3, n3);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException("", generalSecurityException);
        }
    }
}

