/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsSecret;

public class TlsECDHanonKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsECConfig ecConfig;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int n) {
        switch (n) {
            case 20: {
                return n;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHanonKeyExchange(int n) {
        this(n, null);
    }

    public TlsECDHanonKeyExchange(int n, TlsECConfig tlsECConfig) {
        super(TlsECDHanonKeyExchange.checkKeyExchange(n));
        this.ecConfig = tlsECConfig;
    }

    public void skipServerCredentials() throws IOException {
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public boolean requiresServerKeyExchange() {
        return true;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsECCUtils.writeECConfig(this.ecConfig, byteArrayOutputStream);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.generateEphemeral(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        this.ecConfig = TlsECCUtils.receiveECDHConfig(this.context, inputStream);
        byte[] byArray = TlsUtils.readOpaque8(inputStream, 1);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.processEphemeral(byArray);
    }

    public short[] getClientCertificateTypes() {
        return null;
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        this.generateEphemeral(outputStream);
    }

    public void processClientCertificate(Certificate certificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque8(inputStream, 1);
        this.processEphemeral(byArray);
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreement.calculateSecret();
    }

    protected void generateEphemeral(OutputStream outputStream) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque8(byArray, outputStream);
    }

    protected void processEphemeral(byte[] byArray) throws IOException {
        TlsECCUtils.checkPointEncoding(this.ecConfig.getNamedGroup(), byArray);
        this.agreement.receivePeerValue(byArray);
    }
}

