/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.Provider;
import java.security.Security;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.util.Strings;

class JcaUtils {
    JcaUtils() {
    }

    static String getJcaAlgorithmName(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        return HashAlgorithm.getName(signatureAndHashAlgorithm.getHash()) + "WITH" + Strings.toUpperCase((String)SignatureAlgorithm.getName(signatureAndHashAlgorithm.getSignature()));
    }

    static boolean isSunMSCAPIProviderActive() {
        return null != Security.getProvider("SunMSCAPI");
    }

    static boolean isSunMSCAPIProvider(Provider provider) {
        return null != provider && JcaUtils.isSunMSCAPIProviderName(provider.getName());
    }

    static boolean isSunMSCAPIProviderName(String string) {
        return "SunMSCAPI".equals(string);
    }
}

