/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.AlgorithmParameters;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jce.interfaces.ECKey;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

class ECUtil {
    ECUtil() {
    }

    static int[] convertMidTerms(int[] nArray) {
        int[] nArray2 = new int[3];
        if (nArray.length == 1) {
            nArray2[0] = nArray[0];
        } else {
            if (nArray.length != 3) {
                throw new IllegalArgumentException("Only Trinomials and pentanomials supported");
            }
            if (nArray[0] < nArray[1] && nArray[0] < nArray[2]) {
                nArray2[0] = nArray[0];
                if (nArray[1] < nArray[2]) {
                    nArray2[1] = nArray[1];
                    nArray2[2] = nArray[2];
                } else {
                    nArray2[1] = nArray[2];
                    nArray2[2] = nArray[1];
                }
            } else if (nArray[1] < nArray[2]) {
                nArray2[0] = nArray[1];
                if (nArray[0] < nArray[2]) {
                    nArray2[1] = nArray[0];
                    nArray2[2] = nArray[2];
                } else {
                    nArray2[1] = nArray[2];
                    nArray2[2] = nArray[0];
                }
            } else {
                nArray2[0] = nArray[2];
                if (nArray[0] < nArray[1]) {
                    nArray2[1] = nArray[0];
                    nArray2[2] = nArray[1];
                } else {
                    nArray2[1] = nArray[1];
                    nArray2[2] = nArray[0];
                }
            }
        }
        return nArray2;
    }

    static AlgorithmParameterSpec createInitSpec(String string) {
        return new ECNamedCurveGenParameterSpec(string);
    }

    static AlgorithmParameters getAlgorithmParameters(JcaTlsCrypto jcaTlsCrypto, String string) {
        return ECUtil.getAlgorithmParameters(jcaTlsCrypto, (AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec(string));
    }

    static AlgorithmParameters getAlgorithmParameters(JcaTlsCrypto jcaTlsCrypto, AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            AlgorithmParameters algorithmParameters = jcaTlsCrypto.getHelper().createAlgorithmParameters("EC");
            algorithmParameters.init(algorithmParameterSpec);
            ECParameterSpec eCParameterSpec = (ECParameterSpec)algorithmParameters.getParameterSpec(ECParameterSpec.class);
            if (null != eCParameterSpec) {
                return algorithmParameters;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static ECParameterSpec getECParameterSpec(JcaTlsCrypto jcaTlsCrypto, String string) {
        return ECUtil.getECParameterSpec(jcaTlsCrypto, ECUtil.createInitSpec(string));
    }

    static ECParameterSpec getECParameterSpec(JcaTlsCrypto jcaTlsCrypto, AlgorithmParameterSpec algorithmParameterSpec) {
        Object object;
        Object object2;
        try {
            object2 = jcaTlsCrypto.getHelper().createAlgorithmParameters("EC");
            ((AlgorithmParameters)object2).init(algorithmParameterSpec);
            object = (ECParameterSpec)((AlgorithmParameters)object2).getParameterSpec(ECParameterSpec.class);
            if (null != object) {
                return object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object2 = jcaTlsCrypto.getHelper().createKeyPairGenerator("EC");
            ((KeyPairGenerator)object2).initialize(algorithmParameterSpec, jcaTlsCrypto.getSecureRandom());
            object = ((KeyPairGenerator)object2).generateKeyPair();
            return ((ECKey)((KeyPair)object).getPrivate()).getParams();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static boolean isECPrivateKey(PrivateKey privateKey) {
        return privateKey instanceof ECPrivateKey || "EC".equalsIgnoreCase(privateKey.getAlgorithm());
    }

    static boolean isCurveSupported(JcaTlsCrypto jcaTlsCrypto, String string) {
        return ECUtil.isCurveSupported(jcaTlsCrypto, new ECNamedCurveGenParameterSpec(string));
    }

    static boolean isCurveSupported(JcaTlsCrypto jcaTlsCrypto, ECNamedCurveGenParameterSpec eCNamedCurveGenParameterSpec) {
        return null != ECUtil.getECParameterSpec(jcaTlsCrypto, (AlgorithmParameterSpec)eCNamedCurveGenParameterSpec);
    }
}

