/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.TlsUtils;

public class SignatureAndHashAlgorithm {
    public static final SignatureAndHashAlgorithm ed25519 = new SignatureAndHashAlgorithm(8, 7);
    public static final SignatureAndHashAlgorithm ed448 = new SignatureAndHashAlgorithm(8, 8);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha256 = new SignatureAndHashAlgorithm(8, 4);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha384 = new SignatureAndHashAlgorithm(8, 5);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha512 = new SignatureAndHashAlgorithm(8, 6);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha256 = new SignatureAndHashAlgorithm(8, 9);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha384 = new SignatureAndHashAlgorithm(8, 10);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha512 = new SignatureAndHashAlgorithm(8, 11);
    protected final short hash;
    protected final short signature;

    public static SignatureAndHashAlgorithm getInstance(short s, short s2) {
        switch (s) {
            case 8: {
                return SignatureAndHashAlgorithm.getInstanceIntrinsic(s2);
            }
        }
        return new SignatureAndHashAlgorithm(s, s2);
    }

    public static SignatureAndHashAlgorithm getInstanceIntrinsic(short s) {
        switch (s) {
            case 7: {
                return ed25519;
            }
            case 8: {
                return ed448;
            }
            case 4: {
                return rsa_pss_rsae_sha256;
            }
            case 5: {
                return rsa_pss_rsae_sha384;
            }
            case 6: {
                return rsa_pss_rsae_sha512;
            }
            case 9: {
                return rsa_pss_pss_sha256;
            }
            case 10: {
                return rsa_pss_pss_sha384;
            }
            case 11: {
                return rsa_pss_pss_sha512;
            }
        }
        return new SignatureAndHashAlgorithm(8, s);
    }

    public SignatureAndHashAlgorithm(short s, short s2) {
        if ((s & 0xFF) != s) {
            throw new IllegalArgumentException("'hash' should be a uint8");
        }
        if ((s2 & 0xFF) != s2) {
            throw new IllegalArgumentException("'signature' should be a uint8");
        }
        this.hash = s;
        this.signature = s2;
    }

    public short getHash() {
        return this.hash;
    }

    public short getSignature() {
        return this.signature;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.getHash(), outputStream);
        TlsUtils.writeUint8(this.getSignature(), outputStream);
    }

    public static SignatureAndHashAlgorithm parse(InputStream inputStream) throws IOException {
        short s = TlsUtils.readUint8(inputStream);
        short s2 = TlsUtils.readUint8(inputStream);
        return SignatureAndHashAlgorithm.getInstance(s, s2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SignatureAndHashAlgorithm)) {
            return false;
        }
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)object;
        return signatureAndHashAlgorithm.getHash() == this.getHash() && signatureAndHashAlgorithm.getSignature() == this.getSignature();
    }

    public int hashCode() {
        return this.getHash() << 16 | this.getSignature();
    }

    public String toString() {
        return "{" + HashAlgorithm.getText(this.hash) + "," + SignatureAlgorithm.getText(this.signature) + "}";
    }
}

