/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceTlsSecret
extends AbstractTlsSecret {
    private final JcaTlsCrypto crypto;

    public JceTlsSecret(JcaTlsCrypto jcaTlsCrypto, byte[] byArray) {
        super(byArray);
        this.crypto = jcaTlsCrypto;
    }

    public synchronized TlsSecret deriveUsingPRF(int n, String string, byte[] byArray, int n2) {
        KDFCalculator kDFCalculator;
        this.checkAlive();
        if (n == 0) {
            kDFCalculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(FipsKDF.TLS1_1.using(this.data, string, (byte[][])new byte[][]{byArray}));
        } else if (n == 1) {
            kDFCalculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(FipsKDF.TLS1_2.withPRF(FipsKDF.TLSPRF.SHA256_HMAC).using(this.data, string, (byte[][])new byte[][]{byArray}));
        } else if (n == 2) {
            kDFCalculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(FipsKDF.TLS1_2.withPRF(FipsKDF.TLSPRF.SHA384_HMAC).using(this.data, string, (byte[][])new byte[][]{byArray}));
        } else {
            throw new IllegalStateException("unknown prf: " + n);
        }
        byte[] byArray2 = new byte[n2];
        kDFCalculator.generateBytes(byArray2);
        return this.crypto.adoptLocalSecret(byArray2);
    }

    protected TlsSecret adoptLocalSecret(byte[] byArray) {
        return this.crypto.adoptLocalSecret(byArray);
    }

    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }
}

