/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.OutputStreamFactory;
import org.bouncycastle.tls.crypto.impl.jcajce.RSAUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaTlsRSAPSSVerifier
implements TlsVerifier {
    private final JcaTlsCrypto crypto;
    private final PublicKey publicKey;
    private final short signatureAlgorithm;

    public JcaTlsRSAPSSVerifier(JcaTlsCrypto jcaTlsCrypto, PublicKey publicKey, short s) {
        if (null == jcaTlsCrypto) {
            throw new NullPointerException("crypto");
        }
        if (null == publicKey) {
            throw new NullPointerException("publicKey");
        }
        if (!SignatureAlgorithm.isRSAPSS(s)) {
            throw new IllegalArgumentException("signatureAlgorithm");
        }
        this.crypto = jcaTlsCrypto;
        this.publicKey = publicKey;
        this.signatureAlgorithm = s;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null || signatureAndHashAlgorithm.getSignature() != this.signatureAlgorithm || signatureAndHashAlgorithm.getHash() != 8) {
            throw new IllegalStateException();
        }
        final byte[] byArray = digitallySigned.getSignature();
        short s = SignatureAlgorithm.getRSAPSSHashAlgorithm(this.signatureAlgorithm);
        String string = this.crypto.getDigestName(s);
        String string2 = RSAUtil.getDigestSigAlgName(string) + "WITHRSAANDMGF1";
        try {
            final Signature signature = this.crypto.getHelper().createSignature(string2);
            AlgorithmParameterSpec algorithmParameterSpec = RSAUtil.getPSSParameterSpec(s, string, this.crypto.getHelper());
            signature.setParameter(algorithmParameterSpec);
            signature.initVerify(this.publicKey);
            final OutputStream outputStream = OutputStreamFactory.createStream(signature);
            return new TlsStreamVerifier(){

                @Override
                public OutputStream getOutputStream() throws IOException {
                    return outputStream;
                }

                @Override
                public boolean isVerified() throws IOException {
                    try {
                        return signature.verify(byArray);
                    }
                    catch (SignatureException signatureException) {
                        throw new IOException(signatureException.getMessage());
                    }
                }
            };
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException(string2 + " verification failed", generalSecurityException);
        }
    }
}

