/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.OutputStreamFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class JcaTlsEdDSASigner
implements TlsSigner {
    protected final JcaTlsCrypto crypto;
    protected final PrivateKey privateKey;
    protected final short algorithmType;
    protected final String algorithmName;

    public JcaTlsEdDSASigner(JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, short s, String string) {
        if (null == jcaTlsCrypto) {
            throw new NullPointerException("crypto");
        }
        if (null == privateKey) {
            throw new NullPointerException("privateKey");
        }
        this.crypto = jcaTlsCrypto;
        this.privateKey = privateKey;
        this.algorithmType = s;
        this.algorithmName = string;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        if (signatureAndHashAlgorithm == null || signatureAndHashAlgorithm.getSignature() != this.algorithmType || signatureAndHashAlgorithm.getHash() != 8) {
            throw new IllegalStateException();
        }
        try {
            final Signature signature = this.crypto.getHelper().createSignature(this.algorithmName);
            signature.initSign(this.privateKey);
            final OutputStream outputStream = OutputStreamFactory.createStream(signature);
            return new TlsStreamSigner(){

                @Override
                public OutputStream getOutputStream() throws IOException {
                    return outputStream;
                }

                @Override
                public byte[] getSignature() throws IOException {
                    try {
                        return signature.sign();
                    }
                    catch (SignatureException signatureException) {
                        throw new IOException(signatureException.getMessage());
                    }
                }
            };
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException(this.algorithmName + " signature failed", generalSecurityException);
        }
    }
}

