/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

public class JceTlsSecret
extends AbstractTlsSecret {
    private final JcaTlsCrypto crypto;

    public JceTlsSecret(JcaTlsCrypto crypto, byte[] data) {
        super(data);
        this.crypto = crypto;
    }

    public synchronized TlsSecret deriveUsingPRF(int prfAlgorithm, String label, byte[] seed, int length) {
        KDFCalculator calculator;
        this.checkAlive();
        if (prfAlgorithm == 0) {
            calculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(FipsKDF.TLS1_1.using(this.data, label, (byte[][])new byte[][]{seed}));
        } else if (prfAlgorithm == 1) {
            calculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(FipsKDF.TLS1_2.withPRF(FipsKDF.TLSPRF.SHA256_HMAC).using(this.data, label, (byte[][])new byte[][]{seed}));
        } else if (prfAlgorithm == 2) {
            calculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(FipsKDF.TLS1_2.withPRF(FipsKDF.TLSPRF.SHA384_HMAC).using(this.data, label, (byte[][])new byte[][]{seed}));
        } else {
            throw new IllegalStateException("unknown prf: " + prfAlgorithm);
        }
        byte[] result = new byte[length];
        calculator.generateBytes(result);
        return this.crypto.adoptLocalSecret(result);
    }

    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }
}

