/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDH;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.util.BigIntegers;

public class JceTlsDHDomain
implements TlsDHDomain {
    protected final JcaTlsCrypto crypto;
    protected final TlsDHConfig dhConfig;
    protected final DHParameterSpec dhParameterSpec;

    public static DHParameterSpec getParameters(TlsDHConfig dhConfig) {
        DHGroup dhGroup = TlsDHUtils.getDHGroup(dhConfig);
        if (dhGroup == null) {
            throw new IllegalArgumentException("No DH configuration provided");
        }
        return new DHParameterSpec(dhGroup.getP(), dhGroup.getG(), dhGroup.getL());
    }

    public JceTlsDHDomain(JcaTlsCrypto crypto, TlsDHConfig dhConfig) {
        this.crypto = crypto;
        this.dhConfig = dhConfig;
        this.dhParameterSpec = JceTlsDHDomain.getParameters(dhConfig);
    }

    public JceTlsSecret calculateDHAgreement(DHPrivateKey privateKey, DHPublicKey publicKey) throws IOException {
        try {
            SecretKey secretKey = this.crypto.calculateKeyAgreement("DH", privateKey, publicKey, "TlsPremasterSecret");
            return this.crypto.adoptLocalSecret(secretKey.getEncoded());
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("cannot calculate secret", e);
        }
    }

    public TlsAgreement createDH() {
        return new JceTlsDH(this);
    }

    public static BigInteger decodeParameter(byte[] encoding) throws IOException {
        return new BigInteger(1, encoding);
    }

    public DHPublicKey decodePublicKey(byte[] encoding) throws IOException {
        try {
            BigInteger y = JceTlsDHDomain.decodeParameter(encoding);
            KeyFactory keyFactory = this.crypto.getHelper().createKeyFactory("DH");
            return (DHPublicKey)keyFactory.generatePublic(new DHPublicKeySpec(y, this.dhParameterSpec.getP(), this.dhParameterSpec.getG()));
        }
        catch (Exception e) {
            throw new TlsFatalAlert(40, (Throwable)e);
        }
    }

    public byte[] encodeParameter(BigInteger x) throws IOException {
        return BigIntegers.asUnsignedByteArray((BigInteger)x);
    }

    public byte[] encodePublicKey(DHPublicKey publicKey) throws IOException {
        return this.encodeParameter(publicKey.getY());
    }

    public KeyPair generateKeyPair() throws IOException {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("DH");
            keyPairGenerator.initialize(this.dhParameterSpec, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("unable to create key pair", e);
        }
    }
}

