/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BCSSLParameters {
    private String[] cipherSuites;
    private String[] protocols;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private List<BCSNIServerName> serverNames;
    private List<BCSNIMatcher> sniMatchers;

    private static String[] clone(String[] stringArray) {
        return stringArray == null ? null : (String[])stringArray.clone();
    }

    private static <T> List<T> copyList(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    public BCSSLParameters() {
    }

    public BCSSLParameters(String[] stringArray) {
        this.setCipherSuites(stringArray);
    }

    public BCSSLParameters(String[] stringArray, String[] stringArray2) {
        this.setCipherSuites(stringArray);
        this.setProtocols(stringArray2);
    }

    public String[] getCipherSuites() {
        return BCSSLParameters.clone(this.cipherSuites);
    }

    public void setCipherSuites(String[] stringArray) {
        this.cipherSuites = BCSSLParameters.clone(stringArray);
    }

    public String[] getProtocols() {
        return BCSSLParameters.clone(this.protocols);
    }

    public void setProtocols(String[] stringArray) {
        this.protocols = BCSSLParameters.clone(stringArray);
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
        this.needClientAuth = false;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
        this.wantClientAuth = false;
    }

    public void setServerNames(List<BCSNIServerName> list) {
        if (list == null) {
            this.serverNames = null;
        } else {
            List<BCSNIServerName> list2 = BCSSLParameters.copyList(list);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (BCSNIServerName bCSNIServerName : list2) {
                int n = bCSNIServerName.getType();
                if (hashSet.add(n)) continue;
                throw new IllegalArgumentException("Found duplicate SNI server name entry of type " + n);
            }
            this.serverNames = list2;
        }
    }

    public List<BCSNIServerName> getServerNames() {
        return BCSSLParameters.copyList(this.serverNames);
    }

    public void setSNIMatchers(Collection<BCSNIMatcher> collection) {
        if (collection == null) {
            this.sniMatchers = null;
        } else {
            List<BCSNIMatcher> list = BCSSLParameters.copyList(collection);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (BCSNIMatcher bCSNIMatcher : list) {
                int n = bCSNIMatcher.getType();
                if (hashSet.add(n)) continue;
                throw new IllegalArgumentException("Found duplicate SNI matcher entry of type " + n);
            }
            this.sniMatchers = list;
        }
    }

    public Collection<BCSNIMatcher> getSNIMatchers() {
        return BCSSLParameters.copyList(this.sniMatchers);
    }
}

