/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.crypto.impl.TlsStreamCipherImpl;

public class JceStreamCipherImpl
implements TlsStreamCipherImpl {
    private final int cipherMode;
    private final Cipher cipher;
    private final String baseAlgorithm;
    private SecretKey key;
    private boolean hasNoIv;

    public JceStreamCipherImpl(Cipher cipher, String string, boolean bl) throws GeneralSecurityException {
        this.cipher = cipher;
        this.baseAlgorithm = string;
        this.cipherMode = bl ? 1 : 2;
    }

    public void setKey(byte[] byArray) {
        this.key = new SecretKeySpec(byArray, this.baseAlgorithm);
    }

    public void init(byte[] byArray) {
        try {
            if (byArray != null) {
                this.hasNoIv = false;
                this.cipher.init(this.cipherMode, (Key)this.key, new IvParameterSpec(byArray));
            } else {
                this.hasNoIv = true;
                this.cipher.init(this.cipherMode, this.key);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException(generalSecurityException);
        }
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        try {
            if (this.hasNoIv) {
                int n4 = this.cipher.update(byArray, n, n2, byArray2, n3);
                return n4;
            }
            int n5 = this.cipher.doFinal(byArray, n, n2, byArray2, n3);
            return n5;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException(generalSecurityException);
        }
    }
}

