/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HandshakeMessageInput;
import org.bouncycastle.tls.HandshakeMessageOutput;
import org.bouncycastle.tls.KeyShareEntry;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContextImpl;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    TlsClientContextImpl tlsClientContext = null;
    protected Hashtable clientAgreements = null;
    protected ClientHello clientHello = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateStatus certificateStatus = null;
    protected CertificateRequest certificateRequest = null;

    public TlsClientProtocol() {
    }

    public TlsClientProtocol(InputStream input, OutputStream output) {
        super(input, output);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("'connect' can only be called once");
        }
        this.tlsClient = tlsClient;
        this.tlsClientContext = new TlsClientContextImpl(tlsClient.getCrypto());
        tlsClient.init(this.tlsClientContext);
        tlsClient.notifyCloseHandle(this);
        this.beginHandshake();
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    protected void beginHandshake() throws IOException {
        super.beginHandshake();
        this.establishSession(this.tlsClient.getSessionToResume());
        this.tlsClient.notifySessionToResume(this.tlsSession);
        this.sendClientHello();
        this.connection_state = 1;
    }

    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.clientAgreements = null;
        this.clientHello = null;
        this.keyExchange = null;
        this.authentication = null;
        this.certificateStatus = null;
        this.certificateRequest = null;
    }

    protected TlsContext getContext() {
        return this.tlsClientContext;
    }

    AbstractTlsContext getContextAdmin() {
        return this.tlsClientContext;
    }

    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    protected void handle13HandshakeMessage(short type, HandshakeMessageInput buf) throws IOException {
        if (!this.isTLSv13ConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (this.resumedSession) {
            throw new TlsFatalAlert(80);
        }
        block0 : switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 5: {
                        this.skip13CertificateRequest();
                    }
                    case 11: {
                        this.receive13ServerCertificate(buf);
                        this.connection_state = (short)7;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 13: {
                switch (this.connection_state) {
                    case 21: {
                        throw new TlsFatalAlert(10);
                    }
                    case 5: {
                        this.receive13CertificateRequest(buf, false);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 7: {
                        this.receive13ServerCertificateVerify(buf);
                        buf.updateHash(this.handshakeHash);
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 8: {
                switch (this.connection_state) {
                    case 4: {
                        this.receive13EncryptedExtensions(buf);
                        this.connection_state = (short)5;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 5: {
                        this.skip13CertificateRequest();
                    }
                    case 11: {
                        this.skip13ServerCertificate();
                    }
                    case 9: {
                        this.receive13ServerFinished(buf);
                        buf.updateHash(this.handshakeHash);
                        this.connection_state = (short)20;
                        byte[] serverFinishedTranscriptHash = TlsUtils.getCurrentPRFHash(this.handshakeHash);
                        this.recordStream.setIgnoreChangeCipherSpec(false);
                        if (null != this.certificateRequest) {
                            TlsCredentialedSigner clientCredentials = TlsUtils.establish13ClientCredentials(this.authentication, this.certificateRequest);
                            Certificate clientCertificate = null;
                            if (null != clientCredentials) {
                                clientCertificate = clientCredentials.getCertificate();
                            }
                            if (null == clientCertificate) {
                                clientCertificate = Certificate.EMPTY_CHAIN_TLS13;
                            }
                            this.send13CertificateMessage(clientCertificate);
                            this.connection_state = (short)15;
                            if (null != clientCredentials) {
                                DigitallySigned certificateVerify = TlsUtils.generate13CertificateVerify(this.tlsClientContext, clientCredentials, this.handshakeHash);
                                this.send13CertificateVerifyMessage(certificateVerify);
                                this.connection_state = (short)17;
                            }
                        }
                        this.send13FinishedMessage();
                        this.connection_state = (short)18;
                        TlsUtils.establish13PhaseApplication(this.tlsClientContext, serverFinishedTranscriptHash, this.recordStream);
                        this.recordStream.enablePendingCipherWrite();
                        this.recordStream.enablePendingCipherRead(false);
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 24: {
                this.receive13KeyUpdate(buf);
                break;
            }
            case 4: {
                this.receive13NewSessionTicket(buf);
                break;
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        throw new TlsFatalAlert(80);
                    }
                    case 3: {
                        ServerHello serverHello = this.receiveServerHelloMessage(buf);
                        if (serverHello.isHelloRetryRequest()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.process13ServerHello(serverHello, true);
                        buf.updateHash(this.handshakeHash);
                        this.connection_state = (short)4;
                        this.process13ServerHelloCoda(serverHello, true);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleHandshakeMessage(short type, HandshakeMessageInput buf) throws IOException {
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParameters();
        if (this.connection_state > 1 && TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            this.handle13HandshakeMessage(type, buf);
            return;
        }
        if (!this.isLegacyConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (this.resumedSession) {
            if (type != 20 || this.connection_state != 4) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(buf);
            buf.updateHash(this.handshakeHash);
            this.connection_state = (short)20;
            this.sendChangeCipherSpec();
            this.sendFinishedMessage();
            this.connection_state = (short)18;
            this.completeHandshake();
            return;
        }
        block0 : switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = TlsUtils.receiveServerCertificate(this.tlsClientContext, this.tlsClient, buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)7;
                break;
            }
            case 22: {
                switch (this.connection_state) {
                    case 7: {
                        if (securityParameters.getStatusRequestVersion() < 1) {
                            throw new TlsFatalAlert(10);
                        }
                        this.certificateStatus = CertificateStatus.parse(this.tlsClientContext, buf);
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)8;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 18: {
                        if (this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 19: {
                        this.processFinishedMessage(buf);
                        this.connection_state = (short)20;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        ServerHello serverHello = this.receiveServerHelloMessage(buf);
                        if (serverHello.isHelloRetryRequest()) {
                            this.process13HelloRetryRequest(serverHello);
                            this.handshakeHash.notifyPRFDetermined();
                            TlsUtils.adjustTranscriptForRetry(this.handshakeHash);
                            buf.updateHash(this.handshakeHash);
                            this.connection_state = (short)2;
                            this.send13ClientHelloRetry();
                            this.connection_state = (short)3;
                            break block0;
                        }
                        this.processServerHello(serverHello);
                        this.handshakeHash.notifyPRFDetermined();
                        buf.updateHash(this.handshakeHash);
                        this.connection_state = (short)4;
                        if (!TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) break block0;
                        this.process13ServerHelloCoda(serverHello, false);
                        break block0;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
            }
            case 23: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage(buf));
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 14: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = null;
                    }
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 10: 
                    case 11: {
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)12;
                        Vector clientSupplementalData = this.tlsClient.getClientSupplementalData();
                        if (clientSupplementalData != null) {
                            this.sendSupplementalDataMessage(clientSupplementalData);
                            this.connection_state = (short)14;
                        }
                        TlsCredentialedSigner credentialedSigner = null;
                        TlsStreamSigner streamSigner = null;
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            Certificate clientCertificate = null;
                            TlsCredentials clientCredentials = TlsUtils.establishClientCredentials(this.authentication, this.certificateRequest);
                            if (null == clientCredentials) {
                                this.keyExchange.skipClientCredentials();
                            } else {
                                this.keyExchange.processClientCredentials(clientCredentials);
                                clientCertificate = clientCredentials.getCertificate();
                                if (clientCredentials instanceof TlsCredentialedSigner) {
                                    credentialedSigner = (TlsCredentialedSigner)clientCredentials;
                                    streamSigner = credentialedSigner.getStreamSigner();
                                }
                            }
                            this.sendCertificateMessage(clientCertificate, null);
                            this.connection_state = (short)15;
                        }
                        boolean forceBuffering = streamSigner != null;
                        TlsUtils.sealHandshakeHash(this.tlsClientContext, this.handshakeHash, forceBuffering);
                        this.sendClientKeyExchange();
                        this.connection_state = (short)16;
                        boolean isSSL = TlsUtils.isSSL(this.tlsClientContext);
                        if (isSSL) {
                            TlsClientProtocol.establishMasterSecret(this.tlsClientContext, this.keyExchange);
                        }
                        securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(this.handshakeHash);
                        if (!isSSL) {
                            TlsClientProtocol.establishMasterSecret(this.tlsClientContext, this.keyExchange);
                        }
                        this.recordStream.setPendingCipher(TlsUtils.initCipher(this.tlsClientContext));
                        if (credentialedSigner != null) {
                            DigitallySigned certificateVerify = TlsUtils.generateCertificateVerifyClient(this.tlsClientContext, credentialedSigner, streamSigner, this.handshakeHash);
                            this.sendCertificateVerifyMessage(certificateVerify);
                            this.connection_state = (short)17;
                        }
                        this.handshakeHash = this.handshakeHash.stopTracking();
                        this.sendChangeCipherSpec();
                        this.sendFinishedMessage();
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)18;
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = null;
                    }
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.processServerKeyExchange(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)10;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 10: {
                        this.receiveCertificateRequest(buf);
                        TlsUtils.establishServerSigAlgs(securityParameters, this.certificateRequest);
                        TlsUtils.trackHashAlgorithms(this.handshakeHash, securityParameters.getServerSigAlgs());
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)11;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 18: {
                        if (!this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                        this.invalidateSession();
                        this.receiveNewSessionTicket(buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)19;
                break;
            }
            case 0: {
                TlsClientProtocol.assertEmpty(buf);
                if (!this.isApplicationDataReady()) break;
                this.refuseRenegotiation();
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleServerCertificate() throws IOException {
        TlsUtils.processServerCertificate(this.tlsClientContext, this.certificateStatus, this.keyExchange, this.authentication, this.clientExtensions, this.serverExtensions);
    }

    protected void handleSupplementalData(Vector serverSupplementalData) throws IOException {
        this.tlsClient.processServerSupplementalData(serverSupplementalData);
        this.connection_state = (short)6;
        this.keyExchange = TlsUtils.initKeyExchangeClient(this.tlsClientContext, this.tlsClient);
    }

    protected void process13HelloRetryRequest(ServerHello helloRetryRequest) throws IOException {
        ProtocolVersion legacy_record_version = ProtocolVersion.TLSv12;
        this.recordStream.setWriteVersion(legacy_record_version);
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        ProtocolVersion legacy_version = helloRetryRequest.getVersion();
        byte[] legacy_session_id_echo = helloRetryRequest.getSessionID();
        int cipherSuite = helloRetryRequest.getCipherSuite();
        if (!(ProtocolVersion.TLSv12.equals(legacy_version) && Arrays.areEqual((byte[])this.clientHello.getSessionID(), (byte[])legacy_session_id_echo) && TlsUtils.isValidCipherSuiteSelection(this.clientHello.getCipherSuites(), cipherSuite))) {
            throw new TlsFatalAlert(47);
        }
        Hashtable extensions = helloRetryRequest.getExtensions();
        if (null == extensions) {
            throw new TlsFatalAlert(47);
        }
        TlsUtils.checkExtensionData13(extensions, 6, (short)47);
        Enumeration e = extensions.keys();
        while (e.hasMoreElements()) {
            Integer extType = (Integer)e.nextElement();
            if (44 == extType || null != TlsUtils.getExtensionData(this.clientExtensions, extType)) continue;
            throw new TlsFatalAlert(110);
        }
        ProtocolVersion server_version = TlsExtensionsUtils.getSupportedVersionsExtensionServer(extensions);
        if (null == server_version) {
            throw new TlsFatalAlert(109);
        }
        if (!(ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(server_version) && ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), server_version) && TlsUtils.isValidVersionForCipherSuite(cipherSuite, server_version))) {
            throw new TlsFatalAlert(47);
        }
        int selected_group = TlsExtensionsUtils.getKeyShareHelloRetryRequest(extensions);
        if (!TlsUtils.isValidKeyShareSelection(server_version, securityParameters.getClientSupportedGroups(), this.clientAgreements, selected_group)) {
            throw new TlsFatalAlert(47);
        }
        byte[] cookie = TlsExtensionsUtils.getCookieExtension(extensions);
        securityParameters.negotiatedVersion = server_version;
        TlsUtils.negotiatedVersionTLSClient(this.tlsClientContext, this.tlsClient);
        this.resumedSession = false;
        securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
        this.tlsClient.notifySessionID(TlsUtils.EMPTY_BYTES);
        TlsUtils.negotiatedCipherSuite(securityParameters, cipherSuite);
        this.tlsClient.notifySelectedCipherSuite(cipherSuite);
        this.clientAgreements = null;
        this.retryCookie = cookie;
        this.retryGroup = selected_group;
    }

    protected void process13ServerHello(ServerHello serverHello, boolean afterHelloRetryRequest) throws IOException {
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        ProtocolVersion legacy_version = serverHello.getVersion();
        byte[] legacy_session_id_echo = serverHello.getSessionID();
        int cipherSuite = serverHello.getCipherSuite();
        if (!ProtocolVersion.TLSv12.equals(legacy_version) || !Arrays.areEqual((byte[])this.clientHello.getSessionID(), (byte[])legacy_session_id_echo)) {
            throw new TlsFatalAlert(47);
        }
        Hashtable extensions = serverHello.getExtensions();
        if (null == extensions) {
            throw new TlsFatalAlert(47);
        }
        TlsUtils.checkExtensionData13(extensions, 2, (short)47);
        if (afterHelloRetryRequest) {
            ProtocolVersion server_version = TlsExtensionsUtils.getSupportedVersionsExtensionServer(extensions);
            if (null == server_version) {
                throw new TlsFatalAlert(109);
            }
            if (!securityParameters.getNegotiatedVersion().equals(server_version) || securityParameters.getCipherSuite() != cipherSuite) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (!TlsUtils.isValidCipherSuiteSelection(this.clientHello.getCipherSuites(), cipherSuite) || !TlsUtils.isValidVersionForCipherSuite(cipherSuite, securityParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            this.resumedSession = false;
            securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
            this.tlsClient.notifySessionID(TlsUtils.EMPTY_BYTES);
            TlsUtils.negotiatedCipherSuite(securityParameters, cipherSuite);
            this.tlsClient.notifySelectedCipherSuite(cipherSuite);
        }
        this.clientHello = null;
        securityParameters.serverRandom = serverHello.getRandom();
        securityParameters.secureRenegotiation = false;
        securityParameters.extendedMasterSecret = true;
        securityParameters.statusRequestVersion = this.clientExtensions.containsKey(TlsExtensionsUtils.EXT_status_request) ? 1 : 0;
        KeyShareEntry keyShareEntry = TlsExtensionsUtils.getKeyShareServerHello(extensions);
        if (null == keyShareEntry) {
            throw new TlsFatalAlert(47);
        }
        TlsAgreement agreement = (TlsAgreement)this.clientAgreements.get(Integers.valueOf((int)keyShareEntry.getNamedGroup()));
        if (null == agreement) {
            throw new TlsFatalAlert(47);
        }
        this.clientAgreements = null;
        agreement.receivePeerValue(keyShareEntry.getKeyExchange());
        securityParameters.sharedSecret = agreement.calculateSecret();
        TlsUtils.establish13PhaseSecrets(this.tlsClientContext);
        this.invalidateSession();
        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
        this.sessionParameters = null;
        this.sessionMasterSecret = null;
    }

    protected void process13ServerHelloCoda(ServerHello serverHello, boolean afterHelloRetryRequest) throws IOException {
        byte[] serverHelloTranscriptHash = TlsUtils.getCurrentPRFHash(this.handshakeHash);
        TlsUtils.establish13PhaseHandshake(this.tlsClientContext, serverHelloTranscriptHash, this.recordStream);
        if (!afterHelloRetryRequest) {
            this.recordStream.setIgnoreChangeCipherSpec(true);
            this.sendChangeCipherSpecMessage();
        }
        this.recordStream.enablePendingCipherWrite();
        this.recordStream.enablePendingCipherRead(false);
    }

    protected void processServerHello(ServerHello serverHello) throws IOException {
        byte[] renegExtData;
        ProtocolVersion server_version;
        Hashtable serverHelloExtensions = serverHello.getExtensions();
        ProtocolVersion legacy_version = serverHello.getVersion();
        ProtocolVersion supported_version = TlsExtensionsUtils.getSupportedVersionsExtensionServer(serverHelloExtensions);
        if (null == supported_version) {
            server_version = legacy_version;
        } else {
            if (!ProtocolVersion.TLSv12.equals(legacy_version) || !ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(supported_version)) {
                throw new TlsFatalAlert(47);
            }
            server_version = supported_version;
        }
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (!ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), server_version)) {
            throw new TlsFatalAlert(70);
        }
        ProtocolVersion legacy_record_version = server_version.isLaterVersionOf(ProtocolVersion.TLSv12) ? ProtocolVersion.TLSv12 : server_version;
        this.recordStream.setWriteVersion(legacy_record_version);
        securityParameters.negotiatedVersion = server_version;
        TlsUtils.negotiatedVersionTLSClient(this.tlsClientContext, this.tlsClient);
        if (ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(server_version)) {
            this.process13ServerHello(serverHello, false);
            return;
        }
        int[] offeredCipherSuites = this.clientHello.getCipherSuites();
        this.clientHello = null;
        this.retryCookie = null;
        this.retryGroup = -1;
        securityParameters.serverRandom = serverHello.getRandom();
        if (!this.tlsClientContext.getClientVersion().equals(server_version)) {
            TlsUtils.checkDowngradeMarker(server_version, securityParameters.getServerRandom());
        }
        byte[] selectedSessionID = serverHello.getSessionID();
        securityParameters.sessionID = selectedSessionID;
        this.tlsClient.notifySessionID(selectedSessionID);
        this.resumedSession = selectedSessionID.length > 0 && this.tlsSession != null && Arrays.areEqual((byte[])selectedSessionID, (byte[])this.tlsSession.getSessionID());
        int cipherSuite = serverHello.getCipherSuite();
        if (!TlsUtils.isValidCipherSuiteSelection(offeredCipherSuites, cipherSuite) || !TlsUtils.isValidVersionForCipherSuite(cipherSuite, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(47);
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, cipherSuite);
        this.tlsClient.notifySelectedCipherSuite(cipherSuite);
        this.serverExtensions = serverHelloExtensions;
        if (this.serverExtensions != null) {
            Enumeration e = this.serverExtensions.keys();
            while (e.hasMoreElements()) {
                Integer extType = (Integer)e.nextElement();
                if (extType.equals(EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(this.clientExtensions, extType)) {
                    throw new TlsFatalAlert(110);
                }
                if (!this.resumedSession) continue;
            }
        }
        if ((renegExtData = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo)) == null) {
            securityParameters.secureRenegotiation = false;
        } else {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])renegExtData, (byte[])TlsClientProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsClient.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        boolean acceptedExtendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.serverExtensions);
        if (acceptedExtendedMasterSecret ? server_version.isSSL() || !this.resumedSession && !this.tlsClient.shouldUseExtendedMasterSecret() : this.tlsClient.requiresExtendedMasterSecret() || this.resumedSession && !this.tlsClient.allowLegacyResumption()) {
            throw new TlsFatalAlert(40);
        }
        securityParameters.extendedMasterSecret = acceptedExtendedMasterSecret;
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        Hashtable sessionClientExtensions = this.clientExtensions;
        Hashtable sessionServerExtensions = this.serverExtensions;
        if (this.resumedSession) {
            if (securityParameters.getCipherSuite() != this.sessionParameters.getCipherSuite() || 0 != this.sessionParameters.getCompressionAlgorithm() || !server_version.equals(this.sessionParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            sessionClientExtensions = null;
            sessionServerExtensions = this.sessionParameters.readServerExtensions();
        }
        if (sessionServerExtensions != null && !sessionServerExtensions.isEmpty()) {
            boolean serverSentEncryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(sessionServerExtensions);
            if (serverSentEncryptThenMAC && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = serverSentEncryptThenMAC;
            securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(sessionClientExtensions, sessionServerExtensions, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(sessionServerExtensions);
            if (!this.resumedSession) {
                if (TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsExtensionsUtils.EXT_status_request_v2, (short)47)) {
                    securityParameters.statusRequestVersion = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsExtensionsUtils.EXT_status_request, (short)47)) {
                    securityParameters.statusRequestVersion = 1;
                }
                this.expectSessionTicket = TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsProtocol.EXT_SessionTicket, (short)47);
            }
        }
        if (sessionClientExtensions != null) {
            this.tlsClient.processServerExtensions(sessionServerExtensions);
        }
        this.applyMaxFragmentLengthExtension(securityParameters.getMaxFragmentLength());
        if (this.resumedSession) {
            securityParameters.masterSecret = this.sessionMasterSecret;
            this.recordStream.setPendingCipher(TlsUtils.initCipher(this.tlsClientContext));
        } else {
            this.invalidateSession();
            this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
            this.sessionParameters = null;
            this.sessionMasterSecret = null;
        }
    }

    protected void receive13CertificateRequest(ByteArrayInputStream buf, boolean postHandshakeAuth) throws IOException {
        CertificateRequest certificateRequest = CertificateRequest.parse(this.tlsClientContext, buf);
        TlsClientProtocol.assertEmpty(buf);
        if (postHandshakeAuth) {
            throw new TlsFatalAlert(80);
        }
        if (!certificateRequest.hasCertificateRequestContext(TlsUtils.EMPTY_BYTES)) {
            throw new TlsFatalAlert(47);
        }
        this.certificateRequest = certificateRequest;
        TlsUtils.establishServerSigAlgs(this.tlsClientContext.getSecurityParametersHandshake(), certificateRequest);
    }

    protected void receive13EncryptedExtensions(ByteArrayInputStream buf) throws IOException {
        byte[] extBytes = TlsUtils.readOpaque16(buf);
        TlsClientProtocol.assertEmpty(buf);
        this.serverExtensions = TlsClientProtocol.readExtensionsData13(8, extBytes);
        Enumeration e = this.serverExtensions.keys();
        while (e.hasMoreElements()) {
            Integer extType = (Integer)e.nextElement();
            if (null != TlsUtils.getExtensionData(this.clientExtensions, extType)) continue;
            throw new TlsFatalAlert(110);
        }
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        Hashtable sessionClientExtensions = this.clientExtensions;
        Hashtable sessionServerExtensions = this.serverExtensions;
        if (this.resumedSession) {
            if (securityParameters.getCipherSuite() != this.sessionParameters.getCipherSuite() || 0 != this.sessionParameters.getCompressionAlgorithm() || !negotiatedVersion.equals(this.sessionParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            sessionClientExtensions = null;
            sessionServerExtensions = this.sessionParameters.readServerExtensions();
        }
        securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(sessionClientExtensions, sessionServerExtensions, (short)47);
        securityParameters.encryptThenMAC = false;
        securityParameters.truncatedHMac = false;
        securityParameters.statusRequestVersion = this.clientExtensions.containsKey(TlsExtensionsUtils.EXT_status_request) ? 1 : 0;
        this.expectSessionTicket = false;
        if (null != sessionClientExtensions) {
            this.tlsClient.processServerExtensions(this.serverExtensions);
        }
        this.applyMaxFragmentLengthExtension(securityParameters.getMaxFragmentLength());
    }

    protected void receive13NewSessionTicket(ByteArrayInputStream buf) throws IOException {
        if (!this.isApplicationDataReady()) {
            throw new TlsFatalAlert(10);
        }
        TlsUtils.readUint32(buf);
        TlsUtils.readUint32(buf);
        TlsUtils.readOpaque8(buf);
        TlsUtils.readOpaque16(buf);
        TlsUtils.readOpaque16(buf);
        TlsClientProtocol.assertEmpty(buf);
    }

    protected void receive13ServerCertificate(ByteArrayInputStream buf) throws IOException {
        this.authentication = TlsUtils.receive13ServerCertificate(this.tlsClientContext, this.tlsClient, buf);
        this.handleServerCertificate();
    }

    protected void receive13ServerCertificateVerify(ByteArrayInputStream buf) throws IOException {
        Certificate serverCertificate = this.tlsClientContext.getSecurityParametersHandshake().getPeerCertificate();
        if (null == serverCertificate || serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        DigitallySigned certificateVerify = DigitallySigned.parse(this.tlsClientContext, buf);
        TlsClientProtocol.assertEmpty(buf);
        TlsUtils.verify13CertificateVerifyServer(this.tlsClientContext, certificateVerify, this.handshakeHash);
    }

    protected void receive13ServerFinished(ByteArrayInputStream buf) throws IOException {
        this.process13FinishedMessage(buf);
    }

    protected void receiveCertificateRequest(ByteArrayInputStream buf) throws IOException {
        if (null == this.authentication) {
            throw new TlsFatalAlert(40);
        }
        CertificateRequest certificateRequest = CertificateRequest.parse(this.tlsClientContext, buf);
        TlsClientProtocol.assertEmpty(buf);
        this.certificateRequest = TlsUtils.validateCertificateRequest(certificateRequest, this.keyExchange);
    }

    protected void receiveNewSessionTicket(ByteArrayInputStream buf) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(buf);
        TlsClientProtocol.assertEmpty(buf);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected ServerHello receiveServerHelloMessage(ByteArrayInputStream buf) throws IOException {
        return ServerHello.parse(buf);
    }

    protected void send13ClientHelloRetry() throws IOException {
        Hashtable clientHelloExtensions = this.clientHello.getExtensions();
        clientHelloExtensions.remove(TlsExtensionsUtils.EXT_cookie);
        clientHelloExtensions.remove(TlsExtensionsUtils.EXT_early_data);
        clientHelloExtensions.remove(TlsExtensionsUtils.EXT_key_share);
        if (null != this.retryCookie) {
            TlsExtensionsUtils.addCookieExtension(clientHelloExtensions, this.retryCookie);
            this.retryCookie = null;
        }
        if (this.retryGroup < 0) {
            throw new TlsFatalAlert(80);
        }
        this.clientAgreements = TlsUtils.addKeyShareToClientHelloRetry(this.tlsClientContext, clientHelloExtensions, this.retryGroup);
        this.recordStream.setIgnoreChangeCipherSpec(true);
        this.sendChangeCipherSpecMessage();
        this.sendClientHelloMessage();
    }

    protected void sendCertificateVerifyMessage(DigitallySigned certificateVerify) throws IOException {
        HandshakeMessageOutput message = new HandshakeMessageOutput(15);
        certificateVerify.encode(message);
        message.send(this);
    }

    protected void sendClientHello() throws IOException {
        boolean noRenegSCSV;
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        this.tlsClientContext.setClientSupportedVersions(this.tlsClient.getProtocolVersions());
        if (ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), ProtocolVersion.SSLv3)) {
            this.recordStream.setWriteVersion(ProtocolVersion.SSLv3);
        } else {
            this.recordStream.setWriteVersion(ProtocolVersion.TLSv10);
        }
        ProtocolVersion client_version = ProtocolVersion.getLatestTLS(this.tlsClientContext.getClientSupportedVersions());
        if (!ProtocolVersion.isSupportedTLSVersionClient(client_version)) {
            throw new TlsFatalAlert(80);
        }
        this.tlsClientContext.setClientVersion(client_version);
        boolean offeringTLSv13Plus = ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(client_version);
        byte[] legacy_session_id = TlsUtils.getSessionID(this.tlsSession);
        boolean fallback = this.tlsClient.isFallback();
        int[] offeredCipherSuites = this.tlsClient.getCipherSuites();
        if (!(legacy_session_id.length <= 0 || this.sessionParameters == null || Arrays.contains((int[])offeredCipherSuites, (int)this.sessionParameters.getCipherSuite()) && 0 == this.sessionParameters.getCompressionAlgorithm())) {
            legacy_session_id = TlsUtils.EMPTY_BYTES;
        }
        this.clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsClient.getClientExtensions());
        ProtocolVersion legacy_version = client_version;
        if (offeringTLSv13Plus) {
            legacy_version = ProtocolVersion.TLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionClient(this.clientExtensions, this.tlsClientContext.getClientSupportedVersions());
            if (legacy_session_id.length < 1) {
                legacy_session_id = this.tlsClientContext.getNonceGenerator().generateNonce(32);
            }
        }
        this.tlsClientContext.setRSAPreMasterSecretVersion(legacy_version);
        securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(client_version)) {
            TlsUtils.establishClientSigAlgs(securityParameters, this.clientExtensions);
        }
        securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(this.clientExtensions);
        this.clientAgreements = TlsUtils.addEarlyKeySharesToClientHello(this.tlsClientContext, this.tlsClient, this.clientExtensions);
        if (TlsUtils.isExtendedMasterSecretOptionalTLS(this.tlsClientContext.getClientSupportedVersions()) && (this.tlsClient.shouldUseExtendedMasterSecret() || null != this.sessionParameters && this.sessionParameters.isExtendedMasterSecret())) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.clientExtensions);
        } else if (!offeringTLSv13Plus && this.tlsClient.requiresExtendedMasterSecret()) {
            throw new TlsFatalAlert(80);
        }
        boolean useGMTUnixTime = !offeringTLSv13Plus && this.tlsClient.shouldUseGMTUnixTime();
        securityParameters.clientRandom = TlsClientProtocol.createRandomBlock(useGMTUnixTime, this.tlsClientContext);
        boolean noRenegExt = null == TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
        boolean bl = noRenegSCSV = !Arrays.contains((int[])offeredCipherSuites, (int)255);
        if (noRenegExt && noRenegSCSV) {
            offeredCipherSuites = Arrays.append((int[])offeredCipherSuites, (int)255);
        }
        if (fallback && !Arrays.contains((int[])offeredCipherSuites, (int)22016)) {
            offeredCipherSuites = Arrays.append((int[])offeredCipherSuites, (int)22016);
        }
        this.clientHello = new ClientHello(legacy_version, securityParameters.getClientRandom(), legacy_session_id, null, offeredCipherSuites, this.clientExtensions);
        this.sendClientHelloMessage();
    }

    protected void sendClientHelloMessage() throws IOException {
        HandshakeMessageOutput message = new HandshakeMessageOutput(1);
        this.clientHello.encode(this.tlsClientContext, message);
        message.send(this);
    }

    protected void sendClientKeyExchange() throws IOException {
        HandshakeMessageOutput message = new HandshakeMessageOutput(16);
        this.keyExchange.generateClientKeyExchange(message);
        message.send(this);
    }

    protected void skip13CertificateRequest() throws IOException {
        this.certificateRequest = null;
    }

    protected void skip13ServerCertificate() throws IOException {
        this.authentication = null;
        throw new TlsFatalAlert(10);
    }
}

