/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SignatureScheme {
    public static final int rsa_pkcs1_sha1 = 513;
    public static final int ecdsa_sha1 = 515;
    public static final int rsa_pkcs1_sha256 = 1025;
    public static final int rsa_pkcs1_sha384 = 1281;
    public static final int rsa_pkcs1_sha512 = 1537;
    public static final int ecdsa_secp256r1_sha256 = 1027;
    public static final int ecdsa_secp384r1_sha384 = 1283;
    public static final int ecdsa_secp521r1_sha512 = 1539;
    public static final int rsa_pss_rsae_sha256 = 2052;
    public static final int rsa_pss_rsae_sha384 = 2053;
    public static final int rsa_pss_rsae_sha512 = 2054;
    public static final int ed25519 = 2055;
    public static final int ed448 = 2056;
    public static final int rsa_pss_pss_sha256 = 2057;
    public static final int rsa_pss_pss_sha384 = 2058;
    public static final int rsa_pss_pss_sha512 = 2059;

    public static String getName(int signatureScheme) {
        switch (signatureScheme) {
            case 513: {
                return "rsa_pkcs1_sha1";
            }
            case 515: {
                return "ecdsa_sha1";
            }
            case 1025: {
                return "rsa_pkcs1_sha256";
            }
            case 1281: {
                return "rsa_pkcs1_sha384";
            }
            case 1537: {
                return "rsa_pkcs1_sha512";
            }
            case 1027: {
                return "ecdsa_secp256r1_sha256";
            }
            case 1283: {
                return "ecdsa_secp384r1_sha384";
            }
            case 1539: {
                return "ecdsa_secp521r1_sha512";
            }
            case 2052: {
                return "rsa_pss_rsae_sha256";
            }
            case 2053: {
                return "rsa_pss_rsae_sha384";
            }
            case 2054: {
                return "rsa_pss_rsae_sha512";
            }
            case 2055: {
                return "ed25519";
            }
            case 2056: {
                return "ed448";
            }
            case 2057: {
                return "rsa_pss_pss_sha256";
            }
            case 2058: {
                return "rsa_pss_pss_sha384";
            }
            case 2059: {
                return "rsa_pss_pss_sha512";
            }
        }
        return "UNKNOWN";
    }

    public static int getNamedGroup(int signatureScheme) {
        switch (signatureScheme) {
            case 1027: {
                return 23;
            }
            case 1283: {
                return 24;
            }
            case 1539: {
                return 25;
            }
        }
        return -1;
    }

    public static short getRSAPSSHashAlgorithm(int signatureScheme) {
        switch (signatureScheme) {
            case 2052: 
            case 2057: {
                return 4;
            }
            case 2053: 
            case 2058: {
                return 5;
            }
            case 2054: 
            case 2059: {
                return 6;
            }
        }
        return -1;
    }

    public static short getHashAlgorithm(int signatureScheme) {
        return (short)(signatureScheme >>> 8 & 0xFF);
    }

    public static short getSignatureAlgorithm(int signatureScheme) {
        return (short)(signatureScheme & 0xFF);
    }

    public static String getText(int signatureScheme) {
        return SignatureScheme.getName(signatureScheme) + "(0x" + Integer.toHexString(signatureScheme) + ")";
    }

    public static boolean isPrivate(int signatureScheme) {
        return signatureScheme >>> 9 == 254;
    }
}

