/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import org.bouncycastle.tls.SSL3Utils;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CombinedHash
implements TlsHash {
    protected TlsContext context;
    protected TlsCrypto crypto;
    protected TlsHash md5;
    protected TlsHash sha1;

    CombinedHash(TlsContext context, TlsHash md5, TlsHash sha1) {
        this.context = context;
        this.crypto = context.getCrypto();
        this.md5 = md5;
        this.sha1 = sha1;
    }

    public CombinedHash(TlsCrypto crypto) {
        this.crypto = crypto;
        this.md5 = crypto.createHash((short)1);
        this.sha1 = crypto.createHash((short)2);
    }

    public CombinedHash(CombinedHash t) {
        this.context = t.context;
        this.crypto = t.crypto;
        this.md5 = (TlsHash)t.md5.clone();
        this.sha1 = (TlsHash)t.sha1.clone();
    }

    public void update(byte[] input, int inOff, int len) {
        this.md5.update(input, inOff, len);
        this.sha1.update(input, inOff, len);
    }

    public byte[] calculateHash() {
        if (null != this.context && TlsUtils.isSSL(this.context)) {
            SSL3Utils.completeCombinedHash(this.context, this.md5, this.sha1);
        }
        return Arrays.concatenate((byte[])this.md5.calculateHash(), (byte[])this.sha1.calculateHash());
    }

    public Object clone() {
        return new CombinedHash(this);
    }

    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }
}

