/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCApplicationProtocolSelector;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvSSLSessionResumed;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.RecordPreview;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServerProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLEngine
extends SSLEngine
implements BCSSLEngine,
ProvTlsManager {
    private static final Logger LOG = Logger.getLogger(ProvSSLEngine.class.getName());
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = true;
    protected boolean useClientModeSet = false;
    protected boolean closedEarly = false;
    protected boolean initialHandshakeBegun = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected ProvSSLConnection connection = null;
    protected ProvSSLSessionHandshake handshakeSession = null;
    protected SSLException deferredException = null;

    protected ProvSSLEngine(ContextData contextData) {
        this(contextData, null, -1);
    }

    protected ProvSSLEngine(ContextData contextData, String host, int port) {
        super(host, port);
        this.contextData = contextData;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (!this.useClientModeSet) {
            throw new IllegalStateException("Client/Server mode must be set before the handshake can begin");
        }
        if (this.closedEarly) {
            throw new SSLException("Connection is already closed");
        }
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol clientProtocol = new TlsClientProtocol();
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this, this.sslParameters);
                this.protocolPeer = client;
                clientProtocol.connect(client);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else {
                TlsServerProtocol serverProtocol = new TlsServerProtocol();
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this, this.sslParameters);
                this.protocolPeer = server;
                serverProtocol.accept(server);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        catch (SSLException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkClientTrusted((X509Certificate[])chain.clone(), authType, this);
        }
        catch (CertificateException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkServerTrusted((X509Certificate[])chain.clone(), authType, this);
        }
        catch (CertificateException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public BCX509Key chooseClientKey(String[] keyTypes, Principal[] issuers) {
        return this.getContextData().getX509KeyManager().chooseEngineClientKeyBC(keyTypes, JsseUtils.clone(issuers), this);
    }

    @Override
    public BCX509Key chooseServerKey(String keyType, Principal[] issuers) {
        return this.getContextData().getX509KeyManager().chooseEngineServerKeyBC(keyType, JsseUtils.clone(issuers), this);
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (!this.closedEarly) {
            if (null == this.protocol) {
                this.closedEarly = true;
            } else {
                try {
                    this.protocol.closeInput();
                }
                catch (IOException e) {
                    throw new SSLException(e);
                }
            }
        }
    }

    @Override
    public synchronized void closeOutbound() {
        if (!this.closedEarly) {
            if (null == this.protocol) {
                this.closedEarly = true;
            } else {
                try {
                    this.protocol.close();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Failed to close outbound", e);
                }
            }
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return null == this.connection ? null : this.connection.getApplicationProtocol();
    }

    @Override
    public synchronized BCApplicationProtocolSelector<SSLEngine> getBCHandshakeApplicationProtocolSelector() {
        return this.sslParameters.getEngineAPSelector();
    }

    @Override
    public synchronized BCExtendedSSLSession getBCHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public BCExtendedSSLSession getBCSession() {
        return this.getSessionImpl();
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        return null == this.handshakeSession ? null : this.handshakeSession.getApplicationProtocol();
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return null == this.handshakeSession ? null : this.handshakeSession.getExportSSLSession();
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    @Override
    public SSLSession getSession() {
        return this.getSessionImpl().getExportSSLSession();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.contextData.getContext().getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.contextData.getContext().getSupportedProtocols();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.closedEarly || null != this.protocol && this.protocol.isClosed();
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.closedEarly || null != this.protocol && this.protocol.isClosed() && this.protocol.getAvailableOutputBytes() < 1;
    }

    @Override
    public synchronized void setBCHandshakeApplicationProtocolSelector(BCApplicationProtocolSelector<SSLEngine> selector) {
        this.sslParameters.setEngineAPSelector(selector);
    }

    @Override
    public synchronized void setBCSessionToResume(BCExtendedSSLSession session) {
        if (null == session) {
            throw new NullPointerException("'session' cannot be null");
        }
        if (!(session instanceof ProvSSLSession)) {
            throw new IllegalArgumentException("Session-to-resume must be a session returned from 'getBCSession'");
        }
        if (this.initialHandshakeBegun) {
            throw new IllegalArgumentException("Session-to-resume cannot be set after the handshake has begun");
        }
        this.sslParameters.setSessionToResume((ProvSSLSession)session);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public synchronized void setParameters(BCSSLParameters parameters) {
        SSLParametersUtil.setParameters(this.sslParameters, parameters);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sslParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean useClientMode) {
        if (this.initialHandshakeBegun) {
            throw new IllegalArgumentException("Client/Server mode cannot be changed after the handshake has begun");
        }
        if (this.useClientMode != useClientMode) {
            this.contextData.getContext().updateDefaultSSLParameters(this.sslParameters, useClientMode);
            this.useClientMode = useClientMode;
        }
        this.useClientModeSet = true;
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.Status resultStatus = SSLEngineResult.Status.OK;
        int bytesConsumed = 0;
        int bytesProduced = 0;
        if (this.protocol.isClosed()) {
            resultStatus = SSLEngineResult.Status.CLOSED;
        } else {
            try {
                RecordPreview preview = this.getRecordPreview(src);
                if (preview == null || src.remaining() < preview.getRecordSize()) {
                    resultStatus = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                } else if (this.hasInsufficientSpace(dsts, offset, length, preview.getContentLimit())) {
                    resultStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
                } else {
                    byte[] record = new byte[preview.getRecordSize()];
                    src.get(record);
                    this.protocol.offerInput(record);
                    bytesConsumed += record.length;
                    int appDataAvailable = this.protocol.getAvailableInputBytes();
                    for (int dstIndex = 0; dstIndex < length && appDataAvailable > 0; ++dstIndex) {
                        ByteBuffer dst = dsts[offset + dstIndex];
                        int count = Math.min(dst.remaining(), appDataAvailable);
                        if (count <= 0) continue;
                        byte[] appData = new byte[count];
                        int numRead = this.protocol.readInput(appData, 0, count);
                        assert (numRead == count);
                        dst.put(appData);
                        bytesProduced += count;
                        appDataAvailable -= count;
                    }
                    if (appDataAvailable != 0) {
                        throw new TlsFatalAlert(22);
                    }
                }
            }
            catch (IOException e) {
                if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    throw new SSLException(e);
                }
                if (this.deferredException == null) {
                    this.deferredException = new SSLException(e);
                }
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, bytesConsumed, bytesProduced);
            }
        }
        SSLEngineResult.HandshakeStatus resultHandshakeStatus = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (this.protocol.getAvailableOutputBytes() > 0) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        }
        return new SSLEngineResult(resultStatus, resultHandshakeStatus, bytesConsumed, bytesProduced);
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        int outputAvailable;
        if (this.deferredException != null) {
            SSLException e = this.deferredException;
            this.deferredException = null;
            throw e;
        }
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.Status resultStatus = SSLEngineResult.Status.OK;
        int bytesConsumed = 0;
        int bytesProduced = 0;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.protocol.isClosed()) {
                resultStatus = SSLEngineResult.Status.CLOSED;
            } else if (this.protocol.getAvailableOutputBytes() <= 0) {
                try {
                    int srcRemaining = this.getTotalRemaining(srcs, offset, length, this.protocol.getApplicationDataLimit());
                    if (srcRemaining > 0) {
                        RecordPreview preview = this.protocol.previewOutputRecord(srcRemaining);
                        int srcLimit = preview.getContentLimit();
                        int dstLimit = preview.getRecordSize();
                        if (dst.remaining() < dstLimit) {
                            resultStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
                        } else {
                            byte[] applicationData = new byte[srcLimit];
                            for (int srcIndex = 0; srcIndex < length && bytesConsumed < srcLimit; ++srcIndex) {
                                ByteBuffer src = srcs[offset + srcIndex];
                                int count = Math.min(src.remaining(), srcLimit - bytesConsumed);
                                if (count <= 0) continue;
                                src.get(applicationData, bytesConsumed, count);
                                bytesConsumed += count;
                            }
                            this.protocol.writeApplicationData(applicationData, 0, bytesConsumed);
                        }
                    }
                }
                catch (IOException e) {
                    throw new SSLException(e);
                }
            }
        }
        if ((outputAvailable = this.protocol.getAvailableOutputBytes()) > 0) {
            int count = Math.min(dst.remaining(), outputAvailable);
            if (count > 0) {
                byte[] output = new byte[count];
                int numRead = this.protocol.readOutput(output, 0, count);
                assert (numRead == count);
                dst.put(output);
                bytesProduced += count;
                outputAvailable -= count;
            } else {
                resultStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
            }
        }
        SSLEngineResult.HandshakeStatus resultHandshakeStatus = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && outputAvailable <= 0) {
            if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            } else {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        return new SSLEngineResult(resultStatus, resultHandshakeStatus, bytesConsumed, bytesProduced);
    }

    @Override
    public String getPeerHost() {
        return super.getPeerHost();
    }

    @Override
    public String getPeerHostSNI() {
        return super.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return super.getPeerPort();
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        if (null != this.handshakeSession) {
            if (!this.handshakeSession.isValid()) {
                connection.getSession().invalidate();
            }
            this.handshakeSession.getJsseSecurityParameters().clear();
        }
        this.handshakeSession = null;
        this.connection = connection;
    }

    @Override
    public synchronized void notifyHandshakeSession(ProvSSLSessionContext sslSessionContext, SecurityParameters securityParameters, JsseSecurityParameters jsseSecurityParameters, ProvSSLSession resumedSession) {
        String peerHost = this.getPeerHost();
        int peerPort = this.getPeerPort();
        this.handshakeSession = null != resumedSession ? new ProvSSLSessionResumed(sslSessionContext, peerHost, peerPort, securityParameters, jsseSecurityParameters, resumedSession.getTlsSession(), resumedSession.getJsseSessionParameters()) : new ProvSSLSessionHandshake(sslSessionContext, peerHost, peerPort, securityParameters, jsseSecurityParameters);
    }

    @Override
    public synchronized String selectApplicationProtocol(List<String> protocols) {
        return this.sslParameters.getEngineAPSelector().select(this, protocols);
    }

    ProvSSLSession getSessionImpl() {
        return null == this.connection ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
    }

    private RecordPreview getRecordPreview(ByteBuffer src) throws IOException {
        if (src.remaining() < 5) {
            return null;
        }
        byte[] recordHeader = new byte[5];
        int position = src.position();
        src.get(recordHeader);
        src.position(position);
        return this.protocol.previewInputRecord(recordHeader);
    }

    private int getTotalRemaining(ByteBuffer[] bufs, int off, int len, int limit) {
        int result = 0;
        for (int i = 0; i < len; ++i) {
            ByteBuffer buf = bufs[off + i];
            int next = buf.remaining();
            if (next >= limit - result) {
                return limit;
            }
            result += next;
        }
        return result;
    }

    private boolean hasInsufficientSpace(ByteBuffer[] dsts, int off, int len, int amount) {
        return this.getTotalRemaining(dsts, off, len, amount) < amount;
    }
}

