/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvAlgorithmChecker;
import org.bouncycastle.jsse.provider.ProvX509Key;
import org.bouncycastle.jsse.provider.ProvX509TrustManager;
import org.bouncycastle.jsse.provider.TransportData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvX509KeyManagerSimple
extends BCX509ExtendedKeyManager {
    private static final Logger LOG = Logger.getLogger(ProvX509KeyManagerSimple.class.getName());
    private static final int X509V3_VERSION = 3;
    private final JcaJceHelper helper;
    private final Map<String, Credential> credentials;
    private static final Map<String, PublicKeyFilter> FILTERS_CLIENT = ProvX509KeyManagerSimple.createFiltersClient();
    private static final Map<String, PublicKeyFilter> FILTERS_SERVER = ProvX509KeyManagerSimple.createFiltersServer();

    private static void addFilter(Map<String, PublicKeyFilter> map, String string) {
        String string2 = string;
        ProvX509KeyManagerSimple.addFilter(map, 0, string2, null, string);
    }

    private static void addFilter(Map<String, PublicKeyFilter> map, Class<? extends PublicKey> clazz, String ... stringArray) {
        ProvX509KeyManagerSimple.addFilter(map, 0, null, clazz, stringArray);
    }

    private static void addFilter(Map<String, PublicKeyFilter> map, int n, String string, Class<? extends PublicKey> clazz, String ... stringArray) {
        PublicKeyFilter publicKeyFilter = new PublicKeyFilter(string, clazz, n);
        for (String string2 : stringArray) {
            if (null == map.put(string2.toUpperCase(Locale.ENGLISH), publicKeyFilter)) continue;
            throw new IllegalStateException("Duplicate keys in filters");
        }
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> map, String string, int ... nArray) {
        ProvX509KeyManagerSimple.addFilterLegacyServer(map, 0, string, nArray);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> map, int n, String string, int ... nArray) {
        ProvX509KeyManagerSimple.addFilterLegacyServer(map, n, string, null, nArray);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> map, Class<? extends PublicKey> clazz, int ... nArray) {
        ProvX509KeyManagerSimple.addFilterLegacyServer(map, 0, null, clazz, nArray);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> map, int n, String string, Class<? extends PublicKey> clazz, int ... nArray) {
        ProvX509KeyManagerSimple.addFilter(map, n, string, clazz, ProvX509KeyManagerSimple.getKeyTypesLegacyServer(nArray));
    }

    private static Map<String, PublicKeyFilter> createFiltersClient() {
        HashMap<String, PublicKeyFilter> hashMap = new HashMap<String, PublicKeyFilter>();
        ProvX509KeyManagerSimple.addFilter(hashMap, "Ed25519");
        ProvX509KeyManagerSimple.addFilter(hashMap, "Ed448");
        ProvX509KeyManagerSimple.addFilter(hashMap, "RSA");
        ProvX509KeyManagerSimple.addFilter(hashMap, "RSASSA-PSS");
        ProvX509KeyManagerSimple.addFilter(hashMap, DSAPublicKey.class, "DSA");
        ProvX509KeyManagerSimple.addFilter(hashMap, ECPublicKey.class, "EC");
        return Collections.unmodifiableMap(hashMap);
    }

    private static Map<String, PublicKeyFilter> createFiltersServer() {
        HashMap<String, PublicKeyFilter> hashMap = new HashMap<String, PublicKeyFilter>();
        ProvX509KeyManagerSimple.addFilter(hashMap, "Ed25519");
        ProvX509KeyManagerSimple.addFilter(hashMap, "Ed448");
        ProvX509KeyManagerSimple.addFilter(hashMap, "RSA");
        ProvX509KeyManagerSimple.addFilter(hashMap, "RSASSA-PSS");
        ProvX509KeyManagerSimple.addFilterLegacyServer(hashMap, DSAPublicKey.class, 3, 22);
        ProvX509KeyManagerSimple.addFilterLegacyServer(hashMap, ECPublicKey.class, 17);
        ProvX509KeyManagerSimple.addFilterLegacyServer(hashMap, "RSA", 5, 19, 23);
        ProvX509KeyManagerSimple.addFilterLegacyServer(hashMap, 2, "RSA", 1);
        return Collections.unmodifiableMap(hashMap);
    }

    private static String[] getKeyTypesLegacyServer(int ... nArray) {
        int n = nArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = JsseUtils.getKeyTypeLegacyServer(nArray[i]);
        }
        return stringArray;
    }

    private static Map<String, Credential> loadCredentials(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        HashMap<String, Credential> hashMap = new HashMap<String, Credential>(4);
        if (null != keyStore) {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                X509Certificate[] x509CertificateArray;
                PrivateKey privateKey;
                String string = enumeration.nextElement();
                if (!keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class) || null == (privateKey = (PrivateKey)keyStore.getKey(string, cArray)) || (x509CertificateArray = JsseUtils.getX509CertificateChain(keyStore.getCertificateChain(string))) == null || x509CertificateArray.length < 1) continue;
                hashMap.put(string, new Credential(string, privateKey, x509CertificateArray));
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    ProvX509KeyManagerSimple(JcaJceHelper jcaJceHelper, KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.helper = jcaJceHelper;
        this.credentials = ProvX509KeyManagerSimple.loadCredentials(keyStore, cArray);
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(ProvX509KeyManagerSimple.getKeyTypes(stringArray), principalArray, TransportData.from(socket), false);
    }

    @Override
    public BCX509Key chooseClientKeyBC(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManagerSimple.getKeyTypes(stringArray), principalArray, TransportData.from(socket), false);
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(ProvX509KeyManagerSimple.getKeyTypes(stringArray), principalArray, TransportData.from(sSLEngine), false);
    }

    @Override
    public BCX509Key chooseEngineClientKeyBC(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseKeyBC(ProvX509KeyManagerSimple.getKeyTypes(stringArray), principalArray, TransportData.from(sSLEngine), false);
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(ProvX509KeyManagerSimple.getKeyTypes(string), principalArray, TransportData.from(sSLEngine), true);
    }

    @Override
    public BCX509Key chooseEngineServerKeyBC(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseKeyBC(ProvX509KeyManagerSimple.getKeyTypes(string), principalArray, TransportData.from(sSLEngine), true);
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(ProvX509KeyManagerSimple.getKeyTypes(string), principalArray, TransportData.from(socket), true);
    }

    @Override
    public BCX509Key chooseServerKeyBC(String string, Principal[] principalArray, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManagerSimple.getKeyTypes(string), principalArray, TransportData.from(socket), true);
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        Credential credential = this.getCredential(string);
        return null == credential ? null : (X509Certificate[])credential.certificateChain.clone();
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.getAliases(ProvX509KeyManagerSimple.getKeyTypes(string), principalArray, null, false);
    }

    @Override
    public BCX509Key getKeyBC(String string) {
        Credential credential = this.getCredential(string);
        return this.createKeyBC(credential);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        Credential credential = this.getCredential(string);
        return null == credential ? null : credential.privateKey;
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.getAliases(ProvX509KeyManagerSimple.getKeyTypes(string), principalArray, null, true);
    }

    private String chooseAlias(List<String> list, Principal[] principalArray, TransportData transportData, boolean bl) {
        Match match = this.getBestMatch(list, principalArray, transportData, bl);
        if (Match.NOTHING != match) {
            String string = ProvX509KeyManagerSimple.getAlias(match);
            LOG.fine("Found matching key, returning alias: " + string);
            return string;
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key chooseKeyBC(List<String> list, Principal[] principalArray, TransportData transportData, boolean bl) {
        BCX509Key bCX509Key;
        Match match = this.getBestMatch(list, principalArray, transportData, bl);
        if (Match.NOTHING != match && null != (bCX509Key = this.createKeyBC(match.credential))) {
            LOG.fine("Found matching key, from alias: " + ProvX509KeyManagerSimple.getAlias(match));
            return bCX509Key;
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key createKeyBC(Credential credential) {
        return null == credential ? null : new ProvX509Key(credential.privateKey, credential.certificateChain);
    }

    private String[] getAliases(List<String> list, Principal[] principalArray, TransportData transportData, boolean bl) {
        if (!this.credentials.isEmpty() && !list.isEmpty()) {
            Set<Principal> set = ProvX509KeyManagerSimple.getUniquePrincipals(principalArray);
            BCAlgorithmConstraints bCAlgorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date date = new Date();
            String string = ProvX509KeyManagerSimple.getRequestedHostName(transportData, bl);
            List<Match> list2 = null;
            try {
                list2 = this.getAliasesFromCredentials(list, set, bCAlgorithmConstraints, bl, date, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != list2 && !list2.isEmpty()) {
                Collections.sort(list2);
                return ProvX509KeyManagerSimple.getAliases(list2);
            }
        }
        return null;
    }

    private List<Match> getAliasesFromCredentials(List<String> list, Set<Principal> set, BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl, Date date, String string) throws Exception {
        List<Match> list2 = null;
        for (Credential credential : this.credentials.values()) {
            Match match = this.getPotentialMatch(credential, Match.Quality.NONE, list, set, bCAlgorithmConstraints, bl, date, string);
            if (null == match) continue;
            list2 = ProvX509KeyManagerSimple.addToMatches(list2, match);
        }
        return list2;
    }

    private Match getBestMatch(List<String> list, Principal[] principalArray, TransportData transportData, boolean bl) {
        if (!this.credentials.isEmpty() && !list.isEmpty()) {
            Set<Principal> set = ProvX509KeyManagerSimple.getUniquePrincipals(principalArray);
            BCAlgorithmConstraints bCAlgorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date date = new Date();
            String string = ProvX509KeyManagerSimple.getRequestedHostName(transportData, bl);
            try {
                return this.getBestMatchFromCredentials(list, set, bCAlgorithmConstraints, bl, date, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Match.NOTHING;
    }

    private Match getBestMatchFromCredentials(List<String> list, Set<Principal> set, BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl, Date date, String string) throws Exception {
        Match match = Match.NOTHING;
        for (Credential credential : this.credentials.values()) {
            Match match2 = this.getPotentialMatch(credential, match.quality, list, set, bCAlgorithmConstraints, bl, date, string);
            if (null == match2) continue;
            match = match2;
            if (Match.Quality.OK != match.quality) continue;
            break;
        }
        return match;
    }

    private Match getPotentialMatch(Credential credential, Match.Quality quality, List<String> list, Set<Principal> set, BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl, Date date, String string) throws Exception {
        Match.Quality quality2;
        X509Certificate[] x509CertificateArray = credential.certificateChain;
        if (this.isSuitableChain(x509CertificateArray, list, set, bCAlgorithmConstraints, bl) && (quality2 = ProvX509KeyManagerSimple.getCertificateQuality(x509CertificateArray[0], date, string)).compareTo(quality) < 0) {
            return new Match(quality2, credential);
        }
        return null;
    }

    private Credential getCredential(String string) {
        return null == string ? null : this.credentials.get(string);
    }

    private boolean isSuitableChain(X509Certificate[] x509CertificateArray, List<String> list, Set<Principal> set, BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl) {
        if (!(null != x509CertificateArray && x509CertificateArray.length >= 1 && ProvX509KeyManagerSimple.isSuitableChainForTLS(x509CertificateArray) && ProvX509KeyManagerSimple.isSuitableChainForIssuers(x509CertificateArray, set) && ProvX509KeyManagerSimple.isSuitableEECert(x509CertificateArray[0], list, bCAlgorithmConstraints, bl))) {
            return false;
        }
        try {
            Set<X509Certificate> set2 = Collections.emptySet();
            KeyPurposeId keyPurposeId = ProvX509TrustManager.getRequiredExtendedKeyUsage(bl);
            int n = -1;
            ProvAlgorithmChecker.checkChain(this.helper, bCAlgorithmConstraints, set2, x509CertificateArray, keyPurposeId, n);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            return false;
        }
        return true;
    }

    private static List<Match> addToMatches(List<Match> list, Match match) {
        if (null == list) {
            list = new ArrayList<Match>();
        }
        list.add(match);
        return list;
    }

    private static String getAlias(Match match) {
        return match.credential.alias;
    }

    private static String[] getAliases(List<Match> list) {
        int n = list.size();
        int n2 = 0;
        String[] stringArray = new String[n];
        for (Match match : list) {
            stringArray[n2++] = ProvX509KeyManagerSimple.getAlias(match);
        }
        return stringArray;
    }

    private static Match.Quality getCertificateQuality(X509Certificate x509Certificate, Date date, String string) {
        boolean[] blArray;
        try {
            x509Certificate.checkValidity(date);
        }
        catch (CertificateException certificateException) {
            return Match.Quality.EXPIRED;
        }
        if (null != string) {
            try {
                ProvX509TrustManager.checkEndpointID(string, x509Certificate, "HTTPS");
            }
            catch (CertificateException certificateException) {
                return Match.Quality.MISMATCH_SNI;
            }
        }
        if ("RSA".equalsIgnoreCase(JsseUtils.getPublicKeyAlgorithm(x509Certificate.getPublicKey())) && ProvAlgorithmChecker.supportsKeyUsage(blArray = x509Certificate.getKeyUsage(), 0) && ProvAlgorithmChecker.supportsKeyUsage(blArray, 2)) {
            return Match.Quality.RSA_MULTI_USE;
        }
        return Match.Quality.OK;
    }

    private static List<String> getKeyTypes(String ... stringArray) {
        if (null != stringArray && stringArray.length > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (String string : stringArray) {
                if (null == string) continue;
                arrayList.add(string.toUpperCase(Locale.ENGLISH));
            }
            if (!arrayList.isEmpty()) {
                return Collections.unmodifiableList(arrayList);
            }
        }
        return Collections.emptyList();
    }

    private static String getRequestedHostName(TransportData transportData, boolean bl) {
        BCSNIHostName bCSNIHostName;
        BCExtendedSSLSession bCExtendedSSLSession;
        if (null != transportData && bl && null != (bCExtendedSSLSession = transportData.getHandshakeSession()) && null != (bCSNIHostName = JsseUtils.getSNIHostName(bCExtendedSSLSession.getRequestedServerNames()))) {
            return bCSNIHostName.getAsciiName();
        }
        return null;
    }

    private static Set<Principal> getUniquePrincipals(Principal[] principalArray) {
        if (null == principalArray) {
            return null;
        }
        if (principalArray.length > 0) {
            HashSet<Principal> hashSet = new HashSet<Principal>();
            for (int i = 0; i < principalArray.length; ++i) {
                Principal principal = principalArray[i];
                if (null == principal) continue;
                hashSet.add(principal);
            }
            if (!hashSet.isEmpty()) {
                return Collections.unmodifiableSet(hashSet);
            }
        }
        return Collections.emptySet();
    }

    private static boolean isSuitableChainForIssuers(X509Certificate[] x509CertificateArray, Set<Principal> set) {
        if (null == set || set.isEmpty()) {
            return true;
        }
        int n = x509CertificateArray.length;
        while (--n >= 0) {
            if (!set.contains(x509CertificateArray[n].getIssuerX500Principal())) continue;
            return true;
        }
        X509Certificate x509Certificate = x509CertificateArray[0];
        return x509Certificate.getBasicConstraints() >= 0 && set.contains(x509Certificate.getSubjectX500Principal());
    }

    private static boolean isSuitableChainForTLS(X509Certificate[] x509CertificateArray) {
        int n = x509CertificateArray.length;
        for (int i = 0; i < n; ++i) {
            if (3 == x509CertificateArray[i].getVersion()) continue;
            return false;
        }
        return true;
    }

    private static boolean isSuitableEECert(X509Certificate x509Certificate, List<String> list, BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl) {
        Map<String, PublicKeyFilter> map = bl ? FILTERS_SERVER : FILTERS_CLIENT;
        PublicKey publicKey = x509Certificate.getPublicKey();
        boolean[] blArray = x509Certificate.getKeyUsage();
        for (String string : list) {
            PublicKeyFilter publicKeyFilter = map.get(string);
            if (null == publicKeyFilter || !publicKeyFilter.accepts(publicKey, blArray, bCAlgorithmConstraints)) continue;
            return true;
        }
        return false;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Credential {
        private final String alias;
        private final PrivateKey privateKey;
        private final X509Certificate[] certificateChain;

        Credential(String string, PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
            this.alias = string;
            this.privateKey = privateKey;
            this.certificateChain = x509CertificateArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Match
    implements Comparable<Match> {
        static final Match NOTHING = new Match(Quality.NONE, null);
        final Quality quality;
        final Credential credential;

        Match(Quality quality, Credential credential) {
            this.quality = quality;
            this.credential = credential;
        }

        @Override
        public int compareTo(Match match) {
            return this.quality.compareTo(match.quality);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static enum Quality {
            OK,
            RSA_MULTI_USE,
            MISMATCH_SNI,
            EXPIRED,
            NONE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class PublicKeyFilter {
        final String algorithm;
        final Class<? extends PublicKey> clazz;
        final int keyUsageBit;

        PublicKeyFilter(String string, Class<? extends PublicKey> clazz, int n) {
            this.algorithm = string;
            this.clazz = clazz;
            this.keyUsageBit = n;
        }

        boolean accepts(PublicKey publicKey, boolean[] blArray, BCAlgorithmConstraints bCAlgorithmConstraints) {
            return this.appliesTo(publicKey) && ProvAlgorithmChecker.permitsKeyUsage(publicKey, blArray, this.keyUsageBit, bCAlgorithmConstraints);
        }

        private boolean appliesTo(PublicKey publicKey) {
            return null != this.algorithm && this.algorithm.equalsIgnoreCase(JsseUtils.getPublicKeyAlgorithm(publicKey)) || null != this.clazz && this.clazz.isInstance(publicKey);
        }
    }
}

