/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.DummyX509KeyManager;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.NamedGroupInfo;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvSSLSessionResumed;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvTlsServer
extends DefaultTlsServer
implements ProvTlsPeer {
    private static final Logger LOG = Logger.getLogger(ProvTlsServer.class.getName());
    private static final int provEphemeralDHKeySize = PropertyUtils.getIntegerSystemProperty("jdk.tls.ephemeralDHKeySize", 2048, 1024, 8192);
    private static final boolean provServerEnableStatusRequest = false;
    private static final boolean provServerEnableTrustedCAKeys = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.server.enableTrustedCAKeysExtension", false);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected final JsseSecurityParameters jsseSecurityParameters = new JsseSecurityParameters();
    protected ProvSSLSession sslSession = null;
    protected BCSNIServerName matchedSNIServerName = null;
    protected Set<String> keyManagerMissCache = null;
    protected TlsCredentials credentials = null;
    protected boolean handshakeComplete = false;

    ProvTlsServer(ProvTlsManager provTlsManager, ProvSSLParameters provSSLParameters) throws SSLException {
        super(provTlsManager.getContextData().getCrypto());
        this.manager = provTlsManager;
        this.sslParameters = provSSLParameters.copyForConnection();
        if (!provTlsManager.getEnableSessionCreation()) {
            throw new SSLException("Session resumption not implemented yet and session creation is disabled");
        }
    }

    @Override
    protected boolean allowCertificateStatus() {
        return false;
    }

    @Override
    protected boolean allowMultiCertStatus() {
        return false;
    }

    @Override
    protected boolean allowTrustedCAIndication() {
        return null != this.jsseSecurityParameters.trustedIssuers;
    }

    @Override
    protected int getMaximumNegotiableCurveBits() {
        return NamedGroupInfo.getMaximumBitsServerECDH(this.jsseSecurityParameters.namedGroups);
    }

    @Override
    protected int getMaximumNegotiableFiniteFieldBits() {
        int n = NamedGroupInfo.getMaximumBitsServerFFDHE(this.jsseSecurityParameters.namedGroups);
        return n >= provEphemeralDHKeySize ? n : 0;
    }

    @Override
    protected Vector<ProtocolName> getProtocolNames() {
        return JsseUtils.getProtocolNames(this.sslParameters.getApplicationProtocols());
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return this.manager.getContextData().getContext().getActiveCipherSuites(this.getCrypto(), this.sslParameters, this.getProtocolVersions());
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return this.manager.getContextData().getContext().getActiveProtocolVersions(this.sslParameters);
    }

    @Override
    protected boolean preferLocalCipherSuites() {
        return this.sslParameters.getUseCipherSuitesOrder();
    }

    @Override
    protected boolean selectCipherSuite(int n) throws IOException {
        TlsCredentials tlsCredentials = this.selectCredentials(this.jsseSecurityParameters.trustedIssuers, n);
        if (null == tlsCredentials) {
            String string = ProvSSLContextSpi.getCipherSuiteName(n);
            LOG.finer("Server found no credentials for cipher suite: " + string);
            return false;
        }
        boolean bl = super.selectCipherSuite(n);
        if (bl) {
            this.credentials = tlsCredentials;
        }
        return bl;
    }

    @Override
    protected int selectDH(int n) {
        n = Math.max(n, provEphemeralDHKeySize);
        return NamedGroupInfo.selectServerFFDHE(this.jsseSecurityParameters.namedGroups, n);
    }

    @Override
    protected int selectDHDefault(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int selectECDH(int n) {
        return NamedGroupInfo.selectServerECDH(this.jsseSecurityParameters.namedGroups, n);
    }

    @Override
    protected int selectECDHDefault(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ProtocolName selectProtocolName() throws IOException {
        if (null == this.sslParameters.getEngineAPSelector() && null == this.sslParameters.getSocketAPSelector()) {
            return super.selectProtocolName();
        }
        Vector vector = this.clientProtocolNames;
        List<String> list = JsseUtils.getProtocolNames(vector);
        String string = this.manager.selectApplicationProtocol(Collections.unmodifiableList(list));
        if (null == string) {
            throw new TlsFatalAlert(120);
        }
        if (string.length() < 1) {
            return null;
        }
        if (!list.contains(string)) {
            throw new TlsFatalAlert(120);
        }
        return ProtocolName.asUtf8Encoding(string);
    }

    @Override
    protected boolean shouldSelectProtocolNameEarly() {
        return null == this.sslParameters.getEngineAPSelector() && null == this.sslParameters.getSocketAPSelector();
    }

    @Override
    public boolean allowLegacyResumption() {
        return JsseUtils.allowLegacyResumption();
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        return this.credentials;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        if (!this.isClientAuthEnabled()) {
            return null;
        }
        ContextData contextData = this.manager.getContextData();
        ProtocolVersion protocolVersion = this.context.getServerVersion();
        List<SignatureSchemeInfo> list = contextData.getActiveCertsSignatureSchemes(true, this.sslParameters, new ProtocolVersion[]{protocolVersion}, this.jsseSecurityParameters.namedGroups);
        this.jsseSecurityParameters.localSigSchemes = list;
        this.jsseSecurityParameters.localSigSchemesCert = list;
        Vector<SignatureAndHashAlgorithm> vector = SignatureSchemeInfo.getSignatureAndHashAlgorithms(this.jsseSecurityParameters.localSigSchemes);
        Vector<X500Name> vector2 = JsseUtils.getCertificateAuthorities(contextData.getX509TrustManager());
        if (TlsUtils.isTLSv13(protocolVersion)) {
            byte[] byArray = TlsUtils.EMPTY_BYTES;
            Vector<SignatureAndHashAlgorithm> vector3 = null;
            if (this.jsseSecurityParameters.localSigSchemes != this.jsseSecurityParameters.localSigSchemesCert) {
                vector3 = SignatureSchemeInfo.getSignatureAndHashAlgorithms(this.jsseSecurityParameters.localSigSchemesCert);
            }
            return new CertificateRequest(byArray, vector, vector3, vector2);
        }
        short[] sArray = new short[]{64, 1, 2};
        return new CertificateRequest(sArray, vector, vector2);
    }

    @Override
    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    @Override
    public JcaTlsCrypto getCrypto() {
        return this.manager.getContextData().getCrypto();
    }

    @Override
    public int[] getSupportedGroups() throws IOException {
        ProtocolVersion[] protocolVersionArray = new ProtocolVersion[]{this.context.getServerVersion()};
        this.jsseSecurityParameters.namedGroups = this.manager.getContextData().getNamedGroups(this.sslParameters, protocolVersionArray);
        return NamedGroupInfo.getSupportedGroupsLocalServer(this.jsseSecurityParameters.namedGroups);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        ContextData contextData = this.manager.getContextData();
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        Object object = contextData.getServerSessionContext();
        Object object2 = this.manager.getPeerHost();
        int n = this.manager.getPeerPort();
        ProvSSLSessionHandshake provSSLSessionHandshake = null == this.sslSession ? new ProvSSLSessionHandshake((ProvSSLSessionContext)object, (String)object2, n, securityParameters, this.jsseSecurityParameters) : new ProvSSLSessionResumed((ProvSSLSessionContext)object, (String)object2, n, securityParameters, this.jsseSecurityParameters, this.sslSession.getTlsSession(), this.sslSession.getJsseSessionParameters());
        this.manager.notifyHandshakeSession(provSSLSessionHandshake);
        object = securityParameters.getClientSupportedGroups();
        NamedGroupInfo.notifyPeer(this.jsseSecurityParameters.namedGroups, (int[])object);
        object = securityParameters.getClientSigAlgs();
        object2 = securityParameters.getClientSigAlgsCert();
        this.jsseSecurityParameters.peerSigSchemes = contextData.getSignatureSchemes((Vector<SignatureAndHashAlgorithm>)object);
        List<SignatureSchemeInfo> list = this.jsseSecurityParameters.peerSigSchemesCert = object == object2 ? this.jsseSecurityParameters.peerSigSchemes : contextData.getSignatureSchemes((Vector<SignatureAndHashAlgorithm>)object2);
        if (DummyX509KeyManager.INSTANCE == contextData.getX509KeyManager()) {
            throw new TlsFatalAlert(40);
        }
        this.keyManagerMissCache = new HashSet<String>();
        int n2 = super.getSelectedCipherSuite();
        this.keyManagerMissCache = null;
        object2 = this.manager.getContextData().getContext().validateNegotiatedCipherSuite(this.sslParameters, n2);
        LOG.fine("Server selected cipher suite: " + (String)object2);
        return n2;
    }

    @Override
    public Hashtable<Integer, byte[]> getServerExtensions() throws IOException {
        super.getServerExtensions();
        if (null != this.matchedSNIServerName) {
            TlsExtensionsUtils.addServerNameExtensionServer(this.checkServerExtensions());
        }
        Hashtable hashtable = this.serverExtensions;
        return hashtable;
    }

    @Override
    public TlsSession getSessionToResume(byte[] byArray) {
        TlsSession tlsSession;
        ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getServerSessionContext();
        ProvSSLSession provSSLSession = provSSLSessionContext.getSessionImpl(byArray);
        if (null != provSSLSession && null != (tlsSession = provSSLSession.getTlsSession()) && this.isResumable(provSSLSession)) {
            this.sslSession = provSSLSession;
            return tlsSession;
        }
        if (!this.manager.getEnableSessionCreation()) {
            throw new IllegalStateException("No resumable sessions and session creation is disabled");
        }
        return null;
    }

    @Override
    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
        Level level;
        Level level2 = s == 1 ? Level.FINE : (level = s2 == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String string2 = JsseUtils.getAlertLogMessage("Server raised", s, s2);
            if (string != null) {
                string2 = string2 + ": " + string;
            }
            LOG.log(level, string2, throwable);
        }
    }

    @Override
    public void notifyAlertReceived(short s, short s2) {
        Level level;
        super.notifyAlertReceived(s, s2);
        Level level2 = level = s == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String string = JsseUtils.getAlertLogMessage("Server received", s, s2);
            LOG.log(level, string);
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion protocolVersion = super.getServerVersion();
        String string = this.manager.getContextData().getContext().validateNegotiatedProtocol(this.sslParameters, protocolVersion);
        LOG.fine("Server selected protocol version: " + string);
        return protocolVersion;
    }

    @Override
    public void notifyClientCertificate(Certificate certificate) throws IOException {
        if (!this.isClientAuthEnabled()) {
            throw new TlsFatalAlert(80);
        }
        if (null == certificate || certificate.isEmpty()) {
            if (this.sslParameters.getNeedClientAuth()) {
                short s = TlsUtils.isTLSv13(this.context) ? (short)116 : 40;
                throw new TlsFatalAlert(s);
            }
        } else {
            X509Certificate[] x509CertificateArray = JsseUtils.getX509CertificateChain(this.getCrypto(), certificate);
            TlsCertificate tlsCertificate = certificate.getCertificateAt(0);
            short s = tlsCertificate.supportsSignatureAlgorithm((short)7) ? (short)7 : (tlsCertificate.supportsSignatureAlgorithm((short)8) ? (short)8 : tlsCertificate.getLegacySignatureAlgorithm());
            if (s < 0) {
                throw new TlsFatalAlert(43);
            }
            String string = JsseUtils.getAuthTypeClient(s);
            this.manager.checkClientTrusted(x509CertificateArray, string);
        }
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.handshakeComplete = true;
        TlsSession tlsSession = this.context.getSession();
        if (null == this.sslSession || this.sslSession.getTlsSession() != tlsSession) {
            ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getServerSessionContext();
            String string = this.manager.getPeerHost();
            int n = this.manager.getPeerPort();
            JsseSessionParameters jsseSessionParameters = new JsseSessionParameters(this.sslParameters.getEndpointIdentificationAlgorithm());
            this.sslSession = provSSLSessionContext.reportSession(string, n, tlsSession, jsseSessionParameters);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    @Override
    public void notifySecureRenegotiation(boolean bl) throws IOException {
        boolean bl2;
        if (!bl && !(bl2 = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void processClientExtensions(Hashtable hashtable) throws IOException {
        Vector vector;
        super.processClientExtensions(hashtable);
        Vector vector2 = this.context.getSecurityParametersHandshake().getClientServerNames();
        if (null != vector2) {
            vector = this.sslParameters.getSNIMatchers();
            if (null == vector || vector.isEmpty()) {
                LOG.fine("Server ignored SNI (no matchers specified)");
            } else {
                this.matchedSNIServerName = JsseUtils.findMatchingSNIServerName(vector2, vector);
                if (null == this.matchedSNIServerName) {
                    throw new TlsFatalAlert(112);
                }
                LOG.fine("Server accepted SNI: " + this.matchedSNIServerName);
            }
        }
        if (provServerEnableTrustedCAKeys) {
            vector = this.trustedCAKeys;
            this.jsseSecurityParameters.trustedIssuers = JsseUtils.getTrustedIssuers(vector);
        }
    }

    @Override
    public boolean requiresExtendedMasterSecret() {
        return !JsseUtils.allowLegacyMasterSecret();
    }

    @Override
    public boolean shouldUseExtendedMasterSecret() {
        return JsseUtils.useExtendedMasterSecret();
    }

    protected boolean isClientAuthEnabled() {
        return this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth();
    }

    protected boolean isResumable(ProvSSLSession provSSLSession) {
        return false;
    }

    protected TlsCredentials selectCredentials(Principal[] principalArray, int n) throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(n);
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                if (1 == n2 || !TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.context.getServerVersion())) {
                    return this.selectServerCredentialsLegacy(principalArray, n2);
                }
                return this.selectServerCredentials12(principalArray, n2);
            }
            case 0: {
                byte[] byArray = TlsUtils.EMPTY_BYTES;
                return this.selectServerCredentials13(principalArray, byArray);
            }
        }
        return null;
    }

    protected TlsCredentials selectServerCredentials12(Principal[] principalArray, int n) throws IOException {
        BCAlgorithmConstraints bCAlgorithmConstraints = this.sslParameters.getAlgorithmConstraints();
        boolean bl = TlsUtils.isTLSv13(this.context);
        boolean bl2 = !bl;
        short s = TlsUtils.getLegacySignatureAlgorithmServer(n);
        for (SignatureSchemeInfo signatureSchemeInfo : this.jsseSecurityParameters.peerSigSchemes) {
            short s2;
            String string;
            if (!TlsUtils.isValidSignatureSchemeForServerKeyExchange(signatureSchemeInfo.getSignatureScheme(), n) || this.keyManagerMissCache.contains(string = s == (s2 = signatureSchemeInfo.getSignatureAlgorithm()) ? JsseUtils.getKeyTypeLegacyServer(n) : JsseUtils.getKeyType(signatureSchemeInfo)) || !signatureSchemeInfo.isActive(bCAlgorithmConstraints, bl2, bl, this.jsseSecurityParameters.namedGroups)) continue;
            BCX509Key bCX509Key = this.manager.chooseServerKey(string, principalArray);
            if (null == bCX509Key || !JsseUtils.isUsableKeyForServer(s2, bCX509Key.getPrivateKey())) {
                this.keyManagerMissCache.add(string);
                continue;
            }
            return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), bCX509Key, signatureSchemeInfo.getSignatureAndHashAlgorithm());
        }
        return null;
    }

    protected TlsCredentials selectServerCredentials13(Principal[] principalArray, byte[] byArray) throws IOException {
        BCAlgorithmConstraints bCAlgorithmConstraints = this.sslParameters.getAlgorithmConstraints();
        for (SignatureSchemeInfo signatureSchemeInfo : this.jsseSecurityParameters.peerSigSchemes) {
            String string = JsseUtils.getKeyType(signatureSchemeInfo);
            if (this.keyManagerMissCache.contains(string) || !signatureSchemeInfo.isActive(bCAlgorithmConstraints, false, true, this.jsseSecurityParameters.namedGroups)) continue;
            BCX509Key bCX509Key = this.manager.chooseServerKey(string, principalArray);
            if (null == bCX509Key || !JsseUtils.isUsableKeyForServer(signatureSchemeInfo.getSignatureAlgorithm(), bCX509Key.getPrivateKey())) {
                this.keyManagerMissCache.add(string);
                continue;
            }
            return JsseUtils.createCredentialedSigner13(this.context, this.getCrypto(), bCX509Key, signatureSchemeInfo.getSignatureAndHashAlgorithm(), byArray);
        }
        return null;
    }

    protected TlsCredentials selectServerCredentialsLegacy(Principal[] principalArray, int n) throws IOException {
        String string = JsseUtils.getKeyTypeLegacyServer(n);
        if (this.keyManagerMissCache.contains(string)) {
            return null;
        }
        BCX509Key bCX509Key = this.manager.chooseServerKey(string, principalArray);
        if (null == bCX509Key || !JsseUtils.isUsableKeyForServerLegacy(n, bCX509Key.getPrivateKey())) {
            this.keyManagerMissCache.add(string);
            return null;
        }
        if (1 == n) {
            return JsseUtils.createCredentialedDecryptor(this.getCrypto(), bCX509Key);
        }
        return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), bCX509Key, null);
    }
}

