/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.math.ec.rfc7748.X25519;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import org.bouncycastle.util.Arrays;

public class BcX25519
implements TlsAgreement {
    protected final BcTlsCrypto crypto;
    protected final byte[] privateKey = new byte[32];
    protected final byte[] peerPublicKey = new byte[32];

    public BcX25519(BcTlsCrypto crypto) {
        this.crypto = crypto;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        X25519.generatePrivateKey((SecureRandom)this.crypto.getSecureRandom(), (byte[])this.privateKey);
        byte[] publicKey = new byte[32];
        X25519.generatePublicKey((byte[])this.privateKey, (int)0, (byte[])publicKey, (int)0);
        return publicKey;
    }

    @Override
    public void receivePeerValue(byte[] peerValue) throws IOException {
        if (peerValue == null || peerValue.length != 32) {
            throw new TlsFatalAlert(47);
        }
        System.arraycopy(peerValue, 0, this.peerPublicKey, 0, 32);
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        try {
            byte[] secret = new byte[32];
            if (!X25519.calculateAgreement((byte[])this.privateKey, (int)0, (byte[])this.peerPublicKey, (int)0, (byte[])secret, (int)0)) {
                throw new TlsFatalAlert(40);
            }
            BcTlsSecret bcTlsSecret = this.crypto.adoptLocalSecret(secret);
            return bcTlsSecret;
        }
        finally {
            Arrays.fill((byte[])this.privateKey, (byte)0);
            Arrays.fill((byte[])this.peerPublicKey, (byte)0);
        }
    }
}

