/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDH;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import org.bouncycastle.util.BigIntegers;

public class BcTlsECDomain
implements TlsECDomain {
    protected final BcTlsCrypto crypto;
    protected final ECDomainParameters domainParameters;

    public static BcTlsSecret calculateECDHAgreement(BcTlsCrypto crypto, ECPrivateKeyParameters privateKey, ECPublicKeyParameters publicKey) {
        ECDHBasicAgreement basicAgreement = new ECDHBasicAgreement();
        basicAgreement.init((CipherParameters)privateKey);
        BigInteger agreementValue = basicAgreement.calculateAgreement((CipherParameters)publicKey);
        byte[] secret = BigIntegers.asUnsignedByteArray((int)basicAgreement.getFieldSize(), (BigInteger)agreementValue);
        return crypto.adoptLocalSecret(secret);
    }

    public static ECDomainParameters getDomainParameters(TlsECConfig ecConfig) {
        ECDomainParameters parameters = BcTlsECDomain.getDomainParameters(ecConfig.getNamedGroup());
        if (parameters == null) {
            throw new IllegalArgumentException("No EC configuration provided");
        }
        return parameters;
    }

    public static ECDomainParameters getDomainParameters(int namedGroup) {
        if (!NamedGroup.refersToASpecificCurve(namedGroup)) {
            return null;
        }
        String curveName = NamedGroup.getCurveName(namedGroup);
        X9ECParameters ecP = CustomNamedCurves.getByName((String)curveName);
        if (ecP == null && (ecP = ECNamedCurveTable.getByName((String)curveName)) == null) {
            return null;
        }
        return new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public BcTlsECDomain(BcTlsCrypto crypto, TlsECConfig ecConfig) {
        this.crypto = crypto;
        this.domainParameters = BcTlsECDomain.getDomainParameters(ecConfig);
    }

    public BcTlsSecret calculateECDHAgreement(ECPrivateKeyParameters privateKey, ECPublicKeyParameters publicKey) {
        return BcTlsECDomain.calculateECDHAgreement(this.crypto, privateKey, publicKey);
    }

    @Override
    public TlsAgreement createECDH() {
        return new BcTlsECDH(this);
    }

    public ECPoint decodePoint(byte[] encoding) {
        return this.domainParameters.getCurve().decodePoint(encoding);
    }

    public ECPublicKeyParameters decodePublicKey(byte[] encoding) throws IOException {
        try {
            ECPoint point = this.decodePoint(encoding);
            return new ECPublicKeyParameters(point, this.domainParameters);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    public byte[] encodePoint(ECPoint point) {
        return point.getEncoded(false);
    }

    public byte[] encodePublicKey(ECPublicKeyParameters publicKey) {
        return this.encodePoint(publicKey.getQ());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(this.domainParameters, this.crypto.getSecureRandom()));
        return keyPairGenerator.generateKeyPair();
    }
}

