/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import org.bouncycastle.jcajce.spec.KEMExtractSpec;
import org.bouncycastle.jcajce.spec.KEMGenerateSpec;
import org.bouncycastle.jcajce.spec.MLKEMParameterSpec;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsKemConfig;
import org.bouncycastle.tls.crypto.TlsKemDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsMLKem;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.KemUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceTlsMLKemDomain
implements TlsKemDomain {
    protected final JcaTlsCrypto crypto;
    protected final String kemName;
    protected final boolean isServer;

    public JceTlsMLKemDomain(JcaTlsCrypto crypto, TlsKemConfig kemConfig) {
        this.crypto = crypto;
        this.kemName = NamedGroup.getKemName(kemConfig.getNamedGroup());
        this.isServer = kemConfig.isServer();
    }

    public JceTlsSecret adoptLocalSecret(byte[] secret) {
        return this.crypto.adoptLocalSecret(secret);
    }

    @Override
    public TlsAgreement createKem() {
        return new JceTlsMLKem(this);
    }

    public JceTlsSecret decapsulate(PrivateKey privateKey, byte[] ciphertext) {
        try {
            KeyGenerator keyGenerator = this.crypto.getHelper().createKeyGenerator(this.kemName);
            keyGenerator.init((AlgorithmParameterSpec)new KEMExtractSpec.Builder(privateKey, ciphertext, "DEF", 256).withNoKdf().build());
            SecretKeyWithEncapsulation secEnc = (SecretKeyWithEncapsulation)keyGenerator.generateKey();
            return this.adoptLocalSecret(secEnc.getEncoded());
        }
        catch (Exception e) {
            throw Exceptions.illegalArgumentException("invalid key: " + e.getMessage(), e);
        }
    }

    public PublicKey decodePublicKey(byte[] encoding) throws IOException {
        return KemUtil.decodePublicKey(this.crypto, this.kemName, encoding);
    }

    public SecretKeyWithEncapsulation encapsulate(PublicKey publicKey) {
        try {
            KeyGenerator keyGenerator = this.crypto.getHelper().createKeyGenerator(this.kemName);
            keyGenerator.init((AlgorithmParameterSpec)new KEMGenerateSpec.Builder(publicKey, "DEF", 256).withNoKdf().build());
            return (SecretKeyWithEncapsulation)keyGenerator.generateKey();
        }
        catch (Exception e) {
            throw Exceptions.illegalArgumentException("invalid key: " + e.getMessage(), e);
        }
    }

    public byte[] encodePublicKey(PublicKey publicKey) throws IOException {
        return KemUtil.encodePublicKey(publicKey);
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("ML-KEM");
            keyPairGenerator.initialize((AlgorithmParameterSpec)MLKEMParameterSpec.fromName((String)this.kemName), this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to create key pair: " + e.getMessage(), e);
        }
    }

    public boolean isServer() {
        return this.isServer;
    }
}

