/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsEncryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;

final class BcTlsRSAEncryptor
implements TlsEncryptor {
    private final BcTlsCrypto crypto;
    private final RSAKeyParameters pubKeyRSA;

    private static RSAKeyParameters checkPublicKey(RSAKeyParameters pubKeyRSA) {
        if (null == pubKeyRSA || pubKeyRSA.isPrivate()) {
            throw new IllegalArgumentException("No public RSA key provided");
        }
        return pubKeyRSA;
    }

    BcTlsRSAEncryptor(BcTlsCrypto crypto, RSAKeyParameters pubKeyRSA) {
        this.crypto = crypto;
        this.pubKeyRSA = BcTlsRSAEncryptor.checkPublicKey(pubKeyRSA);
    }

    @Override
    public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
        try {
            PKCS1Encoding encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
            encoding.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)this.pubKeyRSA, this.crypto.getSecureRandom()));
            return encoding.processBlock(input, inOff, length);
        }
        catch (InvalidCipherTextException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

