/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.DummyX509KeyManager;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.NamedGroupInfo;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvDHGroupVerifier;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.CertificateStatusRequestItemV2;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.OCSPStatusRequest;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.TrustedAuthority;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.IPAddress;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvTlsClient
extends DefaultTlsClient
implements ProvTlsPeer {
    private static final Logger LOG = Logger.getLogger(ProvTlsClient.class.getName());
    private static final boolean provClientEnableCA = PropertyUtils.getBooleanSystemProperty("jdk.tls.client.enableCAExtension", false);
    private static final boolean provClientEnableSessionResumption = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.enableSessionResumption", true);
    private static final boolean provClientEnableStatusRequest = PropertyUtils.getBooleanSystemProperty("jdk.tls.client.enableStatusRequestExtension", true);
    private static final boolean provClientEnableTrustedCAKeys = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.enableTrustedCAKeysExtension", false);
    private static final boolean provClientOmitSigAlgsCert = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.omitSigAlgsCertExtension", true);
    private static final boolean provEnableSNIExtension = PropertyUtils.getBooleanSystemProperty("jsse.enableSNIExtension", true);
    protected final String clientID;
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected final JsseSecurityParameters jsseSecurityParameters = new JsseSecurityParameters();
    protected ProvSSLSession sslSession = null;
    protected boolean handshakeComplete = false;

    ProvTlsClient(ProvTlsManager manager, ProvSSLParameters sslParameters) {
        super(manager.getContextData().getCrypto());
        this.clientID = JsseUtils.getPeerID("client", manager);
        this.manager = manager;
        this.sslParameters = sslParameters.copyForConnection();
    }

    @Override
    public String getID() {
        return this.clientID;
    }

    @Override
    public ProvSSLSession getSession() {
        return this.sslSession;
    }

    @Override
    public TlsContext getTlsContext() {
        return this.context;
    }

    @Override
    protected Vector<X500Name> getCertificateAuthorities() {
        if (provClientEnableCA) {
            return JsseUtils.getCertificateAuthorities(this.manager.getContextData().getX509TrustManager());
        }
        return null;
    }

    @Override
    protected CertificateStatusRequest getCertificateStatusRequest() {
        if (!provClientEnableStatusRequest) {
            return null;
        }
        OCSPStatusRequest ocspStatusRequest = new OCSPStatusRequest(null, null);
        return new CertificateStatusRequest(1, ocspStatusRequest);
    }

    @Override
    protected Vector<CertificateStatusRequestItemV2> getMultiCertStatusRequest() {
        if (!provClientEnableStatusRequest) {
            return null;
        }
        OCSPStatusRequest ocspStatusRequest = new OCSPStatusRequest(null, null);
        Vector<CertificateStatusRequestItemV2> result = new Vector<CertificateStatusRequestItemV2>(2);
        result.add(new CertificateStatusRequestItemV2(2, ocspStatusRequest));
        result.add(new CertificateStatusRequestItemV2(1, ocspStatusRequest));
        return result;
    }

    @Override
    protected Vector<ProtocolName> getProtocolNames() {
        return JsseUtils.getProtocolNames(this.sslParameters.getApplicationProtocols());
    }

    @Override
    protected Vector<Integer> getSupportedGroups(Vector namedGroupRolesRaw) {
        return NamedGroupInfo.getSupportedGroupsLocalClient(this.jsseSecurityParameters.namedGroups);
    }

    @Override
    protected Vector<ServerName> getSNIServerNames() {
        if (provEnableSNIExtension) {
            String peerHostSNI;
            List<BCSNIServerName> sniServerNames = this.sslParameters.getServerNames();
            if (null == sniServerNames && null != (peerHostSNI = JsseUtils.stripTrailingDot(this.manager.getPeerHostSNI())) && peerHostSNI.indexOf(46) > 0 && !IPAddress.isValid((String)peerHostSNI)) {
                try {
                    sniServerNames = Collections.singletonList(new BCSNIHostName(peerHostSNI));
                }
                catch (RuntimeException e) {
                    LOG.fine(this.clientID + ": Failed to add peer host as default SNI host_name: " + peerHostSNI);
                }
            }
            if (null != sniServerNames && !sniServerNames.isEmpty()) {
                Vector<ServerName> serverNames = new Vector<ServerName>(sniServerNames.size());
                for (BCSNIServerName sniServerName : sniServerNames) {
                    serverNames.add(new ServerName((short)sniServerName.getType(), sniServerName.getEncoded()));
                }
                return serverNames;
            }
        }
        return null;
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return this.manager.getContextData().getActiveCipherSuites(this.getCrypto(), this.sslParameters, this.getProtocolVersions());
    }

    @Override
    protected Vector<SignatureAndHashAlgorithm> getSupportedSignatureAlgorithms() {
        return this.jsseSecurityParameters.signatureSchemes.getLocalSignatureAndHashAlgorithms();
    }

    @Override
    protected Vector<SignatureAndHashAlgorithm> getSupportedSignatureAlgorithmsCert() {
        Vector<SignatureAndHashAlgorithm> result = this.jsseSecurityParameters.signatureSchemes.getLocalSignatureAndHashAlgorithmsCert();
        if (result == null && !provClientOmitSigAlgsCert) {
            result = this.jsseSecurityParameters.signatureSchemes.getLocalSignatureAndHashAlgorithms();
        }
        return result;
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return this.manager.getContextData().getActiveProtocolVersions(this.sslParameters);
    }

    @Override
    protected Vector<TrustedAuthority> getTrustedCAIndication() {
        Vector<X500Name> certificateAuthorities;
        if (provClientEnableTrustedCAKeys && null != (certificateAuthorities = JsseUtils.getCertificateAuthorities(this.manager.getContextData().getX509TrustManager()))) {
            Vector<TrustedAuthority> trustedCAKeys = new Vector<TrustedAuthority>(certificateAuthorities.size());
            for (X500Name certificateAuthority : certificateAuthorities) {
                trustedCAKeys.add(new TrustedAuthority(2, certificateAuthority));
            }
            return trustedCAKeys;
        }
        return null;
    }

    @Override
    public boolean allowLegacyResumption() {
        return JsseUtils.allowLegacyResumption();
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsDHGroupVerifier getDHGroupVerifier() {
        return new ProvDHGroupVerifier();
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            @Override
            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                ContextData contextData = ProvTlsClient.this.manager.getContextData();
                SecurityParameters securityParameters = ProvTlsClient.this.context.getSecurityParametersHandshake();
                ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
                boolean isTLSv13 = TlsUtils.isTLSv13(negotiatedVersion);
                Vector serverSigAlgs = securityParameters.getServerSigAlgs();
                Vector serverSigAlgsCert = securityParameters.getServerSigAlgsCert();
                List<SignatureSchemeInfo> peerSigSchemes = contextData.getSignatureSchemes(serverSigAlgs);
                List<SignatureSchemeInfo> peerSigSchemesCert = null;
                if (serverSigAlgsCert != serverSigAlgs) {
                    peerSigSchemesCert = contextData.getSignatureSchemes(serverSigAlgsCert);
                }
                ProvTlsClient.this.jsseSecurityParameters.signatureSchemes.notifyPeerData(peerSigSchemes, peerSigSchemesCert);
                if (LOG.isLoggable(Level.FINEST)) {
                    String title = ProvTlsClient.this.clientID + " peer signature_algorithms";
                    LOG.finest(JsseUtils.getSignatureAlgorithmsReport(title, peerSigSchemes));
                    if (peerSigSchemesCert != null) {
                        title = ProvTlsClient.this.clientID + " peer signature_algorithms_cert";
                        LOG.finest(JsseUtils.getSignatureAlgorithmsReport(title, peerSigSchemesCert));
                    }
                }
                if (DummyX509KeyManager.INSTANCE == contextData.getX509KeyManager()) {
                    return null;
                }
                Principal[] issuers = JsseUtils.toX500Principals(certificateRequest.getCertificateAuthorities());
                byte[] certificateRequestContext = certificateRequest.getCertificateRequestContext();
                if (isTLSv13 != (null != certificateRequestContext)) {
                    throw new TlsFatalAlert(80);
                }
                short[] certificateTypes = certificateRequest.getCertificateTypes();
                if (isTLSv13 != (null == certificateTypes)) {
                    throw new TlsFatalAlert(80);
                }
                if (isTLSv13) {
                    return ProvTlsClient.this.selectClientCredentials13(issuers, certificateRequestContext);
                }
                if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(negotiatedVersion)) {
                    return ProvTlsClient.this.selectClientCredentials12(issuers, certificateTypes);
                }
                return ProvTlsClient.this.selectClientCredentialsLegacy(issuers, certificateTypes);
            }

            @Override
            public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
                if (null == serverCertificate || null == serverCertificate.getCertificate() || serverCertificate.getCertificate().isEmpty()) {
                    throw new TlsFatalAlert(40);
                }
                X509Certificate[] chain = JsseUtils.getX509CertificateChain(ProvTlsClient.this.getCrypto(), serverCertificate.getCertificate());
                String authType = JsseUtils.getAuthTypeServer(ProvTlsClient.this.context.getSecurityParametersHandshake().getKeyExchangeAlgorithm());
                ProvTlsClient.this.jsseSecurityParameters.statusResponses = JsseUtils.getStatusResponses(serverCertificate.getCertificateStatus());
                ProvTlsClient.this.manager.checkServerTrusted(chain, authType);
            }
        };
    }

    @Override
    public JcaTlsCrypto getCrypto() {
        return this.manager.getContextData().getCrypto();
    }

    @Override
    public int getMaxCertificateChainLength() {
        return JsseUtils.getMaxCertificateChainLength();
    }

    @Override
    public int getMaxHandshakeMessageSize() {
        return JsseUtils.getMaxHandshakeMessageSize();
    }

    @Override
    public TlsSession getSessionToResume() {
        if (provClientEnableSessionResumption) {
            TlsSession sessionToResume;
            SessionParameters resumableSessionParameters;
            ProvSSLSession availableSSLSession = this.sslParameters.getSessionToResume();
            if (null == availableSSLSession) {
                ProvSSLSessionContext sslSessionContext = this.manager.getContextData().getClientSessionContext();
                availableSSLSession = sslSessionContext.getSessionImpl(this.manager.getPeerHost(), this.manager.getPeerPort());
            }
            if (null != availableSSLSession && null != (resumableSessionParameters = this.getResumableSessionParameters(availableSSLSession, sessionToResume = availableSSLSession.getTlsSession()))) {
                this.sslSession = availableSSLSession;
                if (!this.manager.getEnableSessionCreation()) {
                    this.cipherSuites = new int[]{resumableSessionParameters.getCipherSuite()};
                }
                return sessionToResume;
            }
        }
        JsseUtils.checkSessionCreationEnabled(this.manager);
        return null;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        Level level;
        super.notifyAlertRaised(alertLevel, alertDescription, message, cause);
        Level level2 = alertLevel == 1 ? Level.FINE : (level = alertDescription == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertRaisedLogMessage(this.clientID, alertLevel, alertDescription);
            if (message != null) {
                msg = msg + ": " + message;
            }
            LOG.log(level, msg, cause);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Level level;
        super.notifyAlertReceived(alertLevel, alertDescription);
        Level level2 = level = alertLevel == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertReceivedLogMessage(this.clientID, alertLevel, alertDescription);
            LOG.log(level, msg);
        }
    }

    @Override
    public void notifyConnectionClosed() {
        super.notifyConnectionClosed();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.clientID + " disconnected from " + JsseUtils.getPeerReport(this.manager));
        }
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.clientID + " opening connection to " + JsseUtils.getPeerReport(this.manager));
        }
        ContextData contextData = this.manager.getContextData();
        ProtocolVersion[] activeProtocolVersions = this.getProtocolVersions();
        this.jsseSecurityParameters.namedGroups = contextData.getNamedGroupsClient(this.sslParameters, activeProtocolVersions);
        this.jsseSecurityParameters.signatureSchemes = contextData.getSignatureSchemesClient(this.sslParameters, activeProtocolVersions, this.jsseSecurityParameters.namedGroups);
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.handshakeComplete = true;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.clientID + " established connection with " + JsseUtils.getPeerReport(this.manager));
        }
        TlsSession connectionTlsSession = this.context.getSession();
        if (null == this.sslSession || this.sslSession.getTlsSession() != connectionTlsSession) {
            ProvSSLSessionContext sslSessionContext = this.manager.getContextData().getClientSessionContext();
            String peerHost = this.manager.getPeerHost();
            int peerPort = this.manager.getPeerPort();
            JsseSessionParameters jsseSessionParameters = new JsseSessionParameters(this.sslParameters.getEndpointIdentificationAlgorithm(), null);
            boolean addToCache = provClientEnableSessionResumption && !TlsUtils.isTLSv13(this.context);
            this.sslSession = sslSessionContext.reportSession(peerHost, peerPort, connectionTlsSession, jsseSessionParameters, addToCache);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this));
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        boolean allowLegacyHelloMessages;
        if (!secureRenegotiation && !(allowLegacyHelloMessages = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        ContextData contextData = this.manager.getContextData();
        String selectedCipherSuiteName = contextData.validateNegotiatedCipherSuite(this.sslParameters, selectedCipherSuite);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.clientID + " notified of selected cipher suite: " + selectedCipherSuiteName);
        }
        super.notifySelectedCipherSuite(selectedCipherSuite);
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        String serverVersionName = this.manager.getContextData().validateNegotiatedProtocol(this.sslParameters, serverVersion);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.clientID + " notified of selected protocol version: " + serverVersionName);
        }
        super.notifyServerVersion(serverVersion);
    }

    @Override
    public void notifySessionToResume(TlsSession session) {
        if (null == session) {
            JsseUtils.checkSessionCreationEnabled(this.manager);
        }
        super.notifySessionToResume(session);
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
        boolean isResumed;
        boolean bl = isResumed = !TlsUtils.isNullOrEmpty(sessionID) && null != this.sslSession && Arrays.areEqual((byte[])sessionID, (byte[])this.sslSession.getId());
        if (isResumed) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.clientID + ": Server resumed session: " + Hex.toHexString((byte[])sessionID));
            }
        } else {
            this.sslSession = null;
            if (LOG.isLoggable(Level.FINE)) {
                if (TlsUtils.isNullOrEmpty(sessionID)) {
                    LOG.fine(this.clientID + ": Server did not specify a session ID");
                } else {
                    LOG.fine(this.clientID + ": Server specified new session: " + Hex.toHexString((byte[])sessionID));
                }
            }
            JsseUtils.checkSessionCreationEnabled(this.manager);
        }
        this.manager.notifyHandshakeSession(this.manager.getContextData().getClientSessionContext(), this.context.getSecurityParametersHandshake(), this.jsseSecurityParameters, this.sslSession);
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        super.processServerExtensions(serverExtensions);
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        if (null != securityParameters.getClientServerNames()) {
            boolean sniAccepted = TlsExtensionsUtils.hasServerNameExtensionServer(serverExtensions);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this.clientID + ": Server accepted SNI?: " + sniAccepted);
            }
        }
    }

    @Override
    public boolean requiresCloseNotify() {
        return JsseUtils.requireCloseNotify();
    }

    @Override
    public boolean requiresExtendedMasterSecret() {
        return !JsseUtils.allowLegacyMasterSecret();
    }

    @Override
    public boolean shouldUseCompatibilityMode() {
        return JsseUtils.useCompatibilityMode();
    }

    @Override
    public boolean shouldUseExtendedMasterSecret() {
        return JsseUtils.useExtendedMasterSecret();
    }

    protected String[] getKeyTypesLegacy(short[] certificateTypes) throws IOException {
        String[] keyTypes = new String[certificateTypes.length];
        for (int i = 0; i < certificateTypes.length; ++i) {
            keyTypes[i] = JsseUtils.getKeyTypeLegacyClient(certificateTypes[i]);
        }
        return keyTypes;
    }

    protected SessionParameters getResumableSessionParameters(ProvSSLSession provSSLSession, TlsSession tlsSession) {
        JsseSessionParameters jsseSessionParameters;
        String sessionEndpointID;
        if (null == tlsSession || !tlsSession.isResumable()) {
            return null;
        }
        SessionParameters sessionParameters = tlsSession.exportSessionParameters();
        if (null == sessionParameters || !Arrays.contains((int[])this.getCipherSuites(), (int)sessionParameters.getCipherSuite())) {
            return null;
        }
        ProtocolVersion sessionVersion = sessionParameters.getNegotiatedVersion();
        if (!ProtocolVersion.contains(this.getProtocolVersions(), sessionVersion)) {
            return null;
        }
        if (TlsUtils.isTLSv13(sessionVersion)) {
            return null;
        }
        String connectionEndpointID = this.sslParameters.getEndpointIdentificationAlgorithm();
        if (null != connectionEndpointID && !connectionEndpointID.equalsIgnoreCase(sessionEndpointID = (jsseSessionParameters = provSSLSession.getJsseSessionParameters()).getEndpointIDAlgorithm())) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this.clientID + ": Session not resumable - endpoint ID algorithm mismatch; connection: " + connectionEndpointID + ", session: " + sessionEndpointID);
            }
            return null;
        }
        return sessionParameters;
    }

    protected TlsCredentials selectClientCredentials12(Principal[] issuers, short[] certificateTypes) throws IOException {
        SignatureSchemeInfo.PerConnection signatureSchemes = this.jsseSecurityParameters.signatureSchemes;
        LinkedHashMap<String, SignatureSchemeInfo> keyTypeMap = new LinkedHashMap<String, SignatureSchemeInfo>();
        for (SignatureSchemeInfo signatureSchemeInfo : signatureSchemes.getPeerSigSchemes()) {
            short signatureAlgorithm;
            short certificateType;
            String keyType = signatureSchemeInfo.getKeyType();
            if (keyTypeMap.containsKey(keyType) || (certificateType = SignatureAlgorithm.getClientCertificateType(signatureAlgorithm = signatureSchemeInfo.getSignatureAlgorithm())) < 0 || !Arrays.contains((short[])certificateTypes, (short)certificateType) || !signatureSchemeInfo.isSupportedPre13() || !signatureSchemes.hasLocalSignatureScheme(signatureSchemeInfo)) continue;
            keyTypeMap.put(keyType, signatureSchemeInfo);
        }
        if (keyTypeMap.isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.clientID + " (1.2) found no usable signature schemes");
            }
            return null;
        }
        String[] keyTypes = keyTypeMap.keySet().toArray(TlsUtils.EMPTY_STRINGS);
        BCX509Key x509Key = this.manager.chooseClientKey(keyTypes, issuers);
        if (null == x509Key) {
            this.handleKeyManagerMisses(keyTypeMap, null);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.clientID + " (1.2) did not select any credentials");
            }
            return null;
        }
        String selectedKeyType = x509Key.getKeyType();
        this.handleKeyManagerMisses(keyTypeMap, selectedKeyType);
        SignatureSchemeInfo selectedSignatureSchemeInfo = keyTypeMap.get(selectedKeyType);
        if (null == selectedSignatureSchemeInfo) {
            throw new TlsFatalAlert(80, "Key manager returned invalid key type");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.clientID + " (1.2) selected credentials for signature scheme '" + selectedSignatureSchemeInfo + "' (keyType '" + selectedKeyType + "'), with private key algorithm '" + JsseUtils.getPrivateKeyAlgorithm(x509Key.getPrivateKey()) + "'");
        }
        return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), x509Key, selectedSignatureSchemeInfo.getSignatureAndHashAlgorithm());
    }

    protected TlsCredentials selectClientCredentials13(Principal[] issuers, byte[] certificateRequestContext) throws IOException {
        SignatureSchemeInfo.PerConnection signatureSchemes = this.jsseSecurityParameters.signatureSchemes;
        LinkedHashMap<String, SignatureSchemeInfo> keyTypeMap = new LinkedHashMap<String, SignatureSchemeInfo>();
        for (SignatureSchemeInfo signatureSchemeInfo : signatureSchemes.getPeerSigSchemes()) {
            String keyType = signatureSchemeInfo.getKeyType13();
            if (keyTypeMap.containsKey(keyType) || !signatureSchemeInfo.isSupportedPost13() || !signatureSchemes.hasLocalSignatureScheme(signatureSchemeInfo)) continue;
            keyTypeMap.put(keyType, signatureSchemeInfo);
        }
        if (keyTypeMap.isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.clientID + " (1.3) found no usable signature schemes");
            }
            return null;
        }
        String[] keyTypes = keyTypeMap.keySet().toArray(TlsUtils.EMPTY_STRINGS);
        BCX509Key x509Key = this.manager.chooseClientKey(keyTypes, issuers);
        if (null == x509Key) {
            this.handleKeyManagerMisses(keyTypeMap, null);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.clientID + " (1.3) did not select any credentials");
            }
            return null;
        }
        String selectedKeyType = x509Key.getKeyType();
        this.handleKeyManagerMisses(keyTypeMap, selectedKeyType);
        SignatureSchemeInfo selectedSignatureSchemeInfo = keyTypeMap.get(selectedKeyType);
        if (null == selectedSignatureSchemeInfo) {
            throw new TlsFatalAlert(80, "Key manager returned invalid key type");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.clientID + " (1.3) selected credentials for signature scheme '" + selectedSignatureSchemeInfo + "' (keyType '" + selectedKeyType + "'), with private key algorithm '" + JsseUtils.getPrivateKeyAlgorithm(x509Key.getPrivateKey()) + "'");
        }
        return JsseUtils.createCredentialedSigner13(this.context, this.getCrypto(), x509Key, selectedSignatureSchemeInfo.getSignatureAndHashAlgorithm(), certificateRequestContext);
    }

    protected TlsCredentials selectClientCredentialsLegacy(Principal[] issuers, short[] certificateTypes) throws IOException {
        String[] keyTypes = this.getKeyTypesLegacy(certificateTypes);
        if (keyTypes.length < 1) {
            return null;
        }
        BCX509Key x509Key = this.manager.chooseClientKey(keyTypes, issuers);
        if (null == x509Key) {
            return null;
        }
        return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), x509Key, null);
    }

    private void handleKeyManagerMisses(LinkedHashMap<String, SignatureSchemeInfo> keyTypeMap, String selectedKeyType) {
        Map.Entry<String, SignatureSchemeInfo> entry;
        String keyType;
        Iterator<Map.Entry<String, SignatureSchemeInfo>> iterator = keyTypeMap.entrySet().iterator();
        while (iterator.hasNext() && !(keyType = (entry = iterator.next()).getKey()).equals(selectedKeyType)) {
            if (!LOG.isLoggable(Level.FINER)) continue;
            SignatureSchemeInfo signatureSchemeInfo = entry.getValue();
            LOG.finer(this.clientID + " found no credentials for signature scheme '" + signatureSchemeInfo + "' (keyType '" + keyType + "')");
        }
    }
}

