/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.AbstractTlsServer;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class DefaultTlsServer
extends AbstractTlsServer {
    private static final int[] DEFAULT_CIPHER_SUITES = new int[]{4867, 4866, 4865, 52392, 49200, 49199, 49192, 49191, 49172, 49171, 52394, 159, 158, 107, 103, 57, 51};

    public DefaultTlsServer(TlsCrypto crypto) {
        super(crypto);
    }

    protected TlsCredentialedSigner getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedSigner getECDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), DEFAULT_CIPHER_SUITES);
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        switch (securityParameters.getKeyExchangeAlgorithm()) {
            case 3: {
                return this.getDSASignerCredentials();
            }
            case 17: {
                return this.getECDSASignerCredentials();
            }
            case 5: 
            case 19: {
                return this.getRSASignerCredentials();
            }
            case 0: {
                throw new TlsFatalAlert(80, securityParameters.getNegotiatedVersion() + " credentials unhandled");
            }
            case 1: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }
}

