/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.SSLSocketUtil;

class ProvSSLSocketFactory
extends SSLSocketFactory {
    protected final ContextData contextData;

    ProvSSLSocketFactory(ContextData contextData) {
        this.contextData = contextData;
    }

    public Socket createSocket() throws IOException {
        return SSLSocketUtil.create(this.contextData);
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return SSLSocketUtil.create(this.contextData, host, port);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return SSLSocketUtil.create(this.contextData, address, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return SSLSocketUtil.create(this.contextData, host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return SSLSocketUtil.create(this.contextData, host, port, localHost, localPort);
    }

    public Socket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
        return SSLSocketUtil.create(this.contextData, s, consumed, autoClose);
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return SSLSocketUtil.create(this.contextData, s, host, port, autoClose);
    }

    public String[] getDefaultCipherSuites() {
        return this.contextData.getDefaultCipherSuites(true);
    }

    public String[] getSupportedCipherSuites() {
        return this.contextData.getSupportedCipherSuites();
    }
}

