/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CertificateVerify;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.ExtensionType;
import org.bouncycastle.tls.HandshakeMessageInput;
import org.bouncycastle.tls.HandshakeMessageOutput;
import org.bouncycastle.tls.KeyShareEntry;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.OfferedPsks;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContextImpl;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsPSK;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    TlsClientContextImpl tlsClientContext = null;
    protected Hashtable clientAgreements = null;
    OfferedPsks.BindersConfig clientBinders = null;
    protected ClientHello clientHello = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateStatus certificateStatus = null;
    protected CertificateRequest certificateRequest = null;

    public TlsClientProtocol() {
    }

    public TlsClientProtocol(InputStream input, OutputStream output) {
        super(input, output);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("'connect' can only be called once");
        }
        this.tlsClient = tlsClient;
        this.tlsClientContext = new TlsClientContextImpl(tlsClient.getCrypto());
        tlsClient.init(this.tlsClientContext);
        tlsClient.notifyCloseHandle(this);
        this.beginHandshake(false);
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    protected void beginHandshake(boolean renegotiation) throws IOException {
        super.beginHandshake(renegotiation);
        this.sendClientHello();
        this.connection_state = 1;
    }

    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.clientAgreements = null;
        this.clientBinders = null;
        this.clientHello = null;
        this.keyExchange = null;
        this.authentication = null;
        this.certificateStatus = null;
        this.certificateRequest = null;
    }

    protected TlsContext getContext() {
        return this.tlsClientContext;
    }

    AbstractTlsContext getContextAdmin() {
        return this.tlsClientContext;
    }

    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    protected void handle13HandshakeMessage(short type, HandshakeMessageInput buf) throws IOException {
        if (!this.isTLSv13ConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        block0 : switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 5: {
                        this.skip13CertificateRequest();
                    }
                    case 11: {
                        this.receive13ServerCertificate(buf);
                        this.connection_state = (short)7;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 13: {
                switch (this.connection_state) {
                    case 21: {
                        throw new TlsFatalAlert(10);
                    }
                    case 5: {
                        this.receive13CertificateRequest(buf, false);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 7: {
                        this.receive13ServerCertificateVerify(buf);
                        buf.updateHash(this.handshakeHash);
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 8: {
                switch (this.connection_state) {
                    case 4: {
                        this.receive13EncryptedExtensions(buf);
                        this.connection_state = (short)5;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 5: {
                        this.skip13CertificateRequest();
                    }
                    case 11: {
                        this.skip13ServerCertificate();
                    }
                    case 9: {
                        this.receive13ServerFinished(buf);
                        buf.updateHash(this.handshakeHash);
                        this.connection_state = (short)20;
                        byte[] serverFinishedTranscriptHash = TlsUtils.getCurrentPRFHash(this.handshakeHash);
                        this.recordStream.setIgnoreChangeCipherSpec(false);
                        if (null != this.certificateRequest) {
                            TlsCredentialedSigner clientCredentials = TlsUtils.establish13ClientCredentials(this.authentication, this.certificateRequest);
                            Certificate clientCertificate = null;
                            if (null != clientCredentials) {
                                clientCertificate = clientCredentials.getCertificate();
                            }
                            if (null == clientCertificate) {
                                clientCertificate = Certificate.EMPTY_CHAIN_TLS13;
                            }
                            this.send13CertificateMessage(clientCertificate);
                            this.connection_state = (short)15;
                            if (null != clientCredentials) {
                                DigitallySigned certificateVerify = TlsUtils.generate13CertificateVerify(this.tlsClientContext, clientCredentials, this.handshakeHash);
                                this.send13CertificateVerifyMessage(certificateVerify);
                                this.connection_state = (short)17;
                            }
                        }
                        this.send13FinishedMessage();
                        this.connection_state = (short)18;
                        TlsUtils.establish13PhaseApplication(this.tlsClientContext, serverFinishedTranscriptHash, this.recordStream);
                        this.recordStream.enablePendingCipherWrite();
                        this.recordStream.enablePendingCipherRead(false);
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 24: {
                this.receive13KeyUpdate(buf);
                break;
            }
            case 4: {
                this.receive13NewSessionTicket(buf);
                break;
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        throw new TlsFatalAlert(80);
                    }
                    case 3: {
                        ServerHello serverHello = this.receiveServerHelloMessage(buf);
                        if (serverHello.isHelloRetryRequest()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.process13ServerHello(serverHello, true);
                        buf.updateHash(this.handshakeHash);
                        this.connection_state = (short)4;
                        this.process13ServerHelloCoda(serverHello, true);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleHandshakeMessage(short type, HandshakeMessageInput buf) throws IOException {
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParameters();
        if (this.connection_state > 1 && TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            if (securityParameters.isResumedSession()) {
                throw new TlsFatalAlert(80);
            }
            this.handle13HandshakeMessage(type, buf);
            return;
        }
        if (!this.isLegacyConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (securityParameters.isResumedSession() && type != 0) {
            if (type != 20 || this.connection_state != 4) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(buf);
            buf.updateHash(this.handshakeHash);
            this.connection_state = (short)20;
            this.sendChangeCipherSpec();
            this.sendFinishedMessage();
            this.connection_state = (short)18;
            this.completeHandshake();
            return;
        }
        block0 : switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = TlsUtils.receiveServerCertificate(this.tlsClientContext, this.tlsClient, buf, this.serverExtensions);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)7;
                break;
            }
            case 22: {
                switch (this.connection_state) {
                    case 7: {
                        if (securityParameters.getStatusRequestVersion() < 1) {
                            throw new TlsFatalAlert(10);
                        }
                        this.certificateStatus = CertificateStatus.parse(this.tlsClientContext, buf);
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)8;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 18: {
                        if (this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 19: {
                        this.processFinishedMessage(buf);
                        this.connection_state = (short)20;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        ServerHello serverHello = this.receiveServerHelloMessage(buf);
                        if (serverHello.isHelloRetryRequest()) {
                            this.process13HelloRetryRequest(serverHello);
                            this.handshakeHash.notifyPRFDetermined();
                            this.handshakeHash.sealHashAlgorithms();
                            TlsUtils.adjustTranscriptForRetry(this.handshakeHash);
                            buf.updateHash(this.handshakeHash);
                            this.connection_state = (short)2;
                            this.send13ClientHelloRetry();
                            this.connection_state = (short)3;
                            break block0;
                        }
                        this.processServerHello(serverHello);
                        this.handshakeHash.notifyPRFDetermined();
                        if (TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
                            this.handshakeHash.sealHashAlgorithms();
                        }
                        buf.updateHash(this.handshakeHash);
                        this.connection_state = (short)4;
                        if (!TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) break block0;
                        this.process13ServerHelloCoda(serverHello, false);
                        break block0;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
            }
            case 23: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage(buf));
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 14: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = null;
                    }
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 10: 
                    case 11: {
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)12;
                        TlsCredentials clientAuthCredentials = null;
                        TlsCredentialedSigner clientAuthSigner = null;
                        Certificate clientAuthCertificate = null;
                        SignatureAndHashAlgorithm clientAuthAlgorithm = null;
                        TlsStreamSigner clientAuthStreamSigner = null;
                        if (this.certificateRequest != null && (clientAuthCredentials = TlsUtils.establishClientCredentials(this.authentication, this.certificateRequest)) != null) {
                            clientAuthCertificate = clientAuthCredentials.getCertificate();
                            if (clientAuthCredentials instanceof TlsCredentialedSigner) {
                                clientAuthSigner = (TlsCredentialedSigner)clientAuthCredentials;
                                clientAuthAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(securityParameters.getNegotiatedVersion(), clientAuthSigner);
                                clientAuthStreamSigner = clientAuthSigner.getStreamSigner();
                                if (ProtocolVersion.TLSv12.equals(securityParameters.getNegotiatedVersion())) {
                                    TlsUtils.verifySupportedSignatureAlgorithm(securityParameters.getServerSigAlgs(), clientAuthAlgorithm, (short)80);
                                    if (clientAuthStreamSigner == null) {
                                        TlsUtils.trackHashAlgorithmClient(this.handshakeHash, clientAuthAlgorithm);
                                    }
                                }
                                if (clientAuthStreamSigner != null) {
                                    this.handshakeHash.forceBuffering();
                                }
                            }
                        }
                        this.handshakeHash.sealHashAlgorithms();
                        if (clientAuthCredentials == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            this.keyExchange.processClientCredentials(clientAuthCredentials);
                        }
                        Vector clientSupplementalData = this.tlsClient.getClientSupplementalData();
                        if (clientSupplementalData != null) {
                            this.sendSupplementalDataMessage(clientSupplementalData);
                            this.connection_state = (short)14;
                        }
                        if (this.certificateRequest != null) {
                            this.sendCertificateMessage(clientAuthCertificate, null);
                            this.connection_state = (short)15;
                        }
                        this.sendClientKeyExchange();
                        this.connection_state = (short)16;
                        boolean isSSL = TlsUtils.isSSL(this.tlsClientContext);
                        if (isSSL) {
                            TlsClientProtocol.establishMasterSecret(this.tlsClientContext, this.keyExchange);
                        }
                        securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(this.handshakeHash);
                        if (!isSSL) {
                            TlsClientProtocol.establishMasterSecret(this.tlsClientContext, this.keyExchange);
                        }
                        this.recordStream.setPendingCipher(TlsUtils.initCipher(this.tlsClientContext));
                        if (clientAuthSigner != null) {
                            DigitallySigned certificateVerify = TlsUtils.generateCertificateVerifyClient(this.tlsClientContext, clientAuthSigner, clientAuthAlgorithm, clientAuthStreamSigner, this.handshakeHash);
                            this.sendCertificateVerifyMessage(certificateVerify);
                            this.connection_state = (short)17;
                        }
                        this.handshakeHash.stopTracking();
                        this.sendChangeCipherSpec();
                        this.sendFinishedMessage();
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)18;
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = null;
                    }
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.processServerKeyExchange(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)10;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 10: {
                        this.receiveCertificateRequest(buf);
                        TlsUtils.establishServerSigAlgs(securityParameters, this.certificateRequest);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)11;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 18: {
                        if (!this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                        securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
                        this.invalidateSession();
                        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
                        this.receiveNewSessionTicket(buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)19;
                break;
            }
            case 0: {
                TlsClientProtocol.assertEmpty(buf);
                if (!this.isApplicationDataReady()) break;
                this.handleRenegotiation();
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleServerCertificate() throws IOException {
        TlsUtils.processServerCertificate(this.tlsClientContext, this.certificateStatus, this.keyExchange, this.authentication, this.clientExtensions, this.serverExtensions);
    }

    protected void handleSupplementalData(Vector serverSupplementalData) throws IOException {
        this.tlsClient.processServerSupplementalData(serverSupplementalData);
        this.connection_state = (short)6;
        this.keyExchange = TlsUtils.initKeyExchangeClient(this.tlsClientContext, this.tlsClient);
    }

    protected void process13HelloRetryRequest(ServerHello helloRetryRequest) throws IOException {
        ProtocolVersion legacy_record_version = ProtocolVersion.TLSv12;
        this.recordStream.setWriteVersion(legacy_record_version);
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            throw new TlsFatalAlert(80);
        }
        ProtocolVersion legacy_version = helloRetryRequest.getVersion();
        byte[] legacy_session_id_echo = helloRetryRequest.getSessionID();
        int cipherSuite = helloRetryRequest.getCipherSuite();
        if (!(ProtocolVersion.TLSv12.equals(legacy_version) && Arrays.areEqual((byte[])this.clientHello.getSessionID(), (byte[])legacy_session_id_echo) && TlsUtils.isValidCipherSuiteSelection(this.clientHello.getCipherSuites(), cipherSuite))) {
            throw new TlsFatalAlert(47);
        }
        Hashtable extensions = helloRetryRequest.getExtensions();
        if (null == extensions) {
            throw new TlsFatalAlert(47);
        }
        TlsUtils.checkExtensionData13(extensions, 6, (short)47);
        Enumeration e = extensions.keys();
        while (e.hasMoreElements()) {
            Integer extType = (Integer)e.nextElement();
            if (44 == extType || null != TlsUtils.getExtensionData(this.clientExtensions, extType)) continue;
            throw new TlsFatalAlert(110);
        }
        ProtocolVersion server_version = TlsExtensionsUtils.getSupportedVersionsExtensionServer(extensions);
        if (null == server_version) {
            throw new TlsFatalAlert(109);
        }
        if (!(ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(server_version) && ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), server_version) && TlsUtils.isValidVersionForCipherSuite(cipherSuite, server_version))) {
            throw new TlsFatalAlert(47);
        }
        if (null != this.clientBinders && !Arrays.contains((short[])this.clientBinders.pskKeyExchangeModes, (short)1)) {
            this.clientBinders = null;
            this.tlsClient.notifySelectedPSK(null);
        }
        int selected_group = TlsExtensionsUtils.getKeyShareHelloRetryRequest(extensions);
        if (!TlsUtils.isValidKeyShareSelection(server_version, securityParameters.getClientSupportedGroups(), this.clientAgreements, selected_group)) {
            throw new TlsFatalAlert(47);
        }
        byte[] cookie = TlsExtensionsUtils.getCookieExtension(extensions);
        securityParameters.negotiatedVersion = server_version;
        TlsUtils.negotiatedVersionTLSClient(this.tlsClientContext, this.tlsClient);
        securityParameters.resumedSession = false;
        securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
        this.tlsClient.notifySessionID(TlsUtils.EMPTY_BYTES);
        TlsUtils.negotiatedCipherSuite(securityParameters, cipherSuite);
        this.tlsClient.notifySelectedCipherSuite(cipherSuite);
        this.clientAgreements = null;
        this.retryCookie = cookie;
        this.retryGroup = selected_group;
    }

    protected void process13ServerHello(ServerHello serverHello, boolean afterHelloRetryRequest) throws IOException {
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        ProtocolVersion legacy_version = serverHello.getVersion();
        byte[] legacy_session_id_echo = serverHello.getSessionID();
        int cipherSuite = serverHello.getCipherSuite();
        if (!ProtocolVersion.TLSv12.equals(legacy_version) || !Arrays.areEqual((byte[])this.clientHello.getSessionID(), (byte[])legacy_session_id_echo)) {
            throw new TlsFatalAlert(47);
        }
        Hashtable extensions = serverHello.getExtensions();
        if (null == extensions) {
            throw new TlsFatalAlert(47);
        }
        TlsUtils.checkExtensionData13(extensions, 2, (short)47);
        if (afterHelloRetryRequest) {
            ProtocolVersion server_version = TlsExtensionsUtils.getSupportedVersionsExtensionServer(extensions);
            if (null == server_version) {
                throw new TlsFatalAlert(109);
            }
            if (!securityParameters.getNegotiatedVersion().equals(server_version) || securityParameters.getCipherSuite() != cipherSuite) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (!TlsUtils.isValidCipherSuiteSelection(this.clientHello.getCipherSuites(), cipherSuite) || !TlsUtils.isValidVersionForCipherSuite(cipherSuite, securityParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.resumedSession = false;
            securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
            this.tlsClient.notifySessionID(TlsUtils.EMPTY_BYTES);
            TlsUtils.negotiatedCipherSuite(securityParameters, cipherSuite);
            this.tlsClient.notifySelectedCipherSuite(cipherSuite);
        }
        this.clientHello = null;
        securityParameters.serverRandom = serverHello.getRandom();
        securityParameters.secureRenegotiation = false;
        securityParameters.extendedMasterSecret = true;
        securityParameters.statusRequestVersion = this.clientExtensions.containsKey(TlsExtensionsUtils.EXT_status_request) ? 1 : 0;
        TlsSecret pskEarlySecret = null;
        int selected_identity = TlsExtensionsUtils.getPreSharedKeyServerHello(extensions);
        TlsPSK selectedPSK = null;
        if (selected_identity >= 0) {
            if (null == this.clientBinders || selected_identity >= this.clientBinders.psks.length) {
                throw new TlsFatalAlert(47);
            }
            selectedPSK = this.clientBinders.psks[selected_identity];
            if (selectedPSK.getPRFAlgorithm() != securityParameters.getPRFAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            pskEarlySecret = this.clientBinders.earlySecrets[selected_identity];
            this.selectedPSK13 = true;
        }
        this.tlsClient.notifySelectedPSK(selectedPSK);
        TlsSecret sharedSecret = null;
        KeyShareEntry keyShareEntry = TlsExtensionsUtils.getKeyShareServerHello(extensions);
        if (null == keyShareEntry) {
            if (afterHelloRetryRequest || null == pskEarlySecret || !Arrays.contains((short[])this.clientBinders.pskKeyExchangeModes, (short)0)) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (null != pskEarlySecret && !Arrays.contains((short[])this.clientBinders.pskKeyExchangeModes, (short)1)) {
                throw new TlsFatalAlert(47);
            }
            int namedGroup = keyShareEntry.getNamedGroup();
            TlsAgreement agreement = (TlsAgreement)this.clientAgreements.get(Integers.valueOf((int)namedGroup));
            if (null == agreement) {
                throw new TlsFatalAlert(47);
            }
            agreement.receivePeerValue(keyShareEntry.getKeyExchange());
            sharedSecret = agreement.calculateSecret();
        }
        this.clientAgreements = null;
        this.clientBinders = null;
        TlsUtils.establish13PhaseSecrets(this.tlsClientContext, pskEarlySecret, sharedSecret);
        this.invalidateSession();
        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
    }

    protected void process13ServerHelloCoda(ServerHello serverHello, boolean afterHelloRetryRequest) throws IOException {
        byte[] serverHelloTranscriptHash = TlsUtils.getCurrentPRFHash(this.handshakeHash);
        TlsUtils.establish13PhaseHandshake(this.tlsClientContext, serverHelloTranscriptHash, this.recordStream);
        if (!afterHelloRetryRequest) {
            this.recordStream.setIgnoreChangeCipherSpec(true);
            this.sendChangeCipherSpecMessage();
        }
        this.recordStream.enablePendingCipherWrite();
        this.recordStream.enablePendingCipherRead(false);
    }

    protected void processServerHello(ServerHello serverHello) throws IOException {
        ProtocolVersion server_version;
        Hashtable serverHelloExtensions = serverHello.getExtensions();
        ProtocolVersion legacy_version = serverHello.getVersion();
        ProtocolVersion supported_version = TlsExtensionsUtils.getSupportedVersionsExtensionServer(serverHelloExtensions);
        if (null == supported_version) {
            server_version = legacy_version;
        } else {
            if (!ProtocolVersion.TLSv12.equals(legacy_version) || !ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(supported_version)) {
                throw new TlsFatalAlert(47);
            }
            server_version = supported_version;
        }
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            if (!server_version.equals(securityParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (!ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), server_version)) {
                throw new TlsFatalAlert(70);
            }
            ProtocolVersion legacy_record_version = server_version.isLaterVersionOf(ProtocolVersion.TLSv12) ? ProtocolVersion.TLSv12 : server_version;
            this.recordStream.setWriteVersion(legacy_record_version);
            securityParameters.negotiatedVersion = server_version;
        }
        TlsUtils.negotiatedVersionTLSClient(this.tlsClientContext, this.tlsClient);
        if (ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(server_version)) {
            this.process13ServerHello(serverHello, false);
            return;
        }
        int[] offeredCipherSuites = this.clientHello.getCipherSuites();
        this.clientHello = null;
        this.retryCookie = null;
        this.retryGroup = -1;
        securityParameters.serverRandom = serverHello.getRandom();
        if (!this.tlsClientContext.getClientVersion().equals(server_version)) {
            TlsUtils.checkDowngradeMarker(server_version, securityParameters.getServerRandom());
        }
        byte[] selectedSessionID = serverHello.getSessionID();
        securityParameters.sessionID = selectedSessionID;
        this.tlsClient.notifySessionID(selectedSessionID);
        boolean bl = securityParameters.resumedSession = selectedSessionID.length > 0 && this.tlsSession != null && Arrays.areEqual((byte[])selectedSessionID, (byte[])this.tlsSession.getSessionID());
        if (securityParameters.isResumedSession() && (serverHello.getCipherSuite() != this.sessionParameters.getCipherSuite() || !securityParameters.getNegotiatedVersion().equals(this.sessionParameters.getNegotiatedVersion()))) {
            throw new TlsFatalAlert(47, "ServerHello parameters do not match resumed session");
        }
        int cipherSuite = serverHello.getCipherSuite();
        if (!TlsUtils.isValidCipherSuiteSelection(offeredCipherSuites, cipherSuite) || !TlsUtils.isValidVersionForCipherSuite(cipherSuite, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(47, "ServerHello selected invalid cipher suite");
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, cipherSuite);
        this.tlsClient.notifySelectedCipherSuite(cipherSuite);
        this.serverExtensions = serverHelloExtensions;
        if (serverHelloExtensions != null) {
            Enumeration e = serverHelloExtensions.keys();
            while (e.hasMoreElements()) {
                Integer extType = (Integer)e.nextElement();
                if (extType.equals(EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(this.clientExtensions, extType)) {
                    throw new TlsFatalAlert(110, "Unrequested extension in ServerHello: " + ExtensionType.getText(extType));
                }
                if (!securityParameters.isResumedSession()) continue;
            }
        }
        byte[] renegExtData = TlsUtils.getExtensionData(serverHelloExtensions, EXT_RenegotiationInfo);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            if (renegExtData == null) {
                throw new TlsFatalAlert(40);
            }
            SecurityParameters saved = this.tlsClientContext.getSecurityParametersConnection();
            byte[] reneg_conn_info = TlsUtils.concat(saved.getLocalVerifyData(), saved.getPeerVerifyData());
            if (!Arrays.constantTimeAreEqual((byte[])renegExtData, (byte[])TlsClientProtocol.createRenegotiationInfo(reneg_conn_info))) {
                throw new TlsFatalAlert(40);
            }
        } else if (renegExtData == null) {
            securityParameters.secureRenegotiation = false;
        } else {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])renegExtData, (byte[])TlsClientProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsClient.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        boolean negotiatedEMS = false;
        if (TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.clientExtensions)) {
            negotiatedEMS = TlsExtensionsUtils.hasExtendedMasterSecretExtension(serverHelloExtensions);
            if (TlsUtils.isExtendedMasterSecretOptional(server_version)) {
                if (!negotiatedEMS && this.tlsClient.requiresExtendedMasterSecret()) {
                    throw new TlsFatalAlert(40, "Extended Master Secret extension is required");
                }
            } else if (negotiatedEMS) {
                throw new TlsFatalAlert(47, "Server sent an unexpected extended_master_secret extension negotiating " + server_version);
            }
        }
        securityParameters.extendedMasterSecret = negotiatedEMS;
        if (securityParameters.isResumedSession() && securityParameters.isExtendedMasterSecret() != this.sessionParameters.isExtendedMasterSecret()) {
            throw new TlsFatalAlert(40, "Server resumed session with mismatched extended_master_secret negotiation");
        }
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(serverHelloExtensions);
        securityParameters.applicationProtocolSet = true;
        Hashtable sessionClientExtensions = this.clientExtensions;
        Hashtable sessionServerExtensions = serverHelloExtensions;
        if (securityParameters.isResumedSession()) {
            sessionClientExtensions = null;
            sessionServerExtensions = this.sessionParameters.readServerExtensions();
        }
        if (sessionServerExtensions != null && !sessionServerExtensions.isEmpty()) {
            boolean serverSentEncryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(sessionServerExtensions);
            if (serverSentEncryptThenMAC && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = serverSentEncryptThenMAC;
            securityParameters.maxFragmentLength = TlsUtils.processMaxFragmentLengthExtension(sessionClientExtensions, sessionServerExtensions, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(sessionServerExtensions);
            if (!securityParameters.isResumedSession()) {
                if (TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsExtensionsUtils.EXT_status_request_v2, (short)47)) {
                    securityParameters.statusRequestVersion = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsExtensionsUtils.EXT_status_request, (short)47)) {
                    securityParameters.statusRequestVersion = 1;
                }
                securityParameters.clientCertificateType = TlsUtils.processClientCertificateTypeExtension(sessionClientExtensions, sessionServerExtensions, (short)47);
                securityParameters.serverCertificateType = TlsUtils.processServerCertificateTypeExtension(sessionClientExtensions, sessionServerExtensions, (short)47);
                this.expectSessionTicket = TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsProtocol.EXT_SessionTicket, (short)47);
            }
        }
        if (sessionClientExtensions != null) {
            this.tlsClient.processServerExtensions(sessionServerExtensions);
        }
        this.applyMaxFragmentLengthExtension(securityParameters.getMaxFragmentLength());
        if (securityParameters.isResumedSession()) {
            securityParameters.masterSecret = this.sessionMasterSecret;
            this.recordStream.setPendingCipher(TlsUtils.initCipher(this.tlsClientContext));
        } else {
            this.invalidateSession();
            this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
        }
    }

    protected void receive13CertificateRequest(ByteArrayInputStream buf, boolean postHandshakeAuth) throws IOException {
        if (postHandshakeAuth) {
            throw new TlsFatalAlert(80);
        }
        if (this.selectedPSK13) {
            throw new TlsFatalAlert(10);
        }
        CertificateRequest certificateRequest = CertificateRequest.parse(this.tlsClientContext, buf);
        TlsClientProtocol.assertEmpty(buf);
        if (!certificateRequest.hasCertificateRequestContext(TlsUtils.EMPTY_BYTES)) {
            throw new TlsFatalAlert(47);
        }
        this.certificateRequest = certificateRequest;
        TlsUtils.establishServerSigAlgs(this.tlsClientContext.getSecurityParametersHandshake(), certificateRequest);
    }

    protected void receive13EncryptedExtensions(ByteArrayInputStream buf) throws IOException {
        byte[] extBytes = TlsUtils.readOpaque16(buf);
        TlsClientProtocol.assertEmpty(buf);
        this.serverExtensions = TlsClientProtocol.readExtensionsData13(8, extBytes);
        Enumeration e = this.serverExtensions.keys();
        while (e.hasMoreElements()) {
            Integer extType = (Integer)e.nextElement();
            if (null != TlsUtils.getExtensionData(this.clientExtensions, extType)) continue;
            throw new TlsFatalAlert(110);
        }
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        Hashtable sessionClientExtensions = this.clientExtensions;
        Hashtable sessionServerExtensions = this.serverExtensions;
        if (securityParameters.isResumedSession()) {
            sessionClientExtensions = null;
            sessionServerExtensions = this.sessionParameters.readServerExtensions();
        }
        securityParameters.maxFragmentLength = TlsUtils.processMaxFragmentLengthExtension(sessionClientExtensions, sessionServerExtensions, (short)47);
        securityParameters.encryptThenMAC = false;
        securityParameters.truncatedHMac = false;
        if (!securityParameters.isResumedSession()) {
            securityParameters.statusRequestVersion = this.clientExtensions.containsKey(TlsExtensionsUtils.EXT_status_request) ? 1 : 0;
            securityParameters.clientCertificateType = TlsUtils.processClientCertificateTypeExtension13(sessionClientExtensions, sessionServerExtensions, (short)47);
            securityParameters.serverCertificateType = TlsUtils.processServerCertificateTypeExtension13(sessionClientExtensions, sessionServerExtensions, (short)47);
        }
        this.expectSessionTicket = false;
        if (null != sessionClientExtensions) {
            this.tlsClient.processServerExtensions(this.serverExtensions);
        }
        this.applyMaxFragmentLengthExtension(securityParameters.getMaxFragmentLength());
    }

    protected void receive13NewSessionTicket(ByteArrayInputStream buf) throws IOException {
        if (!this.isApplicationDataReady()) {
            throw new TlsFatalAlert(10);
        }
        TlsUtils.readUint32(buf);
        TlsUtils.readUint32(buf);
        TlsUtils.readOpaque8(buf);
        TlsUtils.readOpaque16(buf);
        TlsUtils.readOpaque16(buf);
        TlsClientProtocol.assertEmpty(buf);
    }

    protected void receive13ServerCertificate(ByteArrayInputStream buf) throws IOException {
        if (this.selectedPSK13) {
            throw new TlsFatalAlert(10);
        }
        this.authentication = TlsUtils.receive13ServerCertificate(this.tlsClientContext, this.tlsClient, buf, this.serverExtensions);
        this.handleServerCertificate();
    }

    protected void receive13ServerCertificateVerify(ByteArrayInputStream buf) throws IOException {
        Certificate serverCertificate = this.tlsClientContext.getSecurityParametersHandshake().getPeerCertificate();
        if (null == serverCertificate || serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        CertificateVerify certificateVerify = CertificateVerify.parse(this.tlsClientContext, buf);
        TlsClientProtocol.assertEmpty(buf);
        TlsUtils.verify13CertificateVerifyServer(this.tlsClientContext, this.handshakeHash, certificateVerify);
    }

    protected void receive13ServerFinished(ByteArrayInputStream buf) throws IOException {
        this.process13FinishedMessage(buf);
    }

    protected void receiveCertificateRequest(ByteArrayInputStream buf) throws IOException {
        if (null == this.authentication) {
            throw new TlsFatalAlert(40);
        }
        CertificateRequest certificateRequest = CertificateRequest.parse(this.tlsClientContext, buf);
        TlsClientProtocol.assertEmpty(buf);
        this.certificateRequest = TlsUtils.validateCertificateRequest(certificateRequest, this.keyExchange);
    }

    protected void receiveNewSessionTicket(ByteArrayInputStream buf) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(buf);
        TlsClientProtocol.assertEmpty(buf);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected ServerHello receiveServerHelloMessage(ByteArrayInputStream buf) throws IOException {
        return ServerHello.parse(buf);
    }

    protected void send13ClientHelloRetry() throws IOException {
        Hashtable clientHelloExtensions = this.clientHello.getExtensions();
        clientHelloExtensions.remove(TlsExtensionsUtils.EXT_cookie);
        clientHelloExtensions.remove(TlsExtensionsUtils.EXT_early_data);
        clientHelloExtensions.remove(TlsExtensionsUtils.EXT_key_share);
        clientHelloExtensions.remove(TlsExtensionsUtils.EXT_pre_shared_key);
        if (null != this.retryCookie) {
            TlsExtensionsUtils.addCookieExtension(clientHelloExtensions, this.retryCookie);
            this.retryCookie = null;
        }
        if (null != this.clientBinders) {
            this.clientBinders = TlsUtils.addPreSharedKeyToClientHelloRetry(this.tlsClientContext, this.clientBinders, clientHelloExtensions);
            if (null == this.clientBinders) {
                this.tlsClient.notifySelectedPSK(null);
            }
        }
        if (this.retryGroup < 0) {
            throw new TlsFatalAlert(80);
        }
        this.clientAgreements = TlsUtils.addKeyShareToClientHelloRetry(this.tlsClientContext, clientHelloExtensions, this.retryGroup);
        this.recordStream.setIgnoreChangeCipherSpec(true);
        this.sendChangeCipherSpecMessage();
        this.sendClientHelloMessage();
    }

    protected void sendCertificateVerifyMessage(DigitallySigned certificateVerify) throws IOException {
        HandshakeMessageOutput message = new HandshakeMessageOutput(15);
        certificateVerify.encode(message);
        message.send(this);
    }

    protected void sendClientHello() throws IOException {
        ProtocolVersion latestVersion;
        ProtocolVersion earliestVersion;
        ProtocolVersion[] supportedVersions;
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            ProtocolVersion clientVersion = this.tlsClientContext.getClientVersion();
            supportedVersions = clientVersion.only();
            earliestVersion = clientVersion;
            latestVersion = clientVersion;
        } else {
            supportedVersions = this.tlsClient.getProtocolVersions();
            if (ProtocolVersion.contains(supportedVersions, ProtocolVersion.SSLv3)) {
                this.recordStream.setWriteVersion(ProtocolVersion.SSLv3);
            } else {
                this.recordStream.setWriteVersion(ProtocolVersion.TLSv10);
            }
            earliestVersion = ProtocolVersion.getEarliestTLS(supportedVersions);
            latestVersion = ProtocolVersion.getLatestTLS(supportedVersions);
            if (!ProtocolVersion.isSupportedTLSVersionClient(latestVersion)) {
                throw new TlsFatalAlert(80);
            }
            this.tlsClientContext.setClientVersion(latestVersion);
        }
        this.tlsClientContext.setClientSupportedVersions(supportedVersions);
        boolean offeringTLSv12Minus = ProtocolVersion.TLSv12.isEqualOrLaterVersionOf(earliestVersion);
        boolean offeringTLSv13Plus = ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(latestVersion);
        boolean useGMTUnixTime = !offeringTLSv13Plus && this.tlsClient.shouldUseGMTUnixTime();
        securityParameters.clientRandom = TlsClientProtocol.createRandomBlock(useGMTUnixTime, this.tlsClientContext);
        TlsSession sessionToResume = offeringTLSv12Minus ? this.tlsClient.getSessionToResume() : null;
        boolean fallback = this.tlsClient.isFallback();
        int[] offeredCipherSuites = this.tlsClient.getCipherSuites();
        this.clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsClient.getClientExtensions());
        boolean shouldUseEMS = this.tlsClient.shouldUseExtendedMasterSecret();
        this.establishSession(sessionToResume);
        byte[] legacy_session_id = TlsUtils.getSessionID(this.tlsSession);
        if (legacy_session_id.length > 0 && !Arrays.contains((int[])offeredCipherSuites, (int)this.sessionParameters.getCipherSuite())) {
            legacy_session_id = TlsUtils.EMPTY_BYTES;
        }
        ProtocolVersion sessionVersion = null;
        if (legacy_session_id.length > 0 && !ProtocolVersion.contains(supportedVersions, sessionVersion = this.sessionParameters.getNegotiatedVersion())) {
            legacy_session_id = TlsUtils.EMPTY_BYTES;
        }
        if (legacy_session_id.length > 0 && TlsUtils.isExtendedMasterSecretOptional(sessionVersion)) {
            if (shouldUseEMS) {
                if (!this.sessionParameters.isExtendedMasterSecret() && !this.tlsClient.allowLegacyResumption()) {
                    legacy_session_id = TlsUtils.EMPTY_BYTES;
                }
            } else if (this.sessionParameters.isExtendedMasterSecret()) {
                legacy_session_id = TlsUtils.EMPTY_BYTES;
            }
        }
        if (legacy_session_id.length < 1) {
            this.cancelSession();
        }
        this.tlsClient.notifySessionToResume(this.tlsSession);
        ProtocolVersion legacy_version = latestVersion;
        if (offeringTLSv13Plus) {
            legacy_version = ProtocolVersion.TLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionClient(this.clientExtensions, supportedVersions);
            if (legacy_session_id.length < 1 && this.tlsClient.shouldUseCompatibilityMode()) {
                legacy_session_id = this.tlsClientContext.getNonceGenerator().generateNonce(32);
            }
        }
        this.tlsClientContext.setRSAPreMasterSecretVersion(legacy_version);
        securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(latestVersion)) {
            TlsUtils.establishClientSigAlgs(securityParameters, this.clientExtensions);
        }
        securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(this.clientExtensions);
        this.clientBinders = TlsUtils.addPreSharedKeyToClientHello(this.tlsClientContext, this.tlsClient, this.clientExtensions, offeredCipherSuites);
        this.clientAgreements = TlsUtils.addKeyShareToClientHello(this.tlsClientContext, this.tlsClient, this.clientExtensions);
        if (shouldUseEMS && TlsUtils.isExtendedMasterSecretOptional(supportedVersions)) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.clientExtensions);
        } else {
            this.clientExtensions.remove(TlsExtensionsUtils.EXT_extended_master_secret);
        }
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            SecurityParameters saved = this.tlsClientContext.getSecurityParametersConnection();
            this.clientExtensions.put(EXT_RenegotiationInfo, TlsClientProtocol.createRenegotiationInfo(saved.getLocalVerifyData()));
        } else {
            boolean noRenegSCSV;
            boolean noRenegExt = null == TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
            boolean bl = noRenegSCSV = !Arrays.contains((int[])offeredCipherSuites, (int)255);
            if (noRenegExt && noRenegSCSV) {
                offeredCipherSuites = Arrays.append((int[])offeredCipherSuites, (int)255);
            }
        }
        if (fallback && !Arrays.contains((int[])offeredCipherSuites, (int)22016)) {
            offeredCipherSuites = Arrays.append((int[])offeredCipherSuites, (int)22016);
        }
        int bindersSize = null == this.clientBinders ? 0 : this.clientBinders.bindersSize;
        this.clientHello = new ClientHello(legacy_version, securityParameters.getClientRandom(), legacy_session_id, null, offeredCipherSuites, this.clientExtensions, bindersSize);
        this.sendClientHelloMessage();
    }

    protected void sendClientHelloMessage() throws IOException {
        HandshakeMessageOutput message = new HandshakeMessageOutput(1);
        this.clientHello.encode(this.tlsClientContext, message);
        message.prepareClientHello(this.handshakeHash, this.clientHello.getBindersSize());
        if (null != this.clientBinders) {
            OfferedPsks.encodeBinders(message, this.tlsClientContext.getCrypto(), this.handshakeHash, this.clientBinders);
        }
        message.sendClientHello(this, this.handshakeHash, this.clientHello.getBindersSize());
    }

    protected void sendClientKeyExchange() throws IOException {
        HandshakeMessageOutput message = new HandshakeMessageOutput(16);
        this.keyExchange.generateClientKeyExchange(message);
        message.send(this);
    }

    protected void skip13CertificateRequest() throws IOException {
        this.certificateRequest = null;
    }

    protected void skip13ServerCertificate() throws IOException {
        if (!this.selectedPSK13) {
            throw new TlsFatalAlert(10);
        }
        this.authentication = TlsUtils.skip13ServerCertificate(this.tlsClientContext);
    }
}

