/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.provider.ExportSSLSession;
import org.bouncycastle.jsse.provider.ExportSSLSession_5;
import org.bouncycastle.jsse.provider.ImportSSLSession;
import org.bouncycastle.jsse.provider.ImportSSLSession_5;
import org.bouncycastle.jsse.provider.ReflectionUtil;

abstract class SSLSessionUtil {
    private static final Class<?> extendedSSLSessionClass;
    private static final Constructor<? extends SSLSession> exportSSLSessionConstructor;
    private static final Constructor<? extends BCExtendedSSLSession> importSSLSessionConstructor;

    SSLSessionUtil() {
    }

    static SSLSession exportSSLSession(BCExtendedSSLSession sslSession) {
        if (sslSession instanceof ImportSSLSession) {
            return ((ImportSSLSession)((Object)sslSession)).unwrap();
        }
        if (null != exportSSLSessionConstructor) {
            try {
                return exportSSLSessionConstructor.newInstance(sslSession);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ExportSSLSession_5(sslSession);
    }

    static BCExtendedSSLSession importSSLSession(SSLSession sslSession) {
        if (sslSession instanceof BCExtendedSSLSession) {
            return (BCExtendedSSLSession)sslSession;
        }
        if (sslSession instanceof ExportSSLSession) {
            return ((ExportSSLSession)((Object)sslSession)).unwrap();
        }
        if (null != importSSLSessionConstructor && extendedSSLSessionClass.isInstance(sslSession)) {
            try {
                return importSSLSessionConstructor.newInstance(sslSession);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ImportSSLSession_5(sslSession);
    }

    static {
        String className;
        Method[] methods2;
        Class<?> clazz = null;
        try {
            clazz = ReflectionUtil.getClass("javax.net.ssl.ExtendedSSLSession");
        }
        catch (Exception exception) {
            // empty catch block
        }
        extendedSSLSessionClass = clazz;
        Constructor constructor = null;
        try {
            methods2 = ReflectionUtil.getMethods("javax.net.ssl.ExtendedSSLSession");
            if (null != methods2) {
                className = ReflectionUtil.hasMethod(methods2, "getRequestedServerNames") ? "org.bouncycastle.jsse.provider.ExportSSLSession_8" : "org.bouncycastle.jsse.provider.ExportSSLSession_7";
                constructor = ReflectionUtil.getDeclaredConstructor(className, BCExtendedSSLSession.class);
            }
        }
        catch (Exception methods2) {
            // empty catch block
        }
        exportSSLSessionConstructor = constructor;
        constructor = null;
        if (null != extendedSSLSessionClass) {
            try {
                methods2 = ReflectionUtil.getMethods("javax.net.ssl.ExtendedSSLSession");
                if (null != methods2) {
                    className = ReflectionUtil.hasMethod(methods2, "getRequestedServerNames") ? "org.bouncycastle.jsse.provider.ImportSSLSession_8" : "org.bouncycastle.jsse.provider.ImportSSLSession_7";
                    constructor = ReflectionUtil.getDeclaredConstructor(className, extendedSSLSessionClass);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        importSSLSessionConstructor = constructor;
    }
}

