/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class CertificateRequest {
    protected final byte[] certificateRequestContext;
    protected final short[] certificateTypes;
    protected final Vector supportedSignatureAlgorithms;
    protected final Vector supportedSignatureAlgorithmsCert;
    protected final Vector certificateAuthorities;

    private static Vector checkSupportedSignatureAlgorithms(Vector supportedSignatureAlgorithms, short alertDescription) throws IOException {
        if (null == supportedSignatureAlgorithms) {
            throw new TlsFatalAlert(alertDescription, "'signature_algorithms' is required");
        }
        return supportedSignatureAlgorithms;
    }

    public CertificateRequest(short[] certificateTypes, Vector supportedSignatureAlgorithms, Vector certificateAuthorities) {
        this(null, certificateTypes, supportedSignatureAlgorithms, null, certificateAuthorities);
    }

    public CertificateRequest(byte[] certificateRequestContext, Vector supportedSignatureAlgorithms, Vector supportedSignatureAlgorithmsCert, Vector certificateAuthorities) throws IOException {
        this(certificateRequestContext, null, CertificateRequest.checkSupportedSignatureAlgorithms(supportedSignatureAlgorithms, (short)80), supportedSignatureAlgorithmsCert, certificateAuthorities);
    }

    private CertificateRequest(byte[] certificateRequestContext, short[] certificateTypes, Vector supportedSignatureAlgorithms, Vector supportedSignatureAlgorithmsCert, Vector certificateAuthorities) {
        if (null != certificateRequestContext && !TlsUtils.isValidUint8(certificateRequestContext.length)) {
            throw new IllegalArgumentException("'certificateRequestContext' cannot be longer than 255");
        }
        if (!(null == certificateTypes || certificateTypes.length >= 1 && TlsUtils.isValidUint8(certificateTypes.length))) {
            throw new IllegalArgumentException("'certificateTypes' should have length from 1 to 255");
        }
        this.certificateRequestContext = TlsUtils.clone(certificateRequestContext);
        this.certificateTypes = certificateTypes;
        this.supportedSignatureAlgorithms = supportedSignatureAlgorithms;
        this.supportedSignatureAlgorithmsCert = supportedSignatureAlgorithmsCert;
        this.certificateAuthorities = certificateAuthorities;
    }

    public byte[] getCertificateRequestContext() {
        return TlsUtils.clone(this.certificateRequestContext);
    }

    public short[] getCertificateTypes() {
        return this.certificateTypes;
    }

    public Vector getSupportedSignatureAlgorithms() {
        return this.supportedSignatureAlgorithms;
    }

    public Vector getSupportedSignatureAlgorithmsCert() {
        return this.supportedSignatureAlgorithmsCert;
    }

    public Vector getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public boolean hasCertificateRequestContext(byte[] certificateRequestContext) {
        return Arrays.areEqual((byte[])this.certificateRequestContext, (byte[])certificateRequestContext);
    }

    public void encode(TlsContext context, OutputStream output) throws IOException {
        ProtocolVersion negotiatedVersion = context.getServerVersion();
        boolean isTLSv12 = TlsUtils.isTLSv12(negotiatedVersion);
        boolean isTLSv13 = TlsUtils.isTLSv13(negotiatedVersion);
        if (isTLSv13 != (null != this.certificateRequestContext) || isTLSv13 != (null == this.certificateTypes) || isTLSv12 != (null != this.supportedSignatureAlgorithms) || !isTLSv13 && null != this.supportedSignatureAlgorithmsCert) {
            throw new IllegalStateException();
        }
        if (isTLSv13) {
            TlsUtils.writeOpaque8(this.certificateRequestContext, output);
            Hashtable extensions = new Hashtable();
            TlsExtensionsUtils.addSignatureAlgorithmsExtension(extensions, this.supportedSignatureAlgorithms);
            if (null != this.supportedSignatureAlgorithmsCert) {
                TlsExtensionsUtils.addSignatureAlgorithmsCertExtension(extensions, this.supportedSignatureAlgorithmsCert);
            }
            if (null != this.certificateAuthorities) {
                TlsExtensionsUtils.addCertificateAuthoritiesExtension(extensions, this.certificateAuthorities);
            }
            byte[] extEncoding = TlsProtocol.writeExtensionsData(extensions);
            TlsUtils.writeOpaque16(extEncoding, output);
            return;
        }
        TlsUtils.writeUint8ArrayWithUint8Length(this.certificateTypes, output);
        if (isTLSv12) {
            TlsUtils.encodeSupportedSignatureAlgorithms(this.supportedSignatureAlgorithms, output);
        }
        if (this.certificateAuthorities == null || this.certificateAuthorities.isEmpty()) {
            TlsUtils.writeUint16(0, output);
        } else {
            int i;
            Vector<byte[]> derEncodings = new Vector<byte[]>(this.certificateAuthorities.size());
            int totalLength = 0;
            for (i = 0; i < this.certificateAuthorities.size(); ++i) {
                X500Name certificateAuthority = (X500Name)this.certificateAuthorities.elementAt(i);
                byte[] derEncoding = certificateAuthority.getEncoded("DER");
                derEncodings.addElement(derEncoding);
                totalLength += derEncoding.length + 2;
            }
            TlsUtils.checkUint16(totalLength);
            TlsUtils.writeUint16(totalLength, output);
            for (i = 0; i < derEncodings.size(); ++i) {
                byte[] derEncoding = (byte[])derEncodings.elementAt(i);
                TlsUtils.writeOpaque16(derEncoding, output);
            }
        }
    }

    public static CertificateRequest parse(TlsContext context, InputStream input) throws IOException {
        ProtocolVersion negotiatedVersion = context.getServerVersion();
        boolean isTLSv13 = TlsUtils.isTLSv13(negotiatedVersion);
        if (isTLSv13) {
            byte[] certificateRequestContext = TlsUtils.readOpaque8(input);
            byte[] extEncoding = TlsUtils.readOpaque16(input);
            Hashtable extensions = TlsProtocol.readExtensionsData13(13, extEncoding);
            Vector supportedSignatureAlgorithms = CertificateRequest.checkSupportedSignatureAlgorithms(TlsExtensionsUtils.getSignatureAlgorithmsExtension(extensions), (short)109);
            Vector supportedSignatureAlgorithmsCert = TlsExtensionsUtils.getSignatureAlgorithmsCertExtension(extensions);
            Vector certificateAuthorities = TlsExtensionsUtils.getCertificateAuthoritiesExtension(extensions);
            return new CertificateRequest(certificateRequestContext, supportedSignatureAlgorithms, supportedSignatureAlgorithmsCert, certificateAuthorities);
        }
        boolean isTLSv12 = TlsUtils.isTLSv12(negotiatedVersion);
        short[] certificateTypes = TlsUtils.readUint8ArrayWithUint8Length(input, 1);
        Vector supportedSignatureAlgorithms = null;
        if (isTLSv12) {
            supportedSignatureAlgorithms = TlsUtils.parseSupportedSignatureAlgorithms(input);
        }
        Vector<X500Name> certificateAuthorities = null;
        byte[] certAuthData = TlsUtils.readOpaque16(input);
        if (certAuthData.length > 0) {
            certificateAuthorities = new Vector<X500Name>();
            ByteArrayInputStream bis = new ByteArrayInputStream(certAuthData);
            do {
                byte[] derEncoding = TlsUtils.readOpaque16(bis, 1);
                ASN1Primitive asn1 = TlsUtils.readASN1Object(derEncoding);
                X500Name ca = X500Name.getInstance((Object)asn1);
                TlsUtils.requireDEREncoding((ASN1Object)ca, derEncoding);
                certificateAuthorities.addElement(ca);
            } while (bis.available() > 0);
        }
        return new CertificateRequest(certificateTypes, supportedSignatureAlgorithms, certificateAuthorities);
    }
}

