/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.provider.IDNUtil;
import org.bouncycastle.util.IPAddress;

class HostnameUtil {
    HostnameUtil() {
    }

    static void checkHostname(String hostname, X509Certificate certificate, boolean allWildcards) throws CertificateException {
        if (null == hostname) {
            throw new CertificateException("No hostname specified for HTTPS endpoint ID check");
        }
        if (IPAddress.isValid((String)hostname)) {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (null != subjectAltNames) {
                for (List<?> subjectAltName : subjectAltNames) {
                    int type = (Integer)subjectAltName.get(0);
                    if (7 != type) continue;
                    String ipAddress = (String)subjectAltName.get(1);
                    if (hostname.equalsIgnoreCase(ipAddress)) {
                        return;
                    }
                    try {
                        if (!InetAddress.getByName(hostname).equals(InetAddress.getByName(ipAddress))) continue;
                        return;
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                    catch (SecurityException securityException) {
                    }
                }
            }
            throw new CertificateException("No subject alternative name found matching IP address " + hostname);
        }
        if (HostnameUtil.isValidDomainName(hostname)) {
            ASN1Primitive commonName;
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (null != subjectAltNames) {
                boolean foundAnyDNSNames = false;
                for (List<?> subjectAltName : subjectAltNames) {
                    int type = (Integer)subjectAltName.get(0);
                    if (2 != type) continue;
                    foundAnyDNSNames = true;
                    String dnsName = (String)subjectAltName.get(1);
                    if (!HostnameUtil.matchesDNSName(hostname, dnsName, allWildcards)) continue;
                    return;
                }
                if (foundAnyDNSNames) {
                    throw new CertificateException("No subject alternative name found matching domain name " + hostname);
                }
            }
            if ((commonName = HostnameUtil.findMostSpecificCN(certificate.getSubjectX500Principal())) instanceof ASN1String && HostnameUtil.matchesDNSName(hostname, ((ASN1String)commonName).getString(), allWildcards)) {
                return;
            }
            throw new CertificateException("No name found matching " + hostname);
        }
        throw new CertificateException("Invalid hostname specified for HTTPS endpoint ID check");
    }

    private static ASN1Primitive findMostSpecificCN(X500Principal principal) {
        if (null != principal) {
            RDN[] rdns = X500Name.getInstance((Object)principal.getEncoded()).getRDNs();
            for (int i = rdns.length - 1; i >= 0; --i) {
                AttributeTypeAndValue[] typesAndValues = rdns[i].getTypesAndValues();
                for (int j = 0; j < typesAndValues.length; ++j) {
                    AttributeTypeAndValue typeAndValue = typesAndValues[j];
                    if (!BCStyle.CN.equals((ASN1Primitive)typeAndValue.getType())) continue;
                    return typeAndValue.getValue().toASN1Primitive();
                }
            }
        }
        return null;
    }

    private static String getLabel(String s, int begin) {
        int end = s.indexOf(46, begin);
        if (end < 0) {
            end = s.length();
        }
        return s.substring(begin, end);
    }

    private static boolean isValidDomainName(String name) {
        try {
            new BCSNIHostName(name);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static boolean labelMatchesPattern(String label, String pattern) {
        int wildcardPos = pattern.indexOf(42);
        if (wildcardPos < 0) {
            return label.equals(pattern);
        }
        int labelPos = 0;
        int patternPos = 0;
        do {
            String segment;
            int matchPos;
            if ((matchPos = label.indexOf(segment = pattern.substring(patternPos, wildcardPos), labelPos)) < 0 || patternPos == 0 && matchPos > 0) {
                return false;
            }
            labelPos = matchPos + segment.length();
        } while ((wildcardPos = pattern.indexOf(42, patternPos = wildcardPos + 1)) >= 0);
        String labelRest = label.substring(labelPos);
        String patternRest = pattern.substring(patternPos);
        return labelRest.endsWith(patternRest);
    }

    private static boolean matchesDNSName(String hostname, String dnsName, boolean allWildcards) {
        try {
            hostname = IDNUtil.toUnicode(IDNUtil.toASCII(hostname, 0), 0);
            dnsName = IDNUtil.toUnicode(IDNUtil.toASCII(dnsName, 0), 0);
        }
        catch (RuntimeException e) {
            return false;
        }
        if (!HostnameUtil.validateWildcards(dnsName)) {
            return false;
        }
        if (!HostnameUtil.isValidDomainName(dnsName.replace('*', 'z'))) {
            return false;
        }
        hostname = hostname.toLowerCase(Locale.ENGLISH);
        dnsName = dnsName.toLowerCase(Locale.ENGLISH);
        return allWildcards ? HostnameUtil.matchesWildcardsAllLabels(hostname, dnsName) : HostnameUtil.matchesWildcardsFirstLabel(hostname, dnsName);
    }

    private static boolean matchesWildcardsAllLabels(String hostname, String dnsName) {
        StringTokenizer st1 = new StringTokenizer(hostname, ".");
        StringTokenizer st2 = new StringTokenizer(dnsName, ".");
        if (st1.countTokens() != st2.countTokens()) {
            return false;
        }
        while (st1.hasMoreTokens()) {
            String pattern;
            String label = st1.nextToken();
            if (HostnameUtil.labelMatchesPattern(label, pattern = st2.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesWildcardsFirstLabel(String hostname, String dnsName) {
        String dnsNameLabel;
        String hostnameLabel = HostnameUtil.getLabel(hostname, 0);
        if (!HostnameUtil.labelMatchesPattern(hostnameLabel, dnsNameLabel = HostnameUtil.getLabel(dnsName, 0))) {
            return false;
        }
        String hostnameRest = hostname.substring(hostnameLabel.length());
        String dnsNameRest = dnsName.substring(dnsNameLabel.length());
        return hostnameRest.equals(dnsNameRest);
    }

    private static boolean validateWildcards(String dnsName) {
        int wildCardIndex = dnsName.lastIndexOf(42);
        if (wildCardIndex >= 0) {
            if (dnsName.equals("*") || dnsName.equals("*.")) {
                return false;
            }
            int dotIndex = dnsName.indexOf(46, wildCardIndex + 1);
            if (dotIndex < 0) {
                return false;
            }
        }
        return true;
    }
}

