/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLParameters;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils_7;
import org.bouncycastle.jsse.provider.JsseUtils_8;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ReflectionUtil;

abstract class SSLParametersUtil {
    private static final Method getAlgorithmConstraints;
    private static final Method setAlgorithmConstraints;
    private static final Method getApplicationProtocols;
    private static final Method setApplicationProtocols;
    private static final Method getEndpointIdentificationAlgorithm;
    private static final Method setEndpointIdentificationAlgorithm;
    private static final Method getServerNames;
    private static final Method setServerNames;
    private static final Method getSNIMatchers;
    private static final Method setSNIMatchers;
    private static final Method getUseCipherSuitesOrder;
    private static final Method setUseCipherSuitesOrder;
    private static final Method getMaximumPacketSize;
    private static final Method setMaximumPacketSize;

    SSLParametersUtil() {
    }

    static BCSSLParameters getParameters(ProvSSLParameters prov) {
        BCSSLParameters ssl = new BCSSLParameters(prov.getCipherSuites(), prov.getProtocols());
        if (prov.getNeedClientAuth()) {
            ssl.setNeedClientAuth(true);
        } else {
            ssl.setWantClientAuth(prov.getWantClientAuth());
        }
        ssl.setAlgorithmConstraints(prov.getAlgorithmConstraints());
        ssl.setEndpointIdentificationAlgorithm(prov.getEndpointIdentificationAlgorithm());
        ssl.setUseCipherSuitesOrder(prov.getUseCipherSuitesOrder());
        ssl.setServerNames(prov.getServerNames());
        ssl.setSNIMatchers(prov.getSNIMatchers());
        ssl.setApplicationProtocols(prov.getApplicationProtocols());
        ssl.setMaximumPacketSize(prov.getMaximumPacketSize());
        return ssl;
    }

    static SSLParameters getSSLParameters(ProvSSLParameters prov) {
        String[] applicationProtocols;
        Collection<BCSNIMatcher> matchers;
        List<BCSNIServerName> serverNames;
        SSLParameters ssl = new SSLParameters(prov.getCipherSuites(), prov.getProtocols());
        if (prov.getNeedClientAuth()) {
            ssl.setNeedClientAuth(true);
        } else {
            ssl.setWantClientAuth(prov.getWantClientAuth());
        }
        if (null != setAlgorithmConstraints) {
            SSLParametersUtil.set(ssl, setAlgorithmConstraints, JsseUtils_7.exportAlgorithmConstraintsDynamic(prov.getAlgorithmConstraints()));
        }
        if (null != setEndpointIdentificationAlgorithm) {
            SSLParametersUtil.set(ssl, setEndpointIdentificationAlgorithm, prov.getEndpointIdentificationAlgorithm());
        }
        if (null != setUseCipherSuitesOrder) {
            SSLParametersUtil.set(ssl, setUseCipherSuitesOrder, prov.getUseCipherSuitesOrder());
        }
        if (null != setServerNames && null != (serverNames = prov.getServerNames())) {
            SSLParametersUtil.set(ssl, setServerNames, JsseUtils_8.exportSNIServerNamesDynamic(serverNames));
        }
        if (null != setSNIMatchers && null != (matchers = prov.getSNIMatchers())) {
            SSLParametersUtil.set(ssl, setSNIMatchers, JsseUtils_8.exportSNIMatchersDynamic(matchers));
        }
        if (null != setApplicationProtocols && null != (applicationProtocols = prov.getApplicationProtocols())) {
            SSLParametersUtil.set(ssl, setApplicationProtocols, applicationProtocols);
        }
        if (null != setMaximumPacketSize) {
            SSLParametersUtil.set(ssl, setMaximumPacketSize, prov.getMaximumPacketSize());
        }
        return ssl;
    }

    static BCSSLParameters importSSLParameters(SSLParameters ssl) {
        String[] applicationProtocols;
        Object matchers;
        Object serverNames;
        String endpointIdentificationAlgorithm;
        Object constraints;
        BCSSLParameters bc = new BCSSLParameters(ssl.getCipherSuites(), ssl.getProtocols());
        if (ssl.getNeedClientAuth()) {
            bc.setNeedClientAuth(true);
        } else {
            bc.setWantClientAuth(ssl.getWantClientAuth());
        }
        if (null != getAlgorithmConstraints && null != (constraints = SSLParametersUtil.get(ssl, getAlgorithmConstraints))) {
            bc.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraintsDynamic(constraints));
        }
        if (null != getEndpointIdentificationAlgorithm && null != (endpointIdentificationAlgorithm = (String)SSLParametersUtil.get(ssl, getEndpointIdentificationAlgorithm))) {
            bc.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        if (null != getUseCipherSuitesOrder) {
            bc.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.get(ssl, getUseCipherSuitesOrder));
        }
        if (null != getServerNames && null != (serverNames = SSLParametersUtil.get(ssl, getServerNames))) {
            bc.setServerNames(JsseUtils_8.importSNIServerNamesDynamic(serverNames));
        }
        if (null != getSNIMatchers && null != (matchers = SSLParametersUtil.get(ssl, getSNIMatchers))) {
            bc.setSNIMatchers(JsseUtils_8.importSNIMatchersDynamic(matchers));
        }
        if (null != getApplicationProtocols && null != (applicationProtocols = (String[])SSLParametersUtil.get(ssl, getApplicationProtocols))) {
            bc.setApplicationProtocols(applicationProtocols);
        }
        if (null != getMaximumPacketSize) {
            bc.setMaximumPacketSize((Integer)SSLParametersUtil.get(ssl, getMaximumPacketSize));
        }
        return bc;
    }

    static void setParameters(ProvSSLParameters prov, BCSSLParameters ssl) {
        String[] applicationProtocols;
        Collection<BCSNIMatcher> sniMatchers;
        String endpointIdentificationAlgorithm;
        String[] protocols;
        String[] cipherSuites = ssl.getCipherSuites();
        if (null != cipherSuites) {
            prov.setCipherSuites(cipherSuites);
        }
        if (null != (protocols = ssl.getProtocols())) {
            prov.setProtocols(protocols);
        }
        if (ssl.getNeedClientAuth()) {
            prov.setNeedClientAuth(true);
        } else {
            prov.setWantClientAuth(ssl.getWantClientAuth());
        }
        BCAlgorithmConstraints algorithmConstraints = ssl.getAlgorithmConstraints();
        if (null != algorithmConstraints) {
            prov.setAlgorithmConstraints(algorithmConstraints);
        }
        if (null != (endpointIdentificationAlgorithm = ssl.getEndpointIdentificationAlgorithm())) {
            prov.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        prov.setUseCipherSuitesOrder(ssl.getUseCipherSuitesOrder());
        List<BCSNIServerName> serverNames = ssl.getServerNames();
        if (null != serverNames) {
            prov.setServerNames(serverNames);
        }
        if (null != (sniMatchers = ssl.getSNIMatchers())) {
            prov.setSNIMatchers(sniMatchers);
        }
        if (null != (applicationProtocols = ssl.getApplicationProtocols())) {
            prov.setApplicationProtocols(applicationProtocols);
        }
        prov.setMaximumPacketSize(ssl.getMaximumPacketSize());
    }

    static void setSSLParameters(ProvSSLParameters prov, SSLParameters ssl) {
        String[] applicationProtocols;
        Object matchers;
        Object serverNames;
        String endpointIdentificationAlgorithm;
        Object constraints;
        String[] protocols;
        String[] cipherSuites = ssl.getCipherSuites();
        if (null != cipherSuites) {
            prov.setCipherSuites(cipherSuites);
        }
        if (null != (protocols = ssl.getProtocols())) {
            prov.setProtocols(protocols);
        }
        if (ssl.getNeedClientAuth()) {
            prov.setNeedClientAuth(true);
        } else {
            prov.setWantClientAuth(ssl.getWantClientAuth());
        }
        if (null != getAlgorithmConstraints && null != (constraints = SSLParametersUtil.get(ssl, getAlgorithmConstraints))) {
            prov.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraintsDynamic(constraints));
        }
        if (null != getEndpointIdentificationAlgorithm && null != (endpointIdentificationAlgorithm = (String)SSLParametersUtil.get(ssl, getEndpointIdentificationAlgorithm))) {
            prov.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        if (null != getUseCipherSuitesOrder) {
            prov.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.get(ssl, getUseCipherSuitesOrder));
        }
        if (null != getServerNames && null != (serverNames = SSLParametersUtil.get(ssl, getServerNames))) {
            prov.setServerNames(JsseUtils_8.importSNIServerNamesDynamic(serverNames));
        }
        if (null != getSNIMatchers && null != (matchers = SSLParametersUtil.get(ssl, getSNIMatchers))) {
            prov.setSNIMatchers(JsseUtils_8.importSNIMatchersDynamic(matchers));
        }
        if (null != getApplicationProtocols && null != (applicationProtocols = (String[])SSLParametersUtil.get(ssl, getApplicationProtocols))) {
            prov.setApplicationProtocols(applicationProtocols);
        }
        if (null != getMaximumPacketSize) {
            prov.setMaximumPacketSize((Integer)SSLParametersUtil.get(ssl, getMaximumPacketSize));
        }
    }

    private static Object get(Object obj, Method method) {
        return ReflectionUtil.invokeGetter(obj, method);
    }

    private static void set(Object obj, Method method, Object arg) {
        ReflectionUtil.invokeSetter(obj, method, arg);
    }

    static {
        Method[] methods = ReflectionUtil.getMethods("javax.net.ssl.SSLParameters");
        getAlgorithmConstraints = ReflectionUtil.findMethod(methods, "getAlgorithmConstraints");
        setAlgorithmConstraints = ReflectionUtil.findMethod(methods, "setAlgorithmConstraints");
        getApplicationProtocols = ReflectionUtil.findMethod(methods, "getApplicationProtocols");
        setApplicationProtocols = ReflectionUtil.findMethod(methods, "setApplicationProtocols");
        getEndpointIdentificationAlgorithm = ReflectionUtil.findMethod(methods, "getEndpointIdentificationAlgorithm");
        setEndpointIdentificationAlgorithm = ReflectionUtil.findMethod(methods, "setEndpointIdentificationAlgorithm");
        getServerNames = ReflectionUtil.findMethod(methods, "getServerNames");
        setServerNames = ReflectionUtil.findMethod(methods, "setServerNames");
        getSNIMatchers = ReflectionUtil.findMethod(methods, "getSNIMatchers");
        setSNIMatchers = ReflectionUtil.findMethod(methods, "setSNIMatchers");
        getUseCipherSuitesOrder = ReflectionUtil.findMethod(methods, "getUseCipherSuitesOrder");
        setUseCipherSuitesOrder = ReflectionUtil.findMethod(methods, "setUseCipherSuitesOrder");
        getMaximumPacketSize = ReflectionUtil.findMethod(methods, "getMaximumPacketSize");
        setMaximumPacketSize = ReflectionUtil.findMethod(methods, "setMaximumPacketSize");
    }
}

