/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoProvider;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

public class JcaTlsCryptoProvider
implements TlsCryptoProvider {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcaTlsCryptoProvider setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcaTlsCryptoProvider setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public TlsCrypto create(SecureRandom random) {
        try {
            if (random == null) {
                random = this.helper instanceof DefaultJcaJceHelper ? SecureRandom.getInstance("DEFAULT") : SecureRandom.getInstance("DEFAULT", this.helper.createMessageDigest("SHA-512").getProvider());
            }
            return this.create(random, new NonceEntropySource(this.helper, random));
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to create JcaTlsCrypto: " + e.getMessage(), e);
        }
    }

    public TlsCrypto create(SecureRandom keyRandom, SecureRandom nonceRandom) {
        return new JcaTlsCrypto(this.helper, keyRandom, nonceRandom);
    }

    public JcaJceHelper getHelper() {
        return this.helper;
    }

    private static class NonceEntropySource
    extends SecureRandom {
        NonceEntropySource(JcaJceHelper helper, SecureRandom random) throws GeneralSecurityException {
            super(new NonceEntropySourceSpi(random, helper.createMessageDigest("SHA-512")), random.getProvider());
        }

        private static class NonceEntropySourceSpi
        extends SecureRandomSpi {
            private final SecureRandom source;
            private final MessageDigest digest;
            private final byte[] seed;
            private final byte[] state;

            NonceEntropySourceSpi(SecureRandom source, MessageDigest digest) {
                this.source = source;
                this.digest = digest;
                this.seed = source.generateSeed(digest.getDigestLength());
                this.state = new byte[this.seed.length];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void engineSetSeed(byte[] bytes) {
                MessageDigest messageDigest = this.digest;
                synchronized (messageDigest) {
                    this.runDigest(this.seed, bytes, this.seed);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void engineNextBytes(byte[] bytes) {
                MessageDigest messageDigest = this.digest;
                synchronized (messageDigest) {
                    int stateOff = this.state.length;
                    for (int i = 0; i != bytes.length; ++i) {
                        if (stateOff == this.state.length) {
                            this.source.nextBytes(this.state);
                            this.runDigest(this.seed, this.state, this.state);
                            stateOff = 0;
                        }
                        bytes[i] = this.state[stateOff++];
                    }
                }
            }

            protected byte[] engineGenerateSeed(int seedLen) {
                return this.source.generateSeed(seedLen);
            }

            private void runDigest(byte[] x, byte[] y, byte[] z) {
                this.digest.update(x);
                this.digest.update(y);
                try {
                    this.digest.digest(z, 0, z.length);
                }
                catch (DigestException e) {
                    throw Exceptions.illegalStateException("unable to generate nonce data: " + e.getMessage(), e);
                }
            }
        }
    }
}

