/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto;

import java.io.IOException;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;

public class TlsHybridAgreement
implements TlsAgreement {
    private final TlsCrypto crypto;
    private final TlsAgreement firstAgreement;
    private final TlsAgreement secondAgreement;
    private final int peerValueSplit;

    public TlsHybridAgreement(TlsCrypto crypto, TlsAgreement firstAgreement, TlsAgreement secondAgreement, int peerValueSplit) {
        this.crypto = crypto;
        this.firstAgreement = firstAgreement;
        this.secondAgreement = secondAgreement;
        this.peerValueSplit = peerValueSplit;
    }

    public byte[] generateEphemeral() throws IOException {
        byte[] firstEphemeral = this.firstAgreement.generateEphemeral();
        byte[] secondEphemeral = this.secondAgreement.generateEphemeral();
        return Arrays.concatenate((byte[])firstEphemeral, (byte[])secondEphemeral);
    }

    public void receivePeerValue(byte[] peerValue) throws IOException {
        if (peerValue.length < this.peerValueSplit) {
            throw new IllegalArgumentException("'peerValue' is too short");
        }
        this.firstAgreement.receivePeerValue(Arrays.copyOfRange((byte[])peerValue, (int)0, (int)this.peerValueSplit));
        this.secondAgreement.receivePeerValue(Arrays.copyOfRange((byte[])peerValue, (int)this.peerValueSplit, (int)peerValue.length));
    }

    public TlsSecret calculateSecret() throws IOException {
        TlsSecret firstSecret = this.firstAgreement.calculateSecret();
        TlsSecret secondSecret = this.secondAgreement.calculateSecret();
        return this.crypto.createHybridSecret(firstSecret, secondSecret);
    }
}

